//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.util;

import java.util.List;

import com.google.common.collect.Iterables;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNodeFactory;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class PatternsVisitorUtil {

    private PatternsVisitorUtil() {
        // no instantiation
    }
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param taskTreeNode
     * @return
     */
    public static ITaskTree createTaskTreeFromNode(ITaskTreeNode taskTreeNode) {
        return new TaskTreeNodeFactory().createTaskTree(taskTreeNode);
    }
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param taskTreeNodes
     * @return
     */
    public static ITaskTreeNode firstNodeOf(List<ITaskTreeNode> taskTreeNodes) {
        return Iterables.getFirst(taskTreeNodes, new NullNode());
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param taskTreeNodes
     * @return
     */
    public static ITaskTreeNode lastNodeOf(List<ITaskTreeNode> taskTreeNodes) {
        return Iterables.getLast(taskTreeNodes, new NullNode());
    }
    
}
