//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns;

import static de.ugoe.cs.autoquest.usability.testutil.FestConditionUtil.absent;
import static de.ugoe.cs.autoquest.usability.testutil.FestConditionUtil.present;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskTreeUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class LongFormUsageDefectTest {

    @Test
    public void should_be_present() {
        // Given
        String spec = "Sequence {" +
        	      "  Selection {" +
        	      "     MouseClick() {}" +
        	      "     Sequence() {" +
        	      "       MouseClick() {}" +
        	      "       Iteration {" +
        	      "         Sequence {" +
        	      "           TextInput() {}" +
        	      "           Scroll () {}" +
        	      "         }" +
        	      "       }" +
        	      "       MouseClick() {}" +
        	      "     }" + 
                      "  }" + 
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        // When
        Optional<UsabilityDefect> recommendation = new LongFormUsageDefect(taskTree).check();
        // Then
        assertThat(recommendation).is(present());
    }
    
    @Test
    public void should_be_absent() {
        // Given
        String spec = "Sequence {" +
                      "  Selection {" +
                      "     MouseClick() {}" +
                      "     Sequence() {" +
                      "       MouseClick() {}" +
                      "       TextInput() {}" +
                      "       Iteration {" +
                      "         Scroll () {}" +
                      "       }" +
                      "       MouseClick() {}" +
                      "     }" + 
                      "  }" + 
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        // When
        Optional<UsabilityDefect> recommendation = new LongFormUsageDefect(taskTree).check();
        // Then
        assertThat(recommendation).is(absent());
    }

}
