//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.tasktree.filters;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.guimodel.ITextArea;
import de.ugoe.cs.autoquest.eventcore.guimodel.ITextField;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public enum EventTargetFilter implements TaskFilter<IEventTarget> {

    TEXT_FIELD(ITextField.class),

    TEXT_AREA(ITextArea.class);

    private Class<? extends IEventTarget> eventTargetClazz;

    private EventTargetFilter(Class<? extends IEventTarget> eventTargetClazz) {
        this.eventTargetClazz = eventTargetClazz;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<IEventTarget> clazz() {
        return (Class<IEventTarget>) eventTargetClazz;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Predicate filterPredicate() {
        Predicate<Object> instanceOfIEventTaskPredicate = Predicates.instanceOf(IEventTask.class);
        Predicate<ITask> taskHoldsInstanceOfFilterArgument =
            Predicates.compose(Predicates.instanceOf(eventTargetClazz), taskExtractionFunction());
        return Predicates.and(instanceOfIEventTaskPredicate, taskHoldsInstanceOfFilterArgument);
    }

    private Function<ITask, IEventTarget> taskExtractionFunction() {
        return new Function<ITask, IEventTarget>() {

            @Override
            public IEventTarget apply(ITask task) {
                return ((IEventTask) task).getEventTarget();
            }
        };
    }

}
