//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
class UserSession implements IUserSession {
    
    /**  */
    private static final long serialVersionUID = 1L;
    /**
     * 
     */
    private List<ITaskInstance> executedTasks = new LinkedList<ITaskInstance>();

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceList#get(int)
     */
    @Override
    public ITaskInstance get(int index) {
        return executedTasks.get(index);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceList#size()
     */
    @Override
    public int size() {
        return executedTasks.size();
    }

    /* (non-Javadoc)
     * @see java.lang.Iterable#iterator()
     */
    @Override
    public Iterator<ITaskInstance> iterator() {
        return executedTasks.iterator();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession#getExecutedTasks()
     */
    @Override
    public List<ITaskInstance> getExecutedTasks() {
        return Collections.unmodifiableList(executedTasks);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.TaskTreeNode#equals(TaskTreeNode)
     */
    @Override
    public boolean equals(IUserSession userSession) {
        // task instances are only equal if they are identical or if they have the same id
        // (may happen, if they are cloned)
        return (this == userSession) || (this.hashCode() == userSession.hashCode());
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public synchronized String toString() {
        return "session (" + executedTasks.size() + " task instances)";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#clone()
     */
    @Override
    public synchronized IUserSession clone() {
        UserSession clone = null;
        try {
            clone = (UserSession) super.clone();

            clone.executedTasks = new LinkedList<ITaskInstance>();
            
            for (ITaskInstance child : executedTasks) {
                clone.executedTasks.add(child.clone());
            }

        }
        catch (CloneNotSupportedException e) {
            // this should never happen. Therefore simply dump the exception
            e.printStackTrace();
        }

        return clone;
    }

    /**
     *
     */
    void addExecutedTask(ITaskInstance taskInstance) {
        executedTasks.add(taskInstance);
    }

    /**
     *
     */
    void addExecutedTask(int index, ITaskInstance taskInstance) {
        executedTasks.add(index, taskInstance);
    }

    /**
     *
     */
    void removeExecutedTask(int index) {
        executedTasks.remove(index);
    }

}
