//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.util.List;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.CommandHelpers;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.rules.EmptyRuleset;
import de.ugoe.cs.autoquest.usability.rules.UsabilityResult;
import de.ugoe.cs.autoquest.usability.rules.UsabilityRuleset;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class CMDperformUsabilityEvaluation implements Command {

    private final int taskTreeParamaterIndex = 0;
    
    private final int evaluationResultParameterIndex = 1;
    
    private final String defaultEvaluationResultParameterName = "usabilityEvaluationResult";
    
    private final UsabilityRuleset defaultUsabilityRuleset = new EmptyRuleset();
    
    /* (non-Javadoc)
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String nameOfTaskTree = getTaskTreeParameter(parameters);
        Optional<ITaskModel> taskModel = getTaskModelFromDataContainer(nameOfTaskTree);
        if (taskModel.isPresent()) {
            UsabilityRuleset ruleset = getUsabilityRuleset();
            UsabilityResult result = UsabilityEvaluator.evaluate(taskModel.get()).using(ruleset);
            String evaluationResultParameterName = getEvaluationResultParameter(parameters);
            storeUsabilityResultInDataContainer(evaluationResultParameterName, result);
        }
        return;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param parameters
     * @return
     */
    private String getTaskTreeParameter(List<Object> parameters) {
        try {
            return (String) parameters.get(taskTreeParamaterIndex);
        } catch (Exception e) {
            throw new IllegalArgumentException("must provide a task tree name");
        }
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param parameters
     * @return
     */
    private String getEvaluationResultParameter(List<Object> parameters) {
        if(parameters.size() == 2) {
            return (String) parameters.get(evaluationResultParameterIndex);
        }
        return defaultEvaluationResultParameterName;
    }
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param nameOfTaskTree
     * @return
     */
    private Optional<ITaskModel> getTaskModelFromDataContainer(String nameOfTaskTree) {
        Object dataObject = GlobalDataContainer.getInstance().getData(nameOfTaskTree);
        if(dataObject != null) {
            if(dataObject instanceof ITaskModel) {
                ITaskModel taskTree = (ITaskModel) dataObject;
                return Optional.of(taskTree);
            } else {
                CommandHelpers.objectNotType(nameOfTaskTree, "ITaskModel");
                return Optional.absent();
            }
        }
        CommandHelpers.objectNotFoundMessage(nameOfTaskTree);
        return Optional.absent();
    }
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    private UsabilityRuleset getUsabilityRuleset() {
        // TODO Auto-generated method stub
        System.out.println("TODO: implement CMDperformUsabilityEvaluation.getUsabilityRuleset ");
        return this.defaultUsabilityRuleset;
    }
    
    /**
     * <p>
     * TODO: comment
     * </p>
     * @param evaluationResultParameterName 
     *
     */
    private void storeUsabilityResultInDataContainer(String evaluationResultParameterName, UsabilityResult result) {
        if (GlobalDataContainer.getInstance().addData(evaluationResultParameterName, result)) {
            CommandHelpers.dataOverwritten(evaluationResultParameterName);
        }   
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "peformUsabilityEvaluation <taskTree> {evaluationResult}";
    }

}
