//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import static org.fest.assertions.api.Assertions.assertThat;

import java.util.List;

import org.junit.Test;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.rules.UsabilityResult;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskTreeUtil;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class CMDperformUsabilityEvaluationTest {

    /**
     * Test method for {@link de.ugoe.cs.autoquest.usability.CMDperformUsabilityEvaluation#run(java.util.List)}.
     */
    @Test(expected = IllegalArgumentException.class)
    public void run_without_parameter_set() {
        new CMDperformUsabilityEvaluation().run(Lists.newArrayList());
    }
    
    /**
     * Test method for {@link de.ugoe.cs.autoquest.usability.CMDperformUsabilityEvaluation#run(java.util.List)}.
     */
    public void run_without_evaluation_result_parameter_set_and_no_task_tree_in_data_container() {
        List<?> parameters = Lists.newArrayList("taskTree");
        new CMDperformUsabilityEvaluation().run((List<Object>) parameters);
        assertThat(getUsabilityEvaluationResult("usabilityEvaluationResult").isPresent()).isFalse();
    }

    private Optional<UsabilityResult> getUsabilityEvaluationResult(String evaluationResultParameter) {
        UsabilityResult result = (UsabilityResult) GlobalDataContainer.getInstance().getData(evaluationResultParameter);
        return Optional.fromNullable(result);
    }
    
    /**
     * Test method for {@link de.ugoe.cs.autoquest.usability.CMDperformUsabilityEvaluation#run(java.util.List)}.
     */
    @Test
    public void run_with_all_parameter_set_and_no_task_tree_in_data_container() {
        List<?> parameters = Lists.newArrayList("taskTree", "evaluationResult");
        new CMDperformUsabilityEvaluation().run((List<Object>) parameters);
        assertThat(getUsabilityEvaluationResult("evaluationResult").isPresent()).isFalse();

    }
    
    /**
     * Test method for {@link de.ugoe.cs.autoquest.usability.CMDperformUsabilityEvaluation#run(java.util.List)}.
     */
    @Test
    public void run_with_more_parameter_set_and_no_task_tree_in_data_container() {
        List<?> parameters = Lists.newArrayList("taskTree", "evaluationResult", "dummyParameter");
        new CMDperformUsabilityEvaluation().run((List<Object>) parameters);
        assertThat(getUsabilityEvaluationResult("evaluationResult").isPresent()).isFalse();

    }
    
    /**
     * Test method for {@link de.ugoe.cs.autoquest.usability.CMDperformUsabilityEvaluation#run(java.util.List)}.
     */
    @Test
    public void run_with_all_parameter_set_and_task_tree_in_data_container() {
        String spec = "EventTask target1 {}";
        storeInDataContainer(GenerateTaskTreeUtil.getTaskTreeFromSpec(spec));
        List<?> parameters = Lists.newArrayList("taskTree", "evaluationResult");
        new CMDperformUsabilityEvaluation().run((List<Object>) parameters);
        assertThat(getUsabilityEvaluationResult("evaluationResult").isPresent()).isTrue();

    }

    private void storeInDataContainer(ITaskTree taskTree) {
        GlobalDataContainer.getInstance().addData("taskTree", taskTree);
    }
    
    /**
     * Test method for {@link de.ugoe.cs.autoquest.usability.CMDperformUsabilityEvaluation#help()}.
     */
    @Test
    public void print_help_text() {
        String helpText = new CMDperformUsabilityEvaluation().help();
        assertThat(helpText).isEqualToIgnoringCase("peformUsabilityEvaluation <taskTree> {evaluationResult}");
    }

}
