/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.ApplyNewFilter;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.BugRenderer;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterFromBugPicker;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.MainFrameHelper;
import edu.umd.cs.findbugs.gui2.NewFilterFromBug;
import edu.umd.cs.findbugs.gui2.PreferencesFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterDialog;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import edu.umd.cs.findbugs.gui2.SwingThread;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreePath;

public class MainFrameTree
implements Serializable {
    private final MainFrame mainFrame;
    JTree tree;
    SorterTableColumnModel sorter;
    JTableHeader tableheader;
    BugLeafNode currentSelectedBugLeaf;
    JPanel treePanel;
    JScrollPane treeScrollPane;
    JPopupMenu bugPopupMenu;
    JPopupMenu branchPopupMenu;
    JPanel cardPanel;
    private JTextField textFieldForPackagesToDisplay;
    private JLabel waitStatusLabel;

    public MainFrameTree(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void newTree(final JTree newTree, final BugTreeModel newModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrameTree.this.tree = newTree;
                MainFrameTree.this.tree.getSelectionModel().setSelectionMode(1);
                MainFrameTree.this.tree.setLargeModel(true);
                MainFrameTree.this.tree.setCellRenderer(new BugRenderer());
                MainFrameTree.this.treePanel.remove(MainFrameTree.this.treeScrollPane);
                MainFrameTree.this.treeScrollPane = new JScrollPane(newTree);
                MainFrameTree.this.treePanel.add(MainFrameTree.this.treeScrollPane);
                MainFrameTree.this.mainFrame.setFontSizeHelper(Driver.getFontSize(), MainFrameTree.this.treeScrollPane);
                MainFrameTree.this.tree.setRowHeight((int)(Driver.getFontSize() + 7.0f));
                MainFrameTree.this.mainFrame.getContentPane().validate();
                MainFrameTree.this.mainFrame.getContentPane().repaint();
                MainFrameTree.this.setupTreeListeners();
                newModel.openPreviouslySelected(((BugTreeModel)MainFrameTree.this.tree.getModel()).getOldSelectedBugs());
                MainFrameTree.this.expandTree(10);
                MainFrameTree.this.expandToFirstLeaf(14);
                MainFrameTree.this.mainFrame.getSorter().addColumnModelListener(newModel);
                FilterActivity.addFilterListener(newModel.bugTreeFilterListener);
                ((MainFrameTree)MainFrameTree.this).mainFrame.mainFrameTree.setSorting(true);
            }
        });
    }

    public JTree getTree() {
        return this.tree;
    }

    public BugTreeModel getBugTreeModel() {
        return (BugTreeModel)this.getTree().getModel();
    }

    public Sortables[] getAvailableSortables() {
        ArrayList<Sortables> a = new ArrayList<Sortables>(Sortables.values().length);
        for (Sortables s : Sortables.values()) {
            if (!s.isAvailable(this.mainFrame)) continue;
            a.add(s);
        }
        Sortables[] sortables = new Sortables[a.size()];
        a.toArray(sortables);
        return sortables;
    }

    SorterTableColumnModel getSorter() {
        return this.sorter;
    }

    void rebuildBugTreeIfSortablesDependOnCloud() {
        BugTreeModel bt = (BugTreeModel)this.mainFrame.getTree().getModel();
        List<Sortables> sortables = this.sorter.getOrderBeforeDivider();
        if (sortables.contains(Sortables.DESIGNATION) || sortables.contains(Sortables.FIRST_SEEN) || sortables.contains(Sortables.FIRSTVERSION) || sortables.contains(Sortables.LASTVERSION)) {
            bt.rebuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBugTree() {
        this.mainFrame.acquireDisplayWait();
        try {
            BugTreeModel model = (BugTreeModel)this.getTree().getModel();
            BugSet bs = this.mainFrame.getBugCollection() != null ? new BugSet(this.mainFrame.getBugCollection()) : new BugSet(Collections.emptySet());
            model.getOffListenerList();
            model.changeSet(bs);
            if (bs.size() == 0 && bs.sizeUnfiltered() > 0) {
                this.warnUserOfFilters();
            }
            this.mainFrame.updateStatusBar();
            this.mainFrame.updateTitle();
        }
        finally {
            this.mainFrame.releaseDisplayWait();
        }
    }

    private void warnUserOfFilters() {
        JOptionPane.showMessageDialog(this.mainFrame, L10N.getLocalString("dlg.everything_is_filtered", "All bugs in this project appear to be filtered out.  \nYou may wish to check your filter settings in the preferences menu."), "Warning", 2);
    }

    JPopupMenu createBugPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem filterMenuItem = MainFrameHelper.newJMenuItem("menu.filterBugsLikeThis", "Filter bugs like this");
        filterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!MainFrameTree.this.mainFrame.canNavigateAway()) {
                    return;
                }
                new NewFilterFromBug(new FilterFromBugPicker(MainFrameTree.this.currentSelectedBugLeaf.getBug(), Arrays.asList(MainFrameTree.this.mainFrame.getAvailableSortables())), new ApplyNewFilter(MainFrameTree.this.mainFrame.getProject().getSuppressionFilter(), PreferencesFrame.getInstance(), new FilterActivity.FilterActivityNotifier()));
                MainFrameTree.this.mainFrame.setProjectChanged(true);
                MainFrameTree.this.mainFrame.getTree().setSelectionRow(0);
            }
        });
        popupMenu.add(filterMenuItem);
        JMenu changeDesignationMenu = MainFrameHelper.newJMenu("menu.changeDesignation", "Change bug designation");
        int i = 0;
        int[] keyEvents = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
        for (String key : I18N.instance().getUserDesignationKeys(true)) {
            String name = I18N.instance().getUserDesignation(key);
            this.mainFrame.addDesignationItem(changeDesignationMenu, key, name, keyEvents[i++]);
        }
        popupMenu.add(changeDesignationMenu);
        return popupMenu;
    }

    JPopupMenu createBranchPopUpMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem filterMenuItem = MainFrameHelper.newJMenuItem("menu.filterTheseBugs", "Filter these bugs");
        filterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreePath path;
                    if (!MainFrameTree.this.mainFrame.canNavigateAway()) {
                        return;
                    }
                    TreePath deletePath = path = MainFrame.getInstance().getTree().getSelectionPath();
                    int startCount = ((BugAspects)path.getLastPathComponent()).getCount();
                    int count = ((BugAspects)path.getParentPath().getLastPathComponent()).getCount();
                    while (count == startCount) {
                        if ((deletePath = deletePath.getParentPath()).getParentPath() == null) {
                            Matcher m = MainFrameTree.this.mainFrame.getCurrentSelectedBugAspects().getMatcher();
                            Filter suppressionFilter = MainFrame.getInstance().getProject().getSuppressionFilter();
                            suppressionFilter.addChild(m);
                            PreferencesFrame.getInstance().updateFilterPanel();
                            FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
                            return;
                        }
                        count = ((BugAspects)deletePath.getParentPath().getLastPathComponent()).getCount();
                    }
                    BugTreeModel model = MainFrame.getInstance().getBugTreeModel();
                    TreeModelEvent event = new TreeModelEvent((Object)MainFrameTree.this.mainFrame, deletePath.getParentPath(), new int[]{model.getIndexOfChild(deletePath.getParentPath().getLastPathComponent(), deletePath.getLastPathComponent())}, new Object[]{deletePath.getLastPathComponent()});
                    Matcher m = MainFrameTree.this.mainFrame.getCurrentSelectedBugAspects().getMatcher();
                    Filter suppressionFilter = MainFrame.getInstance().getProject().getSuppressionFilter();
                    suppressionFilter.addChild(m);
                    PreferencesFrame.getInstance().updateFilterPanel();
                    model.sendEvent(event, BugTreeModel.TreeModification.REMOVE);
                    MainFrameTree.this.mainFrame.setProjectChanged(true);
                    MainFrame.getInstance().getTree().setSelectionRow(0);
                }
                catch (RuntimeException e) {
                    MainFrame.getInstance().showMessageDialog("Unable to create filter: " + e.getMessage());
                }
            }
        });
        popupMenu.add(filterMenuItem);
        JMenu changeDesignationMenu = MainFrameHelper.newJMenu("menu.changeDesignation", "Change bug designation");
        int i = 0;
        int[] keyEvents = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
        for (String key : I18N.instance().getUserDesignationKeys(true)) {
            String name = I18N.instance().getUserDesignation(key);
            this.mainFrame.addDesignationItem(changeDesignationMenu, key, name, keyEvents[i++]);
        }
        popupMenu.add(changeDesignationMenu);
        return popupMenu;
    }

    ActionListener treeActionAdapter(ActionMap map, String actionName) {
        final Action selectPrevious = map.get(actionName);
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                e.setSource(MainFrameTree.this.tree);
                selectPrevious.actionPerformed(e);
            }
        };
    }

    @SwingThread
    void expandTree(int max) {
        int rows;
        Debug.printf("expandTree(%d)\n", max);
        JTree jTree = this.getTree();
        int i = 0;
        while (i < (rows = jTree.getRowCount()) && rows < max) {
            jTree.expandRow(i++);
        }
    }

    @SwingThread
    boolean leavesShown() {
        JTree jTree = this.getTree();
        int rows = jTree.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            Object lastPathComponent = treePath.getLastPathComponent();
            if (!(lastPathComponent instanceof BugLeafNode)) continue;
            return true;
        }
        return false;
    }

    @SwingThread
    void expandToFirstLeaf(int max) {
        int rows;
        Debug.println("expand to first leaf");
        if (this.leavesShown()) {
            return;
        }
        JTree jTree = this.getTree();
        int i = 0;
        while (i < (rows = jTree.getRowCount()) && rows < max) {
            TreePath treePath = jTree.getPathForRow(i);
            Object lastPathComponent = treePath.getLastPathComponent();
            if (lastPathComponent instanceof BugLeafNode) {
                return;
            }
            jTree.expandRow(i++);
        }
    }

    void setupTreeListeners() {
        this.tree.addTreeSelectionListener(new MyTreeSelectionListener());
        this.tree.addMouseListener(new TreeMouseListener());
    }

    void setSorting(boolean b) {
        this.tableheader.setReorderingAllowed(b);
    }

    Sortables[] sortables() {
        return Sortables.values();
    }

    public BugLeafNode getCurrentSelectedBugLeaf() {
        return this.currentSelectedBugLeaf;
    }

    public JPanel bugListPanel() {
        this.tableheader = new JTableHeader();
        this.getTableheader().setCursor(Cursor.getPredefinedCursor(10));
        this.getTableheader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Debug.println("tableheader.getReorderingAllowed() = " + MainFrameTree.this.getTableheader().getReorderingAllowed());
                if (!MainFrameTree.this.getTableheader().getReorderingAllowed()) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    SorterDialog.getInstance().setVisible(true);
                }
            }

            public void mouseReleased(MouseEvent arg0) {
                if (!MainFrameTree.this.getTableheader().getReorderingAllowed()) {
                    return;
                }
                BugTreeModel bt = (BugTreeModel)MainFrameTree.this.getTree().getModel();
                bt.checkSorter();
            }
        });
        this.sorter = GUISaveState.getInstance().getStarterTable();
        this.getTableheader().setColumnModel(this.getSorter());
        this.getTableheader().setToolTipText(L10N.getLocalString("tooltip.reorder_message", "Drag to reorder tree folder and sort order"));
        this.tree = new JTree();
        this.getTree().setLargeModel(true);
        this.getTree().getSelectionModel().setSelectionMode(1);
        this.getTree().setCellRenderer(new BugRenderer());
        this.getTree().setRowHeight((int)(Driver.getFontSize() + 7.0f));
        this.getTree().setModel(new BugTreeModel(this.mainFrame, this.getTree(), this.getSorter(), new BugSet(new ArrayList())));
        this.setupTreeListeners();
        this.mainFrame.setProject(new Project());
        this.treeScrollPane = new JScrollPane(this.getTree());
        this.treePanel = new JPanel(new BorderLayout());
        this.treePanel.add((Component)this.treeScrollPane, "Center");
        JTable t = new JTable(new DefaultTableModel(0, this.sortables().length));
        t.setTableHeader(this.getTableheader());
        this.textFieldForPackagesToDisplay = new JTextField();
        ActionListener filterAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String text = MainFrameTree.this.textFieldForPackagesToDisplay.getText();
                    if (text.indexOf(47) >= 0) {
                        text = text.replace('/', '.');
                        MainFrameTree.this.textFieldForPackagesToDisplay.setText(text);
                    }
                    MainFrameTree.this.mainFrame.getViewFilter().setPackagesToDisplay(text);
                    MainFrameTree.this.mainFrame.resetViewCache();
                }
                catch (IllegalArgumentException err) {
                    JOptionPane.showMessageDialog(MainFrameTree.this.mainFrame, err.getMessage(), "Bad class search string", 0);
                }
            }
        };
        this.textFieldForPackagesToDisplay.addActionListener(filterAction);
        JButton filterButton = new JButton("Filter");
        filterButton.addActionListener(filterAction);
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.gridy = 1;
        filterPanel.add((Component)this.textFieldForPackagesToDisplay, gbc);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        filterPanel.add((Component)filterButton, gbc);
        filterPanel.setToolTipText("Only show classes containing the word(s) you specify");
        JPanel sortablePanel = new JPanel(new GridBagLayout());
        JLabel sortableLabel = new JLabel("Group bugs by:");
        sortableLabel.setLabelFor(this.getTableheader());
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.gridy = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 1;
        sortablePanel.add((Component)sortableLabel, gbc);
        gbc.weightx = 1.0;
        sortablePanel.add((Component)this.getTableheader(), gbc);
        this.getTableheader().setBorder(new LineBorder(Color.BLACK));
        JPanel topPanel = this.makeNavigationPanel("Class name filter:", filterPanel, sortablePanel, this.treePanel);
        this.cardPanel = new JPanel(new CardLayout());
        JPanel waitPanel = new JPanel();
        waitPanel.setLayout(new BoxLayout(waitPanel, 1));
        waitPanel.add(new JLabel("Please wait..."));
        this.waitStatusLabel = new JLabel();
        waitPanel.add(this.waitStatusLabel);
        this.cardPanel.add((Component)topPanel, MainFrame.BugCard.TREECARD.name());
        this.cardPanel.add((Component)waitPanel, MainFrame.BugCard.WAITCARD.name());
        return this.cardPanel;
    }

    public JTableHeader getTableheader() {
        return this.tableheader;
    }

    public void setBugPopupMenu(JPopupMenu bugPopupMenu) {
        this.bugPopupMenu = bugPopupMenu;
    }

    public void setBranchPopupMenu(JPopupMenu branchPopupMenu) {
        this.branchPopupMenu = branchPopupMenu;
    }

    void updateFonts(float size) {
        this.bugPopupMenu.setFont(this.bugPopupMenu.getFont().deriveFont(size));
        this.mainFrame.setFontSizeHelper(size, this.bugPopupMenu.getComponents());
        this.branchPopupMenu.setFont(this.branchPopupMenu.getFont().deriveFont(size));
        this.mainFrame.setFontSizeHelper(size, this.branchPopupMenu.getComponents());
    }

    void showCard(final MainFrame.BugCard card, final Cursor cursor, final Window window) {
        Runnable doRun = new Runnable(){

            public void run() {
                MainFrameTree.this.mainFrame.enableRecentMenu(card == MainFrame.BugCard.TREECARD);
                MainFrameTree.this.getTableheader().setReorderingAllowed(card == MainFrame.BugCard.TREECARD);
                MainFrameTree.this.mainFrame.getMainFrameMenu().enablePreferencesMenuItem(card == MainFrame.BugCard.TREECARD);
                window.setCursor(cursor);
                CardLayout layout = (CardLayout)MainFrameTree.this.cardPanel.getLayout();
                layout.show(MainFrameTree.this.cardPanel, card.name());
                if (card == MainFrame.BugCard.TREECARD) {
                    SorterDialog.getInstance().thaw();
                } else {
                    SorterDialog.getInstance().freeze();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doRun.run();
        } else {
            SwingUtilities.invokeLater(doRun);
        }
    }

    private JPanel makeNavigationPanel(String packageSelectorLabel, JComponent packageSelector, JComponent treeHeader, JComponent tree) {
        JPanel topPanel = new JPanel();
        topPanel.setMinimumSize(new Dimension(150, 150));
        topPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipady = 3;
        c.ipadx = 3;
        c.insets = new Insets(6, 6, 6, 6);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        JLabel label = new JLabel(packageSelectorLabel);
        topPanel.add((Component)label, c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        topPanel.add((Component)packageSelector, c);
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        c.ipady = 2;
        c.ipadx = 2;
        c.fill = 2;
        topPanel.add((Component)treeHeader, c);
        c.fill = 1;
        ++c.gridy;
        c.weighty = 1.0;
        c.ipady = 0;
        c.ipadx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        topPanel.add((Component)tree, c);
        return topPanel;
    }

    public void setWaitStatusLabelText(String msg) {
        this.waitStatusLabel.setText(msg);
    }

    public void setFieldForPackagesToDisplayText(String filter) {
        this.textFieldForPackagesToDisplay.setText(filter);
    }

    private class MyTreeExpansionListener
    implements TreeExpansionListener {
        private MyTreeExpansionListener() {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Object o;
            System.out.println("Tree expanded");
            TreePath path = event.getPath();
            Object lastPathComponent = path.getLastPathComponent();
            int children = MainFrameTree.this.tree.getModel().getChildCount(lastPathComponent);
            if (children == 1 && (o = MainFrameTree.this.tree.getModel().getChild(lastPathComponent, 0)) instanceof BugAspects) {
                final TreePath p = path.pathByAddingChild(o);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            System.out.println("auto expanding " + p);
                            MainFrameTree.this.tree.expandPath(p);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private volatile boolean ignoreSelection = false;

        private MyTreeSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(TreeSelectionEvent selectionEvent) {
            if (this.ignoreSelection) {
                return;
            }
            TreePath path = selectionEvent.getNewLeadSelectionPath();
            if (path != null) {
                if (!MainFrameTree.this.mainFrame.canNavigateAway()) {
                    try {
                        this.ignoreSelection = true;
                        MainFrameTree.this.tree.clearSelection();
                        MainFrameTree.this.tree.setSelectionPath(selectionEvent.getOldLeadSelectionPath());
                    }
                    finally {
                        this.ignoreSelection = false;
                    }
                    return;
                }
                Object lastPathComponent = path.getLastPathComponent();
                if (lastPathComponent instanceof BugLeafNode) {
                    boolean beforeProjectChanged = MainFrameTree.this.mainFrame.isProjectChanged();
                    MainFrameTree.this.currentSelectedBugLeaf = (BugLeafNode)lastPathComponent;
                    MainFrameTree.this.mainFrame.setCurrentSelectedBugAspects(null);
                    MainFrameTree.this.mainFrame.syncBugInformation();
                    MainFrameTree.this.mainFrame.setProjectChanged(beforeProjectChanged);
                } else {
                    boolean beforeProjectChanged = MainFrameTree.this.mainFrame.isProjectChanged();
                    MainFrameTree.this.mainFrame.updateDesignationDisplay();
                    MainFrameTree.this.currentSelectedBugLeaf = null;
                    MainFrameTree.this.mainFrame.setCurrentSelectedBugAspects((BugAspects)lastPathComponent);
                    MainFrameTree.this.mainFrame.syncBugInformation();
                    MainFrameTree.this.mainFrame.setProjectChanged(beforeProjectChanged);
                }
            }
        }
    }

    private class TreeMouseListener
    implements MouseListener {
        private TreeMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            TreePath path = MainFrameTree.this.tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            if (e.getButton() == 3 || e.getButton() == 1 && e.isControlDown()) {
                if (MainFrameTree.this.tree.getModel().isLeaf(path.getLastPathComponent())) {
                    MainFrameTree.this.tree.setSelectionPath(path);
                    MainFrameTree.this.bugPopupMenu.show(MainFrameTree.this.tree, e.getX(), e.getY());
                } else {
                    MainFrameTree.this.tree.setSelectionPath(path);
                    if (path.getParentPath() != null) {
                        MainFrameTree.this.branchPopupMenu.show(MainFrameTree.this.tree, e.getX(), e.getY());
                    }
                }
            }
        }

        public void mousePressed(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }
    }
}

