/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.jai;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.jai.AbstractPerspectiveTransformSupport;
import edu.uci.ics.jung.visualization.jai.PerspectiveShapeTransformer;
import edu.uci.ics.jung.visualization.jai.PerspectiveTransformSupport;
import edu.uci.ics.jung.visualization.picking.ViewLensShapePickSupport;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.BidirectionalTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.transform.shape.TransformingGraphics;
import javax.media.jai.PerspectiveTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectiveViewTransformSupport<V, E>
extends AbstractPerspectiveTransformSupport<V, E>
implements PerspectiveTransformSupport {
    protected RenderContext<V, E> renderContext;
    protected Renderer<V, E> renderer;
    protected GraphicsDecorator lensGraphicsDecorator;
    protected GraphicsDecorator savedGraphicsDecorator;
    protected GraphElementAccessor<V, E> pickSupport;

    public PerspectiveViewTransformSupport(VisualizationViewer<V, E> vv) {
        super(vv);
        this.renderer = vv.getRenderer();
        this.renderContext = vv.getRenderContext();
        this.pickSupport = this.renderContext.getPickSupport();
        this.perspectiveTransformer = new PerspectiveShapeTransformer(new PerspectiveTransform(), vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW));
        this.savedGraphicsDecorator = this.renderContext.getGraphicsContext();
        this.lensGraphicsDecorator = new TransformingGraphics((BidirectionalTransformer)this.perspectiveTransformer);
    }

    @Override
    public void activate() {
        this.lens = new AbstractPerspectiveTransformSupport.Lens(this.perspectiveTransformer, this.vv.getSize());
        this.renderContext.setPickSupport((GraphElementAccessor)new ViewLensShapePickSupport((VisualizationServer)this.vv));
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(Layer.VIEW, (MutableTransformer)this.perspectiveTransformer);
        this.vv.getRenderContext().setGraphicsContext(this.lensGraphicsDecorator);
        this.vv.addPreRenderPaintable((VisualizationServer.Paintable)this.lens);
        this.vv.setToolTipText("<html><center>The mouse mode button is<p>in the lower-right corner<p>of the scroll-pane.</center></html>");
        this.vv.repaint();
    }

    @Override
    public void deactivate() {
        this.renderContext.setPickSupport(this.pickSupport);
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(Layer.VIEW, this.perspectiveTransformer.getDelegate());
        this.vv.removePreRenderPaintable((VisualizationServer.Paintable)this.lens);
        this.vv.getRenderContext().setGraphicsContext(this.savedGraphicsDecorator);
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.repaint();
    }
}

