/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowCFGPrinter;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.Analysis;
import edu.umd.cs.findbugs.ba.jsr305.BackwardTypeQualifierDataflow;
import edu.umd.cs.findbugs.ba.jsr305.BackwardTypeQualifierDataflowAnalysis;
import edu.umd.cs.findbugs.ba.jsr305.BackwardTypeQualifierDataflowFactory;
import edu.umd.cs.findbugs.ba.jsr305.FlowValue;
import edu.umd.cs.findbugs.ba.jsr305.ForwardTypeQualifierDataflow;
import edu.umd.cs.findbugs.ba.jsr305.ForwardTypeQualifierDataflowAnalysis;
import edu.umd.cs.findbugs.ba.jsr305.ForwardTypeQualifierDataflowFactory;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkInfo;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkType;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValueSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import edu.umd.cs.findbugs.bcel.CFGDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.util.Util;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.meta.When;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckTypeQualifiers
extends CFGDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("ctq.debug");
    private static final boolean DEBUG_DATAFLOW = SystemProperties.getBoolean("ctq.dataflow.debug");
    private static final String DEBUG_DATAFLOW_MODE = SystemProperties.getProperty("ctq.dataflow.debug.mode", "both");
    private static final String NONNULL_ANNOTATION = "javax/annotation/Nonnull";
    private static final String METHOD = SystemProperties.getProperty("ctq.method");
    private final BugReporter bugReporter;
    boolean checked;
    boolean shouldRunAnalysis;
    private String checkLocation;

    public CheckTypeQualifiers(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        if (!this.checked) {
            this.checked = true;
            Collection<TypeQualifierValue> allKnownTypeQualifiers = TypeQualifierValue.getAllKnownTypeQualifiers();
            int size = allKnownTypeQualifiers.size();
            if (size == 1) {
                TypeQualifierValue value = Util.first(allKnownTypeQualifiers);
                if (!value.typeQualifier.getClassName().equals(NONNULL_ANNOTATION)) {
                    this.shouldRunAnalysis = true;
                }
            } else if (size > 1) {
                this.shouldRunAnalysis = true;
            }
        }
        if (this.shouldRunAnalysis) {
            super.visitClass(classDescriptor);
        }
    }

    @Override
    protected void visitMethodCFG(MethodDescriptor methodDescriptor, CFG cfg) throws CheckedAnalysisException {
        if (METHOD != null && !methodDescriptor.getName().equals(METHOD)) {
            return;
        }
        if (methodDescriptor.getName().startsWith("access$")) {
            return;
        }
        XMethod xMethod = XFactory.createXMethod(methodDescriptor);
        if (DEBUG) {
            System.out.println("CheckTypeQualifiers: checking " + methodDescriptor.toString());
        }
        Collection<TypeQualifierValue> relevantQualifiers = Analysis.getRelevantTypeQualifiers(methodDescriptor, cfg);
        Iterator<TypeQualifierValue> i = relevantQualifiers.iterator();
        while (i.hasNext()) {
            if (!i.next().getTypeQualifierClassDescriptor().getClassName().equals(NONNULL_ANNOTATION)) continue;
            i.remove();
        }
        if (relevantQualifiers.isEmpty()) {
            return;
        }
        if (DEBUG) {
            System.out.println("  Relevant type qualifiers are " + relevantQualifiers);
        }
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        ForwardTypeQualifierDataflowFactory forwardDataflowFactory = analysisCache.getMethodAnalysis(ForwardTypeQualifierDataflowFactory.class, methodDescriptor);
        BackwardTypeQualifierDataflowFactory backwardDataflowFactory = analysisCache.getMethodAnalysis(BackwardTypeQualifierDataflowFactory.class, methodDescriptor);
        ValueNumberDataflow vnaDataflow = analysisCache.getMethodAnalysis(ValueNumberDataflow.class, methodDescriptor);
        for (TypeQualifierValue typeQualifierValue : relevantQualifiers) {
            try {
                this.checkQualifier(xMethod, cfg, typeQualifierValue, forwardDataflowFactory, backwardDataflowFactory, vnaDataflow);
            }
            catch (MissingClassException e) {
                AnalysisContext.reportMissingClass(e);
            }
            catch (CheckedAnalysisException e) {
                this.bugReporter.logError("Exception checking type qualifier " + typeQualifierValue.toString() + " on method " + methodDescriptor.toString(), e);
            }
        }
    }

    private void checkQualifier(XMethod xmethod, CFG cfg, TypeQualifierValue typeQualifierValue, ForwardTypeQualifierDataflowFactory forwardDataflowFactory, BackwardTypeQualifierDataflowFactory backwardDataflowFactory, ValueNumberDataflow vnaDataflow) throws CheckedAnalysisException {
        if (DEBUG) {
            System.out.println("----------------------------------------------------------------------");
            System.out.println("Checking type qualifier " + typeQualifierValue.toString() + " on method " + xmethod.toString());
            if (typeQualifierValue.isStrictQualifier()) {
                System.out.println("  Strict type qualifier");
            }
            System.out.println("----------------------------------------------------------------------");
        }
        ForwardTypeQualifierDataflow forwardDataflow = (ForwardTypeQualifierDataflow)forwardDataflowFactory.getDataflow(typeQualifierValue);
        if (DEBUG_DATAFLOW && (DEBUG_DATAFLOW_MODE.startsWith("forward") || DEBUG_DATAFLOW_MODE.equals("both"))) {
            System.out.println("********* Forwards analysis *********");
            DataflowCFGPrinter<TypeQualifierValueSet, ForwardTypeQualifierDataflowAnalysis> p = new DataflowCFGPrinter<TypeQualifierValueSet, ForwardTypeQualifierDataflowAnalysis>(forwardDataflow);
            p.print(System.out);
        }
        BackwardTypeQualifierDataflow backwardDataflow = (BackwardTypeQualifierDataflow)backwardDataflowFactory.getDataflow(typeQualifierValue);
        if (DEBUG_DATAFLOW && (DEBUG_DATAFLOW_MODE.startsWith("backward") || DEBUG_DATAFLOW_MODE.equals("both"))) {
            System.out.println("********* Backwards analysis *********");
            DataflowCFGPrinter<TypeQualifierValueSet, BackwardTypeQualifierDataflowAnalysis> p = new DataflowCFGPrinter<TypeQualifierValueSet, BackwardTypeQualifierDataflowAnalysis>(backwardDataflow);
            p.print(System.out);
        }
        this.checkDataflow(xmethod, cfg, typeQualifierValue, vnaDataflow, forwardDataflow, backwardDataflow);
        this.checkValueSources(xmethod, cfg, typeQualifierValue, vnaDataflow, forwardDataflow, backwardDataflow);
    }

    private void checkDataflow(XMethod xmethod, CFG cfg, TypeQualifierValue typeQualifierValue, ValueNumberDataflow vnaDataflow, ForwardTypeQualifierDataflow forwardDataflow, BackwardTypeQualifierDataflow backwardDataflow) throws DataflowAnalysisException, CheckedAnalysisException {
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location loc = i.next();
            TypeQualifierValueSet forwardsFact = (TypeQualifierValueSet)forwardDataflow.getFactAtLocation(loc);
            TypeQualifierValueSet backwardsFact = (TypeQualifierValueSet)backwardDataflow.getFactAfterLocation(loc);
            if (!forwardsFact.isValid() || !backwardsFact.isValid()) continue;
            if (DEBUG) {
                this.checkLocation = "location " + loc.toCompactString();
            }
            this.checkForConflictingValues(xmethod, cfg, typeQualifierValue, forwardsFact, backwardsFact, loc, loc, (ValueNumberFrame)vnaDataflow.getFactAtLocation(loc));
            this.checkForEqualityTest(xmethod, cfg, typeQualifierValue, forwardsFact, loc, (ValueNumberFrame)vnaDataflow.getFactAtLocation(loc));
        }
        i = cfg.edgeIterator();
        while (i.hasNext()) {
            Edge edge = (Edge)((Object)i.next());
            TypeQualifierValueSet forwardFact = (TypeQualifierValueSet)forwardDataflow.getFactOnEdge(edge);
            TypeQualifierValueSet backwardFact = (TypeQualifierValueSet)backwardDataflow.getResultFact((BasicBlock)edge.getTarget());
            Location edgeTargetLocation = this.getEdgeTargetLocation(cfg, edge);
            ValueNumberFrame vnaFrame = edgeTargetLocation != null ? (ValueNumberFrame)vnaDataflow.getFactAtLocation(edgeTargetLocation) : null;
            Location locationToReport = ((BasicBlock)edge.getSource()).getLastInstruction() != null ? this.getEdgeSourceLocation(cfg, edge) : edgeTargetLocation;
            this.checkForConflictingValues(xmethod, cfg, typeQualifierValue, forwardFact, backwardFact, locationToReport, edgeTargetLocation, vnaFrame);
        }
    }

    private void checkForEqualityTest(XMethod xmethod, CFG cfg, TypeQualifierValue typeQualifierValue, TypeQualifierValueSet forwardsFact, Location loc, ValueNumberFrame factAtLocation) throws DataflowAnalysisException {
        InstructionHandle handle = loc.getHandle();
        Instruction ins = handle.getInstruction();
        boolean isTest = false;
        ConstantPoolGen cpg = cfg.getMethodGen().getConstantPool();
        if (ins instanceof IfInstruction && ins.consumeStack(cpg) == 2) {
            isTest = true;
        } else if (ins instanceof InvokeInstruction && ins.consumeStack(cpg) == 2) {
            InvokeInstruction invoke = (InvokeInstruction)ins;
            boolean bl = isTest = invoke.getMethodName(cpg).equals("equals") && invoke.getSignature(cpg).equals("(Ljava/lang/Object;)Z");
        }
        if (isTest) {
            ValueNumber top = (ValueNumber)factAtLocation.getStackValue(0);
            if (top.hasFlag(16)) {
                return;
            }
            ValueNumber next = (ValueNumber)factAtLocation.getStackValue(1);
            if (next.hasFlag(16)) {
                return;
            }
            FlowValue topTQ = forwardsFact.getValue(top);
            FlowValue nextTQ = forwardsFact.getValue(next);
            if (DEBUG) {
                System.out.println("Comparing values at " + loc.toCompactString());
                System.out.println(" Comparing " + (Object)((Object)topTQ) + " and " + (Object)((Object)nextTQ));
            }
            if (topTQ.equals((Object)nextTQ)) {
                return;
            }
            if (FlowValue.valuesConflict(typeQualifierValue.isStrictQualifier() && !xmethod.isIdentity(), topTQ, nextTQ)) {
                BugInstance warning = new BugInstance(this, "TESTING", 1).addClassAndMethod(xmethod);
                this.annotateWarningWithTypeQualifier(warning, typeQualifierValue);
                for (SourceSinkInfo sourceSinkInfo : forwardsFact.getWhere(top)) {
                    this.annotateWarningWithSourceSinkInfo(warning, xmethod, top, sourceSinkInfo);
                }
                for (SourceSinkInfo sourceSinkInfo : forwardsFact.getWhere(next)) {
                    this.annotateWarningWithSourceSinkInfo(warning, xmethod, next, sourceSinkInfo);
                }
                SourceLineAnnotation observedLocation = SourceLineAnnotation.fromVisitedInstruction(xmethod.getMethodDescriptor(), loc);
                warning.add(observedLocation);
                warning.addSomeSourceForTopTwoStackValues(this.classContext, this.method, loc);
                this.bugReporter.reportBug(warning);
            }
        }
    }

    private void checkValueSources(XMethod xMethod, CFG cfg, TypeQualifierValue typeQualifierValue, ValueNumberDataflow vnaDataflow, ForwardTypeQualifierDataflow forwardDataflow, BackwardTypeQualifierDataflow backwardDataflow) throws DataflowAnalysisException {
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            Set<SourceSinkInfo> sourceSet = ((ForwardTypeQualifierDataflowAnalysis)forwardDataflow.getAnalysis()).getSourceSinkInfoSet(location);
            for (SourceSinkInfo source : sourceSet) {
                int p;
                TypeQualifierAnnotation directTypeQualifierAnnotation;
                ValueNumber vn = source.getValueNumber();
                TypeQualifierValueSet backwardsFact = (TypeQualifierValueSet)backwardDataflow.getFactAtLocation(location);
                FlowValue backwardsFlowValue = backwardsFact.getValue(vn);
                if (backwardsFlowValue != FlowValue.ALWAYS && backwardsFlowValue != FlowValue.NEVER) continue;
                if (DEBUG) {
                    System.out.println("Checking value source at " + location.toCompactString());
                    System.out.println("  back=" + backwardsFact);
                    System.out.println("  source=" + source);
                }
                TypeQualifierValueSet forwardsFact = (TypeQualifierValueSet)forwardDataflow.getFactAfterLocation(location);
                FlowValue forwardsFlowValue = forwardsFact.getValue(vn);
                if (FlowValue.valuesConflict(typeQualifierValue.isStrictQualifier() && !xMethod.isIdentity(), forwardsFlowValue, backwardsFlowValue)) continue;
                if (FlowValue.backwardsValueConflictsWithSource(backwardsFlowValue, source, typeQualifierValue, xMethod.isIdentity())) {
                    String bugType = backwardsFlowValue == FlowValue.NEVER ? "TQ_MAYBE_SOURCE_VALUE_REACHES_NEVER_SINK" : "TQ_MAYBE_SOURCE_VALUE_REACHES_ALWAYS_SINK";
                    this.emitSourceWarning(bugType, xMethod, typeQualifierValue, backwardsFlowValue, backwardsFact, source, vn, location);
                    continue;
                }
                if (source.getWhen() != When.UNKNOWN || source.getType() != SourceSinkType.PARAMETER || (directTypeQualifierAnnotation = TypeQualifierApplications.getDirectTypeQualifierAnnotation(xMethod, p = source.getParameter(), typeQualifierValue)) == null || directTypeQualifierAnnotation.when != When.UNKNOWN) continue;
                String bugType = backwardsFlowValue == FlowValue.NEVER ? "TQ_EXPLICIT_UNKNOWN_SOURCE_VALUE_REACHES_NEVER_SINK" : "TQ_EXPLICIT_UNKNOWN_SOURCE_VALUE_REACHES_ALWAYS_SINK";
                this.emitSourceWarning(bugType, xMethod, typeQualifierValue, backwardsFlowValue, backwardsFact, source, vn, location);
            }
        }
    }

    private Location getEdgeTargetLocation(CFG cfg, Edge edge) {
        BasicBlock targetBlock = (BasicBlock)edge.getTarget();
        if (targetBlock.getFirstInstruction() != null) {
            return new Location(targetBlock.getFirstInstruction(), targetBlock);
        }
        if (targetBlock.isExceptionThrower()) {
            BasicBlock fallThroughSuccessor = cfg.getSuccessorWithEdgeType(targetBlock, 0);
            if (fallThroughSuccessor == null) {
                Iterator<Edge> i = cfg.removedEdgeIterator();
                while (i.hasNext()) {
                    Edge removedEdge = i.next();
                    if (removedEdge.getSource() != targetBlock || removedEdge.getType() != 0) continue;
                    fallThroughSuccessor = (BasicBlock)removedEdge.getTarget();
                    break;
                }
            }
            if (fallThroughSuccessor != null && fallThroughSuccessor.getFirstInstruction() != null) {
                return new Location(fallThroughSuccessor.getFirstInstruction(), fallThroughSuccessor);
            }
        }
        return null;
    }

    private Location getEdgeSourceLocation(CFG cfg, Edge edge) {
        BasicBlock sourceBlock = (BasicBlock)edge.getSource();
        return sourceBlock.getLastInstruction() != null ? new Location(sourceBlock.getLastInstruction(), sourceBlock) : null;
    }

    private void checkForConflictingValues(XMethod xMethod, CFG cfg, TypeQualifierValue typeQualifierValue, TypeQualifierValueSet forwardsFact, TypeQualifierValueSet backwardsFact, Location locationToReport, Location locationWhereDoomedValueIsObserved, ValueNumberFrame vnaFrame) throws CheckedAnalysisException {
        HashSet<ValueNumber> valueNumberSet = new HashSet<ValueNumber>();
        valueNumberSet.addAll(forwardsFact.getValueNumbers());
        valueNumberSet.addAll(backwardsFact.getValueNumbers());
        for (ValueNumber vn : valueNumberSet) {
            FlowValue forward = forwardsFact.getValue(vn);
            FlowValue backward = backwardsFact.getValue(vn);
            if (!FlowValue.valuesConflict(typeQualifierValue.isStrictQualifier() && !xMethod.isIdentity(), forward, backward)) continue;
            if (DEBUG) {
                System.out.println("Check " + vn + ": forward=" + (Object)((Object)forward) + ", backward=" + (Object)((Object)backward) + " at " + this.checkLocation);
            }
            this.emitDataflowWarning(xMethod, typeQualifierValue, forwardsFact, backwardsFact, vn, forward, backward, locationToReport, locationWhereDoomedValueIsObserved, vnaFrame);
        }
    }

    private void emitDataflowWarning(XMethod xMethod, TypeQualifierValue typeQualifierValue, TypeQualifierValueSet forwardsFact, TypeQualifierValueSet backwardsFact, ValueNumber vn, FlowValue forward, FlowValue backward, Location locationToReport, Location locationWhereDoomedValueIsObserved, ValueNumberFrame vnaFrame) throws CheckedAnalysisException {
        String bugType = backward == FlowValue.NEVER ? "TQ_ALWAYS_VALUE_USED_WHERE_NEVER_REQUIRED" : "TQ_NEVER_VALUE_USED_WHERE_ALWAYS_REQUIRED";
        BugInstance warning = new BugInstance(this, bugType, 2).addClassAndMethod(xMethod);
        this.annotateWarningWithTypeQualifier(warning, typeQualifierValue);
        Set<? extends SourceSinkInfo> sourceSet = forward == FlowValue.ALWAYS ? forwardsFact.getWhereAlways(vn) : forwardsFact.getWhereNever(vn);
        for (SourceSinkInfo sourceSinkInfo : sourceSet) {
            this.annotateWarningWithSourceSinkInfo(warning, xMethod, vn, sourceSinkInfo);
        }
        Set<? extends SourceSinkInfo> sinkSet = backward == FlowValue.ALWAYS ? backwardsFact.getWhereAlways(vn) : backwardsFact.getWhereNever(vn);
        Location location = this.getSinkLocation(sinkSet);
        if (location == null) {
            AnalysisContext.logError("Unable to compute sink location for " + xMethod);
            return;
        }
        if (locationWhereDoomedValueIsObserved != null) {
            Method method = Global.getAnalysisCache().getMethodAnalysis(Method.class, xMethod.getMethodDescriptor());
            LocalVariableAnnotation localVariableAnnotation = ValueNumberSourceInfo.findLocalAnnotationFromValueNumber(method, locationWhereDoomedValueIsObserved, vn, vnaFrame);
            if (localVariableAnnotation != null && !localVariableAnnotation.equals(warning.getPrimaryLocalVariableAnnotation())) {
                localVariableAnnotation.setDescription(localVariableAnnotation.isSignificant() ? "LOCAL_VARIABLE_VALUE_DOOMED_NAMED" : "LOCAL_VARIABLE_VALUE_DOOMED");
                warning.add(localVariableAnnotation);
            }
            if (!location.equals(locationToReport)) {
                SourceLineAnnotation observedLocation = SourceLineAnnotation.fromVisitedInstruction(xMethod.getMethodDescriptor(), locationToReport);
                observedLocation.setDescription("SOURCE_LINE_VALUE_DOOMED");
                warning.add(observedLocation);
            }
        }
        for (SourceSinkInfo sourceSinkInfo : sinkSet) {
            this.annotateWarningWithSourceSinkInfo(warning, xMethod, vn, sourceSinkInfo);
        }
        this.bugReporter.reportBug(warning);
    }

    private void emitSourceWarning(String bugType, XMethod xMethod, TypeQualifierValue typeQualifierValue, FlowValue backwardsFlowValue, TypeQualifierValueSet backwardsFact, SourceSinkInfo source, ValueNumber vn, Location location) {
        BugInstance warning = new BugInstance(this, bugType, 2).addClassAndMethod(xMethod);
        this.annotateWarningWithTypeQualifier(warning, typeQualifierValue);
        this.annotateWarningWithSourceSinkInfo(warning, xMethod, vn, source);
        Set<? extends SourceSinkInfo> sinkSet = backwardsFlowValue == FlowValue.NEVER ? backwardsFact.getWhereNever(vn) : backwardsFact.getWhereAlways(vn);
        for (SourceSinkInfo sourceSinkInfo : sinkSet) {
            this.annotateWarningWithSourceSinkInfo(warning, xMethod, vn, sourceSinkInfo);
        }
        this.bugReporter.reportBug(warning);
    }

    private void annotateWarningWithTypeQualifier(BugInstance warning, TypeQualifierValue typeQualifierValue) {
        if (TypeQualifierValue.hasMultipleVariants(typeQualifierValue)) {
            StringBuilder buf = new StringBuilder();
            buf.append("@");
            buf.append(typeQualifierValue.typeQualifier.getDottedClassName());
            buf.append("(");
            buf.append(typeQualifierValue.value);
            buf.append(")");
            warning.addString(buf.toString()).describe("STRING_TYPE_QUALIFIER");
        } else {
            warning.addClass(typeQualifierValue.typeQualifier).describe("CLASS_TYPE_QUALIFIER");
        }
    }

    private void annotateWarningWithSourceSinkInfo(BugInstance warning, XMethod xMethod, ValueNumber vn, SourceSinkInfo sourceSinkInfo) {
        MethodDescriptor methodDescriptor = xMethod.getMethodDescriptor();
        switch (sourceSinkInfo.getType()) {
            case PARAMETER: {
                try {
                    Method method = Global.getAnalysisCache().getMethodAnalysis(Method.class, methodDescriptor);
                    LocalVariableAnnotation lva = LocalVariableAnnotation.getParameterLocalVariableAnnotation(method, sourceSinkInfo.getLocal());
                    lva.setDescription(lva.isSignificant() ? "LOCAL_VARIABLE_PARAMETER_VALUE_SOURCE_NAMED" : "LOCAL_VARIABLE_PARAMETER_VALUE_SOURCE");
                    warning.add(lva);
                }
                catch (CheckedAnalysisException e) {
                    warning.addSourceLine(methodDescriptor, sourceSinkInfo.getLocation()).describe("SOURCE_LINE_VALUE_SOURCE");
                }
                break;
            }
            case CONSTANT_VALUE: {
                Object constantValue = sourceSinkInfo.getConstantValue();
                if (constantValue instanceof String) {
                    warning.addString((String)constantValue).describe("STRING_CONSTANT");
                    break;
                }
                if (constantValue instanceof Integer) {
                    warning.addInt((Integer)constantValue).describe("INT_VALUE");
                    break;
                }
                warning.addString(constantValue.toString()).describe("STRING_CONSTANT");
                break;
            }
            case RETURN_VALUE_OF_CALLED_METHOD: 
            case FIELD_LOAD: {
                warning.addSourceLine(methodDescriptor, sourceSinkInfo.getLocation()).describe("SOURCE_LINE_VALUE_SOURCE");
                break;
            }
            case ARGUMENT_TO_CALLED_METHOD: 
            case RETURN_VALUE: 
            case FIELD_STORE: {
                warning.addSourceLine(methodDescriptor, sourceSinkInfo.getLocation());
                return;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @CheckForNull
    private Location getSinkLocation(SourceSinkInfo sourceSinkInfo) {
        switch (sourceSinkInfo.getType()) {
            case ARGUMENT_TO_CALLED_METHOD: 
            case RETURN_VALUE: 
            case FIELD_STORE: {
                return sourceSinkInfo.getLocation();
            }
        }
        return null;
    }

    @CheckForNull
    private Location getSinkLocation(Iterable<? extends SourceSinkInfo> info) {
        for (SourceSinkInfo sourceSinkInfo : info) {
            Location l = this.getSinkLocation(sourceSinkInfo);
            if (l == null) continue;
            return l;
        }
        return null;
    }
}

