//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns.visitors.contains;

import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.TEXT_INPUT;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.ITERATION;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.SELECTION;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.SEQUENCE;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePattern;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePatternBuilder;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskTreeUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class ContainsPatternTest {

    @Test
    public void sequence_ends_with_positive_1() {
        // Given
        String spec = "Sequence {" +
        	      "  Selection {" + 
                      "    TextInput () {}" +
                      "    MouseClick () {}" +
                      "  }" + 
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePatternBuilder patternBuilder = new UsagePatternBuilder();
        UsagePattern containsPattern = patternBuilder.concernedNode(SELECTION).startsWith(TEXT_INPUT).endsWith(TEXT_INPUT).build();
        UsagePattern pattern = patternBuilder.concernedNode(SEQUENCE).contains(containsPattern).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void sequence_ends_with_positive_2() {
        // Given
        String spec = "Selection {" +
                      "  EventTask target1 {}" +
                      "  Sequence {" +
                      "    EventTask target2 {}" +
                      "    TextInput target3 {}" +
                      "  }" +
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SEQUENCE).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void sequence_ends_with_positive_3() {
        // Given
        String spec =  "Sequence {" +
                       "  Optional {" +
                       "    Sequence {" +
                       "      EventTask target4 {}" +
                       "      EventTask target3 {}" +
                       "    }" +
                       "  }" +
                       "  EventTask target1 {}" +
                       "  EventTask target2 {}" +
                       "  EventTask target3 {}" +
                       "  EventTask target4 {}" +
                       "  Selection {" +
                       "    EventTask target5 {}" +
                       "    Sequence {" +
                       "      EventTask target4 {}" +
                       "      EventTask target2 {}" +
                       "    }" +
                       "  }" +
                       "  EventTask target6 {}" +
                       "  TextInput target7 {}" +
                       "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SEQUENCE).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
   
    @Test
    public void sequence_ends_with_negative_1() {
        // Given
        String spec = "Sequence {" + 
                      "  MouseClick () {}" + 
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SEQUENCE).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }
    
    @Test
    public void sequence_ends_with_negative_2() {
        // Given
        String spec = "Selection {" +
                      "  Sequence {" +
                      "    EventTask target1 {}" +
                      "    EventTask target2 {}" +
                      "  }" +
                      "  Sequence {" +
                      "    EventTask target3 {}" +
                      "    EventTask target4 {}" +
                      "  }" +
                      "  Sequence {" +
                      "    EventTask target5 {}" +
                      "    EventTask target6 {}" +
                      "  }" +
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SEQUENCE).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }
    
    @Test
    public void sequence_ends_with_negative_3() {
        // Given
        String spec = "Iteration {" +
                      "  Selection {" +
                      "    EventTask target2 {}" +
                      "    EventTask target3 {}" +
                      "  }" +
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SEQUENCE).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }
    
    @Test
    public void iteration_ends_with_positive_1() {
        // Given
        String spec = "Iteration {" + 
                      "  TextInput () {}" + 
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(ITERATION).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void iteration_ends_with_positive_2() {
        // Given
        String spec = "Iteration {" +
                      "  Sequence {" +
                      "    EventTask target1 {}" +
                      "    Selection {" +
                      "      EventTask target2 {}" +
                      "      TextInput target2 {}" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(ITERATION).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void iteration_ends_with_positive_3() {
        // Given
        String spec = "Iteration {" +
                      "  Selection {" +
                      "    TextInput target1 {}" +
                      "    Sequence {" +
                      "      EventTask target2 {}" +
                      "      EventTask target3 {}" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(ITERATION).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void iteration_ends_with_negative_1() {
        // Given
        String spec = "Iteration {" + 
                      "  MouseClick () {}" + 
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(ITERATION).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }
    
    @Test
    public void iteration_ends_with_negative_2() {
        // Given
        String spec = "Iteration {" +
                      "  Sequence {" +
                      "    EventTask target1 {}" +
                      "    Optional {" +
                      "      EventTask target2 {}" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(ITERATION).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }
    
    @Test
    public void iteration_ends_with_negative_3() {
        // Given
        String spec = "Iteration {" +
                      "  Selection {" +
                      "    EventTask target1 {}" +
                      "    Sequence {" +
                      "      EventTask target2 {}" +
                      "      EventTask target3 {}" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(ITERATION).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }
    
    @Test
    public void selection_ends_with_positive_1() {
        // Given
        String spec = "Selection {" + 
                      "  MouseClick () {}" + 
                      "  TextInput () {}" + 
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SELECTION).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void selection_ends_with_positive_2() {
        // Given
        String spec = "Sequence {" +
                      "  Optional {" +
                      "    Sequence {" +
                      "      EventTask target4 {}" +
                      "      EventTask target3 {}" +
                      "    }" +
                      "  }" +
                      "  EventTask target1 {}" +
                      "  EventTask target2 {}" +
                      "  EventTask target3 {}" +
                      "  EventTask target4 {}" +
                      "  Selection {" +
                      "    EventTask target5 {}" +
                      "    Sequence {" +
                      "      EventTask target4 {}" +
                      "      TextInput target2 {}" +
                      "    }" +
                      "  }" +
                      "  EventTask target6 {}" +
                      "  EventTask target7 {}" +
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SELECTION).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void selection_ends_with_positive_3() {
        // Given
        String spec = "Iteration {" +
                      "  Selection {" +
                      "    Sequence {" +
                      "      EventTask target3 {}" +
                      "      TextInput target4 {}" +
                      "    }" +
                      "    Sequence {" +
                      "      TextInput target5 {}" +
                      "      EventTask target6 {}" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SELECTION).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void selection_ends_with_negative_1() {
        // Given
        String spec = "Selection {" + 
                      "  DragAndDrop () {}" + 
                      "  MouseClick () {}" + 
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SELECTION).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }
    
    @Test
    public void selection_ends_with_negative_2() {
        // Given
        String spec = "Iteration {" +
                      "  Selection {" +
                      "    Sequence {" +
                      "      EventTask target3 {}" +
                      "      EventTask target4 {}" +
                      "    }" +
                      "    Sequence {" +
                      "      EventTask target5 {}" +
                      "      EventTask target6 {}" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromSpec(spec);
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SELECTION).contains(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }

}
