//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns.visitors;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePattern;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePatternVisitor;
import de.ugoe.cs.autoquest.usability.util.PatternsVisitorUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class StartsWithPatternVisitor extends UsagePatternVisitor {

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param startsWithPattern
     */
    public StartsWithPatternVisitor(UsagePattern startsWithPattern) {
        this.containedPattern = startsWithPattern;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.NodeVisitor#visit(de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration)
     */
    public void visit(IIteration iteration) {
        this.present = containedPattern.containedIn(iteration);  
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.NodeVisitor#visit(de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence)
     */
    public void visit(ISequence sequence) {
        ITask firstTask = PatternsVisitorUtil.firstNodeOf(sequence.getChildren());
        if(isEvent(firstTask)) {
            this.present = containedPattern.containedIn(sequence);
        } else {
            this.present = containedPattern.containedIn(firstTask);
        }    
    }

    private boolean isEvent(ITask firstTask) {
        return firstTask instanceof IEventTask;
    }

}
