//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskVisitor;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
class EventTask extends Task implements IEventTask {
    
    /**  */
    private static final long serialVersionUID = 1L;

    /** */
    private IEventType eventType;

    /** */
    private IEventTarget eventTarget;

    /**
     * @param eventType
     * @param eventTarget
     */
    EventTask(IEventType eventType, IEventTarget eventTarget) {
        super.setDescription(eventType.toString() + " executed on " + eventTarget);
        this.eventType = eventType;
        this.eventTarget = eventTarget;
    }

    /**
     * @return Returns the interaction.
     */
    public IEventType getEventType() {
        return eventType;
    }

    /**
     * @return Returns the GUIElement.
     */
    public IEventTarget getEventTarget() {
        return eventTarget;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.tasktrees.TreeNode#clone()
     */
    @Override
    public EventTask clone() {
        // Event type and target are unchangeable and do not need to be cloned
        return (EventTask) super.clone();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask#accept(de.ugoe.cs.autoquest.tasktrees.treeifc.TaskVisitor)
     */
    @Override
    public void accept(ITaskVisitor visitor) {
        visitor.visit(this);
    }

}
