//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith;

import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.MOUSE_CLICK;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.TEXT_INPUT;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.ITERATION;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.SEQUENCE;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePattern;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePatternBuilder;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskModelUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class StartsWithPatternAndContainsEventTest {
    
    @Test
    public void starts_with_pattern_and_contains_event_positive() {
        // Given
        String spec = "UserSession {" +
        		      "  Selection sel1 {" +
                      "    EventTask target1 {}" +
                      "  }" +
                      "  Selection sel1 {" +
                      "    Sequence seq1 {" +
                      "      Iteration iter1 {" +
                      "        TextInput target4 {}" +
                      "      }" +
                      "      MouseClick t2 {}" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        UsagePatternBuilder patternBuilder = new UsagePatternBuilder();
        UsagePattern startsWithPattern = patternBuilder.concernedNode(ITERATION).startsWith(TEXT_INPUT).build();
        UsagePattern pattern = patternBuilder.concernedNode(SEQUENCE).startsWith(startsWithPattern).contains(MOUSE_CLICK).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void starts_with_pattern_and_contains_event_negative() {
        String spec = "UserSession {" +
        		      "  Selection sel1 {" +
                      "    EventTask target1 {}" +
                      "  }" +
                      "  Selection sel1 {" +
                      "    Sequence seq1 {" +
                      "      Iteration iter1 {" +
                      "        TextInput target4 {}" +
                      "      }" +
                      "      EventTask t2 {}" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        UsagePatternBuilder patternBuilder = new UsagePatternBuilder();
        UsagePattern startsWithPattern = patternBuilder.concernedNode(ITERATION).contains(TEXT_INPUT).build();
        UsagePattern pattern = patternBuilder.concernedNode(SEQUENCE).startsWith(startsWithPattern).contains(MOUSE_CLICK).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }

}
