/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.RecomputableClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.classfile.impl.ZipInputStreamCodeBaseEntry;
import edu.umd.cs.findbugs.io.IO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDataAnalysisEngine
extends RecomputableClassAnalysisEngine<ClassData> {
    @Override
    public ClassData analyze(IAnalysisCache analysisCache, ClassDescriptor descriptor) throws CheckedAnalysisException {
        byte[] data;
        ICodeBaseEntry codeBaseEntry;
        String resourceName = descriptor.toResourceName();
        try {
            codeBaseEntry = analysisCache.getClassPath().lookupResource(resourceName);
        }
        catch (ResourceNotFoundException e) {
            throw new MissingClassException(descriptor, (Throwable)e);
        }
        if (codeBaseEntry instanceof ZipInputStreamCodeBaseEntry) {
            data = ((ZipInputStreamCodeBaseEntry)codeBaseEntry).getBytes();
        } else {
            int length = codeBaseEntry.getNumBytes();
            ByteArrayOutputStream byteSink = length >= 0 ? new ByteArrayOutputStream(length) : new ByteArrayOutputStream();
            InputStream in = null;
            try {
                in = codeBaseEntry.openResource();
                IO.copy(in, byteSink);
            }
            catch (IOException e) {
                throw new MissingClassException(descriptor, (Throwable)e);
            }
            finally {
                if (in != null) {
                    IO.close(in);
                }
            }
            data = byteSink.toByteArray();
        }
        return new ClassData(descriptor, codeBaseEntry, data);
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerClassAnalysisEngine(ClassData.class, this);
    }
}

