/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BasicAbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFGPrinter;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysis;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import java.io.PrintStream;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataflowCFGPrinter<Fact, AnalysisType extends DataflowAnalysis<Fact>>
extends CFGPrinter {
    private Dataflow<Fact, AnalysisType> dataflow;

    public DataflowCFGPrinter(Dataflow<Fact, AnalysisType> dataflow) {
        super(dataflow.getCFG());
        this.dataflow = dataflow;
        this.setIsForwards(dataflow.getAnalysis().isForwards());
    }

    @Override
    public String edgeAnnotate(Edge edge) {
        String edgeAnnotation = "";
        try {
            edgeAnnotation = " " + this.dataflow.getAnalysis().factToString(this.dataflow.getAnalysis().getFactOnEdge(edge));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return edgeAnnotation;
    }

    @Override
    public String blockStartAnnotate(BasicBlock bb) {
        boolean flip = this.isForwards() != this.dataflow.getAnalysis().isForwards();
        Fact fact = flip ? this.dataflow.getResultFact(bb) : this.dataflow.getStartFact(bb);
        return " " + this.dataflow.getAnalysis().factToString(fact);
    }

    @Override
    public String blockAnnotate(BasicBlock bb) {
        boolean flip = this.isForwards() != this.dataflow.getAnalysis().isForwards();
        Fact fact = flip ? this.dataflow.getStartFact(bb) : this.dataflow.getResultFact(bb);
        return " " + this.dataflow.getAnalysis().factToString(fact);
    }

    @Override
    public String instructionAnnotate(InstructionHandle handle, BasicBlock bb) {
        try {
            boolean flip = this.isForwards() != this.dataflow.getAnalysis().isForwards();
            Location loc = new Location(handle, bb);
            Object fact = flip ? this.dataflow.getAnalysis().getFactAfterLocation(loc) : this.dataflow.getAnalysis().getFactAtLocation(loc);
            return " " + this.dataflow.getAnalysis().factToString(fact);
        }
        catch (DataflowAnalysisException e) {
            throw new IllegalStateException("Caught exception: " + e.toString());
        }
    }

    public static <Fact, AnalysisType extends BasicAbstractDataflowAnalysis<Fact>> void printCFG(Dataflow<Fact, AnalysisType> dataflow, PrintStream out) {
        DataflowCFGPrinter<Fact, AnalysisType> printer = new DataflowCFGPrinter<Fact, AnalysisType>(dataflow);
        printer.print(out);
    }
}

