/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.bcel;

import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;

public abstract class CFGDetector
implements Detector2 {
    protected ClassContext classContext;
    protected Method method;

    public void finishPass() {
    }

    public String getDetectorClassName() {
        return this.getClass().getName();
    }

    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        JavaClass jclass = analysisCache.getClassAnalysis(JavaClass.class, classDescriptor);
        this.classContext = analysisCache.getClassAnalysis(ClassContext.class, classDescriptor);
        for (Method m : this.classContext.getMethodsInCallOrder()) {
            if (m.getCode() == null) continue;
            this.method = m;
            MethodDescriptor methodDescriptor = BCELUtil.getMethodDescriptor(jclass, this.method);
            MethodGen methodGen = analysisCache.getMethodAnalysis(MethodGen.class, methodDescriptor);
            if (methodGen == null) continue;
            CFG cfg = analysisCache.getMethodAnalysis(CFG.class, methodDescriptor);
            this.visitMethodCFG(methodDescriptor, cfg);
        }
    }

    protected abstract void visitMethodCFG(MethodDescriptor var1, CFG var2) throws CheckedAnalysisException;
}

