//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.util;

import java.util.List;

import com.google.common.collect.Iterables;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskFactory;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class PatternsVisitorUtil {

    private PatternsVisitorUtil() {
        // no instantiation
    }
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param taskTreeNode
     * @return
     */
    public static ITaskModel createTaskModelFromUserSessions(List<IUserSession> userSessions) {
        return new TaskFactory().createTaskModel(userSessions);
    }
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param taskTreeNodes
     * @return
     */
    public static ITask firstNodeOf(List<ITask> tasks) {
        return Iterables.getFirst(tasks, new NullTask());
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param taskTreeNodes
     * @return
     */
    public static ITask lastNodeOf(List<ITask> tasks) {
        return Iterables.getLast(tasks, new NullTask());
    }
    
}
