//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

import java.io.Serializable;

/**
 * <p>
 * represents a serializable, clonable, iterable representation of a read only list of task
 * instances. The list is ordered. It does not provide methods for changing it.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface ITaskInstanceList extends Serializable, Cloneable, Iterable<ITaskInstance> {

    /**
     * <p>
     * returns the task instance at the position with the given index. May throw an exception
     * if the index is invalid.
     * </p>
     * 
     * @param index the index of the task instance to be returned
     * 
     * @return the task instance at the given index
     */
    public ITaskInstance get(int index);

    /**
     * <p>
     * returns the size of the list, i.e. the number of task instances in the list
     * </p>
     * 
     * @return as described
     */
    public int size();

    /**
     * <p>
     * clones a task instance list by creating exact clones of each contained instance in their
     * order
     * </p>
     * 
     * @return a clone of the task instance list
     */
    public ITaskInstanceList clone();
  
}
