//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IMarkingTemporalRelationship;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
abstract class MarkingTemporalRelationship extends Task
    implements IMarkingTemporalRelationship
{

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    private ITask markedTask;
    
    /**
     * 
     */
    private String relationshipType;
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param description
     */
    MarkingTemporalRelationship(String relationshipType) {
        if ((relationshipType == null) || ("".equals(relationshipType))) {
            throw new IllegalArgumentException
                ("the relationship type must be something meaningful");
        }
        
        this.relationshipType = relationshipType;
        super.setDescription(this.relationshipType);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.IMarkingTemporalRelationship#getMarkedTask()
     */
    @Override
    public ITask getMarkedTask() {
        return markedTask;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.Task#clone()
     */
    @Override
    public synchronized MarkingTemporalRelationship clone() {
        MarkingTemporalRelationship clone = null;
        clone = (MarkingTemporalRelationship) super.clone();
            
        if (markedTask != null) {
            clone.markedTask = markedTask.clone();
        }

        return clone;
    }

    /**
     * @param markedTask the markedTask to set
     */
    protected void setMarkedTask(ITask markedTask) {
        this.markedTask = markedTask;
        
        super.setDescription(relationshipType + " of " + markedTask);
    }

}
