//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns;

import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.MOUSE_CLICK;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.SCROLL;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.TEXT_INPUT;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.ITERATION;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.SEQUENCE;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.EvaluationMethodCaller;
import de.ugoe.cs.autoquest.usability.result.DefectDescriptionResolver;
import de.ugoe.cs.autoquest.usability.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.rules.UsabilityRule;
import de.ugoe.cs.autoquest.usability.rules.UsabilityUsageDefect;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class LongFormUsageDefect extends UsabilityRule implements UsabilityUsageDefect {

    private UsagePattern longFormUsagePattern;
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param taskTree
     */
    public LongFormUsageDefect(ITaskModel taskModel) {
        super(taskModel);
        this.name = "LongFormUsagePattern";
        this.defect = new DefectDescriptionResolver().descriptionFor(this.getClass().getSimpleName());
        initUsagePattern();
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     */
    private void initUsagePattern() {
        UsagePatternBuilder builder = new UsagePatternBuilder();
        UsagePattern fillFormPattern = builder.concernedNode(ITERATION).startsWith(TEXT_INPUT).endsWith(SCROLL).build();
        this.longFormUsagePattern = builder.concernedNode(SEQUENCE).startsWith(MOUSE_CLICK).contains(fillFormPattern).endsWith(MOUSE_CLICK).build();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.usability.rules.UsabilityRule#check()
     */
    @Override
    public Optional<UsabilityDefect> check() {
        Optional<UsabilityDefect> present = Optional.absent();
        if(this.longFormUsagePattern.containedIn(taskModel)) {
            present = Optional.of(this.defect);
        }
        return present;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.usability.rules.UsabilityRule#callEvaluationMetho(de.ugoe.cs.autoquest.usability.EvaluationMethodCaller)
     */
    @Override
    public Optional<UsabilityDefect> callEvaluationMethod(EvaluationMethodCaller evaluationMethodCaller)
    {
        return evaluationMethodCaller.check(this);
    }
}
