//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskVisitor;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
class Task implements ITask {

    /**  */
    private static final long serialVersionUID = 1L;

    /** */
    private static int temporalId = 0;

    /** */
    private int id;

    /** */
    private String description;

    /**
     * 
     */
    Task() {
        id = getNewId();
    }

    /**
     * TODO: comment
     * 
     * @return
     */
    private static synchronized int getNewId() {
        if (temporalId == Integer.MAX_VALUE) {
            temporalId = 0;
        }

        return temporalId++;
    }

    /**
     * @return Returns the name.
     */
    public int getId() {
        return id;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNode#getDescription()
     */
    @Override
    public String getDescription() {
        return description;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.TaskTreeNode#equals(TaskTreeNode)
     */
    @Override
    public final boolean equals(ITask task) {
        // tasks are only equal if they are identical or if they have the same id
        // (may happen, if they are cloned)
        return (this == task) || (this.hashCode() == task.hashCode());
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public synchronized int hashCode() {
        return id;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public synchronized String toString() {
        StringBuffer result = new StringBuffer();
        result.append("task ");
        result.append(id);
        
        if (description != null) {
            result.append(" (");
            result.append(description);
            result.append(')');
        }
        
        return result.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#clone()
     */
    @Override
    public synchronized ITask clone() {
        Task clone = null;
        try {
            clone = (Task) super.clone();
        }
        catch (CloneNotSupportedException e) {
            // this should never happen. Therefore simply dump the exception
            e.printStackTrace();
        }

        return clone;
    }

    /**
     * TODO: comment
     * 
     * @param i
     * @return
     */
    void setDescription(String description) {
        this.description = description;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITask#accept(de.ugoe.cs.autoquest.tasktrees.treeifc.TaskVisitor)
     */
    @Override
    public void accept(ITaskVisitor visitor) {
        visitor.visit(this);
    }

}
