//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskVisitor;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 19.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
class Iteration extends MarkingTemporalRelationship implements IIteration {

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    Iteration() {
        super("iteration");
    }

    /* (non-Javadoc)
     * @see MarkingTemporalRelationship#setMarkedTask(ITask)
     */
    @Override
    protected void setMarkedTask(ITask markedTask) {
        if (markedTask instanceof IIteration) {
            throw new IllegalArgumentException
                ("the marked task of an iteration must not be an iteration");
        }
        else if (markedTask instanceof IOptional) {
            throw new IllegalArgumentException
                ("the marked task of an iteration must not be an optional");
        }
        
        super.setMarkedTask(markedTask);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#clone()
     */
    @Override
    public Iteration clone() {
        return (Iteration) super.clone();
    }
    
    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNode#accept(de.ugoe.cs.autoquest.tasktrees.treeifc.NodeVisitor)
     */
    @Override
    public void accept(ITaskVisitor visitor) {
        visitor.visit(this);
    }

}
