//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith;

import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.MOUSE_CLICK;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.TEXT_INPUT;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.ITERATION;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.SEQUENCE;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePattern;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePatternBuilder;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskModelUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class StartsWithEventContainsEventEndsWithPatternTest {

    @Test
    public void starts_with_event_contains_event_ends_with_pattern_positive() {
        // Given
        String spec = "UserSession {" +
        		      "  Sequence seq1 {" + 
                      "    TextInput t1 {}" +
                      "    MouseClick t2 {}" +
                      "    Iteration {" +
                      "      MouseClick t3 {}" +
                      "    }" +
                      "  }" + 
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        UsagePatternBuilder builder = new UsagePatternBuilder();
        UsagePattern endsWithPattern = builder.concernedNode(ITERATION).startsWith(MOUSE_CLICK).build();
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SEQUENCE).startsWith(TEXT_INPUT).endsWith(endsWithPattern).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void starts_with_event_contains_event_ends_with_pattern_negative() {
        // Given
        String spec = "UserSession {" +
        		      "  Sequence seq1 {" + 
                      "    TextInput t1 {}" +
                      "    MouseClick t2 {}" +
                      "    Iteration {" +
                      "      TextInput t3 {}" +
                      "    }" +
                      "  }" + 
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        UsagePatternBuilder builder = new UsagePatternBuilder();
        UsagePattern endsWithPattern = builder.concernedNode(ITERATION).startsWith(MOUSE_CLICK).build();
        UsagePattern pattern = new UsagePatternBuilder().concernedNode(SEQUENCE).startsWith(TEXT_INPUT).endsWith(endsWithPattern).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }
   
}
