//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith;

import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.MOUSE_CLICK;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.TEXT_INPUT;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.SELECTION;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.SEQUENCE;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePattern;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePatternBuilder;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskModelUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class StartsWithPatternContainsPatternAndEndsWithEventTest {

    @Test
    public void starts_with_pattern_contains_pattern_and_ends_with_event_positive() {
        // Given
        String spec = "UserSession {" +
        		      "  Sequence seq1 {" +
                      "    Selection sel1 {" +
                      "      Sequence seq2 {" +
                      "        TextInput target4 {}" +
                      "        MouseClick target2 {}" +
                      "      }" +
                      "    }" +
                      "    Selection sel1 {" +
                      "      Sequence seq3 {" +
                      "        TextInput target4 {}" +
                      "        EventTask target2 {}" +
                      "      }" +
                      "    }" +
                      "  }" +
                      "  Sequence seq4 {" +
                      "    MouseClick target2 {}" +
                      "    EventTask t5 {}" +
                      "  }" +
                      "  TextInput target3 {}" +
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        UsagePatternBuilder patternBuilder = new UsagePatternBuilder();
        UsagePattern startsWithPattern = patternBuilder.concernedNode(SELECTION).startsWith(TEXT_INPUT).endsWith(MOUSE_CLICK).build();
        UsagePattern containsPattern = patternBuilder.concernedNode(SEQUENCE).startsWith(MOUSE_CLICK).build();
        UsagePattern pattern = patternBuilder.concernedNode(SEQUENCE).startsWith(startsWithPattern).contains(containsPattern).endsWith(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void starts_with_pattern_contains_pattern_and_ends_with_event_negative() {
        // Given
        String spec = "UserSession {" +
        		      "  Sequence seq1 {" +
                      "    Selection sel1 {" +
                      "      Sequence seq2 {" +
                      "        TextInput target4 {}" +
                      "        MouseClick target2 {}" +
                      "      }" +
                      "    }" +
                      "    Selection sel1 {" +
                      "      Sequence seq3 {" +
                      "        TextInput target4 {}" +
                      "        EventTask target2 {}" +
                      "      }" +
                      "    }" +
                      "  }" +
                      "  Sequence seq4 {" +
                      "    TextInput target2 {}" +
                      "    EventTask () {}" +
                      "  }" +
                      "  TextInput target3 {}" +
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        UsagePatternBuilder patternBuilder = new UsagePatternBuilder();
        UsagePattern startsWithPattern = patternBuilder.concernedNode(SELECTION).startsWith(TEXT_INPUT).endsWith(MOUSE_CLICK).build();
        UsagePattern containsPattern = patternBuilder.concernedNode(SEQUENCE).startsWith(MOUSE_CLICK).endsWith(TEXT_INPUT).build();
        UsagePattern pattern = patternBuilder.concernedNode(SEQUENCE).startsWith(startsWithPattern).contains(containsPattern).endsWith(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }
    
}
