//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.result;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;


/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class UsabilityDefect {

    private UsabilityDefectSeverityLevel severityLevel = UsabilityDefectSeverityLevel.NONE;
    
    private String description;
    
    private final EnumMap<UsabilityDefectSeverityLevel, Double> severity;
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param description
     * @param severity
     */
    public UsabilityDefect(String description,
                           EnumMap<UsabilityDefectSeverityLevel, Double> severity)
    {
        this.description = description;
        this.severity = severity;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    public UsabilityDefectSeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param evaluationMetric
     * @return
     */
    public Optional<UsabilityDefect> isPresent(float evaluationMetric) {
        Optional<UsabilityDefect> defect = Optional.absent();
        Map<UsabilityDefectSeverityLevel, Double> matchingSeverityLevels = Maps.filterValues(this.severity, severityForMetric(evaluationMetric));
        if(matchingSeverityLevels.isEmpty()) {
            return defect;
        }
        setDefectAttributes(matchingSeverityLevels, evaluationMetric);
        return Optional.of(this);
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param matchingSeverityLevels
     * @param evaluationMetric
     */
    private void setDefectAttributes(Map<UsabilityDefectSeverityLevel, Double> matchingSeverityLevels,
                                     float evaluationMetric)
    {
        BiMap<Double, UsabilityDefectSeverityLevel> inverse = HashBiMap.create(matchingSeverityLevels).inverse();
        this.severityLevel = inverse.get(Collections.max(inverse.keySet()));
        this.description = String.format(this.description, evaluationMetric);
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     * @param evaluationMetric 
     *
     * @return
     */
    private Predicate< Double> severityForMetric(final float evaluationMetric) {
        return new Predicate<Double>() {
            
            public boolean apply(Double severityThreshold) {
                return evaluationMetric > severityThreshold;
            }
            
        };
    }

}
