/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

public abstract class Descriptors {
    public static final char JAVA_NAME_SEPARATOR = '.';
    public static final char VM_NAME_SEPARATOR = '/';
    private static final boolean RENAME_INNER_CLASSES = false;

    public static String combine(String packageName, String name, char separator) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("null or empty input: name");
        }
        if (packageName == null || packageName.length() == 0) {
            return name;
        }
        return packageName + separator + name;
    }

    public static String combineJavaName(String packageName, String name) {
        return Descriptors.combine(packageName, name, '.');
    }

    public static String combineVMName(String packageName, String name) {
        return Descriptors.combine(packageName, name, '/');
    }

    public static String javaNameToVMName(String javaName) {
        if (javaName == null) {
            return null;
        }
        return javaName.replace('.', '/');
    }

    public static String vmNameToJavaName(String vmName) {
        if (vmName == null) {
            return null;
        }
        return vmName.replace('/', '.');
    }

    public static String methodVMNameToJavaName(String className, String methodVMName, String descriptor, boolean renameInits, boolean shortTypeNames, boolean appendReturnType) {
        StringBuffer out = new StringBuffer();
        if (renameInits) {
            if ("<clinit>".equals(methodVMName)) {
                return "<static initializer>";
            }
            if ("<init>".equals(methodVMName)) {
                out.append(className);
            } else {
                out.append(methodVMName);
            }
        } else {
            if ("<clinit>".equals(methodVMName)) {
                return "<clinit>";
            }
            out.append(methodVMName);
        }
        char[] chars = descriptor.toCharArray();
        out.append(" (");
        int end = chars.length;
        while (chars[--end] != ')') {
        }
        int start = 1;
        while (start < end) {
            if (start > 1) {
                out.append(", ");
            }
            start = Descriptors.typeDescriptorToJavaName(chars, start, shortTypeNames, out);
        }
        if (appendReturnType) {
            out.append("): ");
            Descriptors.typeDescriptorToJavaName(chars, end + 1, shortTypeNames, out);
        } else {
            out.append(')');
        }
        return out.toString();
    }

    private static int typeDescriptorToJavaName(char[] descriptor, int start, boolean shortTypeNames, StringBuffer out) {
        int dims = 0;
        while (descriptor[start] == '[') {
            ++dims;
            ++start;
        }
        char c = descriptor[start++];
        switch (c) {
            case 'L': {
                if (shortTypeNames) {
                    int lastSlash = -1;
                    int s = start;
                    while (descriptor[s] != ';') {
                        if (descriptor[s] == '/') {
                            lastSlash = s;
                        }
                        ++s;
                    }
                    int n = start = lastSlash > 0 ? lastSlash + 1 : start;
                    while (descriptor[start] != ';') {
                        c = descriptor[start];
                        out.append(c);
                        ++start;
                    }
                } else {
                    while (descriptor[start] != ';') {
                        c = descriptor[start];
                        out.append(c != '/' ? c : (char)'.');
                        ++start;
                    }
                }
                ++start;
                break;
            }
            case 'B': {
                out.append("byte");
                break;
            }
            case 'C': {
                out.append("char");
                break;
            }
            case 'D': {
                out.append("double");
                break;
            }
            case 'F': {
                out.append("float");
                break;
            }
            case 'I': {
                out.append("int");
                break;
            }
            case 'J': {
                out.append("long");
                break;
            }
            case 'S': {
                out.append("short");
                break;
            }
            case 'Z': {
                out.append("boolean");
                break;
            }
            case 'V': {
                out.append("void");
                break;
            }
            default: {
                throw new IllegalStateException("unknown type descriptor element: " + c);
            }
        }
        if (dims > 0) {
            out.append(' ');
            for (int d = 0; d < dims; ++d) {
                out.append("[]");
            }
        }
        return start;
    }

    private Descriptors() {
    }
}

