//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
class TaskInstance implements ITaskInstance {
    
    /**  */
    private static final long serialVersionUID = 1L;

    /** */
    private static int temporalId = 0;

    /** */
    private ITask task;
    
    /** */
    private int id;

    /** children */
    private List<ITaskInstance> children;

    /**
     * 
     */
    TaskInstance(ITask task) {
        this.task = task;
        id = getNewId();
    }

    /**
     * TODO: comment
     * 
     * @return
     */
    private static synchronized int getNewId() {
        if (temporalId == Integer.MAX_VALUE) {
            temporalId = 0;
        }

        return temporalId++;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance#getTask()
     */
    @Override
    public ITask getTask() {
        return task;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance#getChildren()
     */
    public synchronized List<ITaskInstance> getChildren() {
        if (children == null) {
            children = new LinkedList<ITaskInstance>();
        }

        return Collections.unmodifiableList(children);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceList#get(int)
     */
    @Override
    public ITaskInstance get(int index) {
        if (children == null) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        else {
            return children.get(index);
        }
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceList#size()
     */
    @Override
    public int size() {
        if (children == null) {
            return 0;
        }
        else {
            return children.size();
        }
    }

    /* (non-Javadoc)
     * @see java.lang.Iterable#iterator()
     */
    @Override
    public Iterator<ITaskInstance> iterator() {
        return getChildren().iterator();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.TaskTreeNode#equals(TaskTreeNode)
     */
    @Override
    public boolean equals(ITaskInstance taskInstance) {
        // task instances are only equal if they are identical or if they have the same id
        // (may happen, if they are cloned)
        return (this == taskInstance) || (this.hashCode() == taskInstance.hashCode());
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public synchronized int hashCode() {
        return id;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public synchronized String toString() {
        StringBuffer result = new StringBuffer();
        result.append("task ");
        result.append(task.getId());
        result.append(" (instance ");
        result.append(id);
        
        if (task.getDescription() != null) {
            result.append(", ");
            result.append(task.getDescription());
        }
        
        if (children != null) {
            result.append(", ");
            result.append(children.size());
            result.append(" children");
        }
        
        result.append(')');
        return result.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#clone()
     */
    @Override
    public synchronized ITaskInstance clone() {
        TaskInstance clone = null;
        try {
            clone = (TaskInstance) super.clone();

            if (children != null) {
                clone.children = new LinkedList<ITaskInstance>();

                for (ITaskInstance child : children) {
                    clone.children.add(child.clone());
                }
            }

        }
        catch (CloneNotSupportedException e) {
            // this should never happen. Therefore simply dump the exception
            e.printStackTrace();
        }

        return clone;
    }

    /**
     * 
     */
    synchronized void addChild(ITaskInstance child) {
        if (children == null) {
            children = new LinkedList<ITaskInstance>();
        }

        children.add(child);
    }

    /**
     * 
     */
    synchronized void addChild(int index, ITaskInstance child) {
        if (children == null) {
            children = new LinkedList<ITaskInstance>();
        }

        children.add(index, child);
    }

    /**
     * TODO: comment
     * 
     * @param i
     * @return
     */
    synchronized ITaskInstance removeChild(int index) {
        if (children != null) {
            return children.remove(index);
        }
        else {
            throw new IllegalArgumentException
                ("this task instance does not have children that can be removed");
        }
    }

    /**
     * @param task the task to set
     */
    void setTask(ITask task) {
        this.task = task;
    }

}
