/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsCommandLine;
import edu.umd.cs.findbugs.FindBugsMain;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.Version;

public class ShowHelp {
    public static void main(String[] args) {
        System.out.println("FindBugs version " + Version.RELEASE + ", " + "http://findbugs.sourceforge.net");
        ShowHelp.showGeneralOptions();
        DetectorFactoryCollection.instance();
        System.out.println("Command line options");
        for (Plugin p : Plugin.getAllPlugins()) {
            for (FindBugsMain m : p.getAllFindBugsMain()) {
                System.out.printf("fb %-12s %-12s %s%n", m.cmd, m.kind, m.description);
            }
        }
        System.out.println();
        System.out.println("GUI Options:");
        FindBugsCommandLine guiCmd = new FindBugsCommandLine(true){};
        guiCmd.printUsage(System.out);
        System.out.println();
        System.out.println("TextUI Options:");
        FindBugs.showCommandLineOptions();
    }

    public static void showSynopsis() {
        System.out.println("Usage: findbugs [general options] [gui options]");
    }

    public static void showGeneralOptions() {
        System.out.println("General options:");
        System.out.println("  -gui             Use the Graphical UI (default behavior)");
        System.out.println("  -textui          Use the Text UI");
        System.out.println("  -jvmArgs args    Pass args to JVM");
        System.out.println("  -maxHeap size    Maximum Java heap size in megabytes (default=768)");
        System.out.println("  -javahome <dir>  Specify location of JRE");
        System.out.println("  -help            Display command line options");
        System.out.println("  -debug           Enable debug tracing in FindBugs");
    }
}

