//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns.visitors.endswith;

import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.MOUSE_CLICK;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.TEXT_INPUT;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.ITERATION;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.SELECTION;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.SEQUENCE;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.rules.patterns.InteractionPattern;
import de.ugoe.cs.autoquest.usability.rules.patterns.InteractionPatternBuilder;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskModelUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class EndsWithPatternTest {

    @Test
    public void ends_with_pattern_positive() {
        // Given
        String spec = "UserSession {" +
        		      "  Sequence seq1 {" +
                      "    EventTask target2 {}" +
                      "    EventTask target3 {}" +
                      "    Selection sel1 {" +
                      "      Sequence seq2 {" +
                      "        TextInput target4 {}" +
                      "        MouseClick target5 {}" +
                      "      }" +
                      "    }" +
                      "    Selection sel1 {" +
                      "      Sequence seq3 {" +
                      "        TextInput target4 {}" +
                      "        EventTask target3 {}" +
                      "      }" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        InteractionPatternBuilder patternBuilder = new InteractionPatternBuilder();
        InteractionPattern endsWithPattern = patternBuilder.concernedNode(SELECTION).startsWith(TEXT_INPUT).endsWith(MOUSE_CLICK).build();
        InteractionPattern pattern = patternBuilder.concernedNode(SEQUENCE).endsWith(endsWithPattern).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void ends_with_pattern_negative() {
        // Given
        String spec = "UserSession {" +
        		      "  Sequence seg0 {" +
        		      "    Selection sel1 {" +
                      "      Sequence seq1 {" +
                      "        EventTask target1 {}" +
                      "        EventTask target2 {}" +
                      "      }" +
                      "    }" +
                      "    Selection sel1 {" +
                      "      Iteration it1 {" +
                      "        Sequence seq2 {" +
                      "          MouseClick target5 {}" +
                      "          EventTask target4 {}" +
                      "          EventTask target2 {}" +
                      "        }" +
                      "      }" +
                      "    }" +
                      "    Selection sel1 {" +
                      "      Sequence seq3 {" +
                      "        EventTask target5 {}" +
                      "        EventTask target6 {}" +
                      "      }" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        InteractionPatternBuilder patternBuilder = new InteractionPatternBuilder();
        InteractionPattern endsWithPattern = patternBuilder.concernedNode(ITERATION).startsWith(MOUSE_CLICK).contains(TEXT_INPUT).build();
        InteractionPattern pattern = patternBuilder.concernedNode(SEQUENCE).endsWith(endsWithPattern).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }
    
}
