/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.ant;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.ant.PropertyElement;
import com.vladium.emma.ant.SuppressableTask;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GenericCfg {
    private final Task m_task;
    private final List m_genericPropertyElements;
    private File m_settingsFile;
    private transient IProperties m_fileSettings;
    private transient IProperties m_genericSettings;

    public GenericCfg(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("null input: task");
        }
        this.m_task = task;
        this.m_genericPropertyElements = new ArrayList();
    }

    public void setProperties(File file) {
        this.m_settingsFile = file;
    }

    public PropertyElement createProperty() {
        this.m_genericSettings = null;
        PropertyElement property = new PropertyElement();
        this.m_genericPropertyElements.add(property);
        return property;
    }

    public IProperties getFileSettings() {
        IProperties fileSettings = this.m_fileSettings;
        if (fileSettings == null && this.m_settingsFile != null) {
            try {
                fileSettings = EMMAProperties.wrap((Properties)Property.getPropertiesFromFile((File)this.m_settingsFile));
            }
            catch (IOException ioe) {
                throw (BuildException)SuppressableTask.newBuildException(this.m_task.getTaskName() + ": property file [" + this.m_settingsFile.getAbsolutePath() + "] could not be read", ioe, this.m_task.getLocation()).fillInStackTrace();
            }
            this.m_fileSettings = fileSettings;
            return fileSettings;
        }
        return fileSettings;
    }

    public IProperties getGenericSettings() {
        IProperties genericSettings = this.m_genericSettings;
        if (genericSettings == null) {
            genericSettings = EMMAProperties.wrap((Properties)new Properties());
            Iterator i = this.m_genericPropertyElements.iterator();
            while (i.hasNext()) {
                PropertyElement property = (PropertyElement)i.next();
                String name = property.getName();
                String value = property.getValue();
                if (value == null) {
                    value = "";
                }
                if (name == null) continue;
                String currentValue = genericSettings.getProperty(name);
                if (currentValue != null && !value.equals(currentValue)) {
                    throw (BuildException)SuppressableTask.newBuildException(this.m_task.getTaskName() + ": conflicting settings for property [" + name + "]: [" + value + "]", this.m_task.getLocation()).fillInStackTrace();
                }
                genericSettings.setProperty(name, value);
            }
            this.m_genericSettings = genericSettings;
            return genericSettings;
        }
        return genericSettings;
    }
}

