/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.ByteBufferWrapper;
import com.sun.j3d.internal.Distance;
import com.sun.j3d.internal.DoubleBufferWrapper;
import com.sun.j3d.internal.FloatBufferWrapper;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CompileState;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Renderer;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point2d;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.TexCoord4f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

abstract class GeometryArrayRetained
extends GeometryRetained {
    int vertexFormat;
    int c4fAllocated = 0;
    int vertexCount;
    int validVertexCount;
    float[] vertexData;
    float[][] mvertexData;
    int stride;
    int texCoordStride;
    int coordinateOffset;
    int normalOffset;
    int colorOffset;
    int textureOffset;
    float[] lastAlpha = new float[1];
    float lastScreenAlpha = -1.0f;
    int colorChanged = 0;
    boolean alphaChanged = false;
    static final float ByteToFloatScale = 0.003921569f;
    static final float FloatToByteScale = 255.0f;
    boolean inUpdater = false;
    ArrayList gaList = new ArrayList(1);
    static final int targetThreads = 192;
    float[] floatRefCoords = null;
    double[] doubleRefCoords = null;
    Point3d[] p3dRefCoords = null;
    Point3f[] p3fRefCoords = null;
    J3DBuffer coordRefBuffer = null;
    FloatBufferWrapper floatBufferRefCoords = null;
    DoubleBufferWrapper doubleBufferRefCoords = null;
    int initialCoordIndex = 0;
    int initialColorIndex = 0;
    int initialNormalIndex = 0;
    int[] initialTexCoordIndex = null;
    int initialVertexIndex = 0;
    float[] floatRefColors = null;
    byte[] byteRefColors = null;
    Color3f[] c3fRefColors = null;
    Color4f[] c4fRefColors = null;
    Color3b[] c3bRefColors = null;
    Color4b[] c4bRefColors = null;
    J3DBuffer colorRefBuffer = null;
    FloatBufferWrapper floatBufferRefColors = null;
    ByteBufferWrapper byteBufferRefColors = null;
    int vertexType = 0;
    static final int PF = 1;
    static final int PD = 2;
    static final int P3F = 4;
    static final int P3D = 8;
    static final int VERTEX_DEFINED = 15;
    static final int CF = 16;
    static final int CUB = 32;
    static final int C3F = 64;
    static final int C4F = 128;
    static final int C3UB = 256;
    static final int C4UB = 512;
    static final int COLOR_DEFINED = 1008;
    static final int NF = 1024;
    static final int N3F = 2048;
    static final int NORMAL_DEFINED = 3072;
    static final int TF = 4096;
    static final int T2F = 8192;
    static final int T3F = 16384;
    static final int TEXCOORD_DEFINED = 28672;
    static final int COORD_FLOAT = 1;
    static final int COORD_DOUBLE = 2;
    static final int COLOR_FLOAT = 4;
    static final int COLOR_BYTE = 8;
    static final int NORMAL_FLOAT = 16;
    static final int TEXCOORD_FLOAT = 32;
    float[] floatRefNormals = null;
    Vector3f[] v3fRefNormals = null;
    J3DBuffer normalRefBuffer = null;
    FloatBufferWrapper floatBufferRefNormals = null;
    Object[] refTexCoords = null;
    TexCoord2f[] t2fRefTexCoords = null;
    TexCoord3f[] t3fRefTexCoords = null;
    Object[] refTexCoordsBuffer = null;
    float[] interLeavedVertexData = null;
    J3DBuffer interleavedVertexBuffer = null;
    FloatBufferWrapper interleavedFloatBufferImpl = null;
    float[] mirrorFloatRefCoords = null;
    double[] mirrorDoubleRefCoords = null;
    float[] mirrorFloatRefNormals = null;
    float[] mirrorFloatRefTexCoords = null;
    Object[] mirrorRefTexCoords = null;
    float[][] mirrorFloatRefColors = new float[1][];
    byte[][] mirrorUnsignedByteRefColors = new byte[1][];
    float[][] mirrorInterleavedColorPointer = null;
    int mirrorVertexAllocated = 0;
    int mirrorColorAllocated = 0;
    boolean mirrorTexCoordAllocated = false;
    boolean mirrorNormalAllocated = false;
    static final int COORDINATE_CHANGED = 1;
    static final int NORMAL_CHANGED = 2;
    static final int COLOR_CHANGED = 4;
    static final int TEXTURE_CHANGED = 8;
    static final int BOUNDS_CHANGED = 16;
    static final int INDEX_CHANGED = 32;
    static final int STRIPCOUNT_CHANGED = 64;
    static final int VERTEX_CHANGED = 15;
    static final int[] defaultTexCoordSetMap = new int[]{0};
    int texCoordSetCount = 0;
    int[] texCoordSetMap = null;
    int[] texCoordSetMapOffset = null;
    long pVertexBuffers = 0L;
    int dirtyFlag = 47;
    int resourceCreationMask = 0;
    int[] renderMolPerDlist = new int[2];
    long[] timeStampPerDlist = new long[2];
    int dlistId = -1;
    Integer dlistObj = null;
    static final int INIT_MIRROR_GEOMETRY = 2;
    ArrayList morphUniverseList = null;
    ArrayList morphUserLists = null;
    int[] geoOffset;
    int[] compileVcount;
    boolean isCompiled = false;
    boolean isShared = false;
    IndexedGeometryArrayRetained cloneSourceArray = null;
    static final double EPS = 1.0E-13;

    native int build(int var1);

    native void freeD3DArray(boolean var1);

    GeometryArrayRetained() {
        this.lastAlpha[0] = 1.0f;
    }

    void setLive(boolean bl, int n) {
        this.dirtyFlag = 47;
        this.isEditable = !this.isWriteStatic();
        super.doSetLive(bl, n);
        super.markAsLive();
        if (this.refCount > 1) {
            this.isShared = true;
        } else if (this instanceof IndexedGeometryArrayRetained) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 1024;
            j3dMessage.type = 17;
            j3dMessage.universe = null;
            j3dMessage.args[0] = null;
            j3dMessage.args[1] = this;
            j3dMessage.args[2] = new Integer(2);
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.refCount <= 0) {
            if (this.pVertexBuffers != 0L) {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.threads = 16;
                j3dMessage.type = 44;
                j3dMessage.universe = null;
                j3dMessage.view = null;
                j3dMessage.args[0] = null;
                j3dMessage.args[1] = this;
                Enumeration enumeration = Screen3D.deviceRendererMap.elements();
                Renderer renderer = (Renderer)enumeration.nextElement();
                renderer.rendererStructure.addMessage(j3dMessage);
                VirtualUniverse.mc.setWorkForRequestRenderer();
            }
            this.isShared = false;
        }
    }

    void computeBoundingBox() {
        if ((this.vertexFormat & 0x80) == 0) {
            this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        } else if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                this.computeBoundingBox(this.initialCoordIndex, this.interleavedFloatBufferImpl);
            } else if ((this.vertexType & 1) != 0) {
                this.computeBoundingBox(this.floatBufferRefCoords);
            } else if ((this.vertexType & 2) != 0) {
                this.computeBoundingBox(this.doubleBufferRefCoords);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            this.computeBoundingBox(this.initialCoordIndex, this.interLeavedVertexData);
        } else if ((this.vertexType & 1) != 0) {
            this.computeBoundingBox(this.floatRefCoords);
        } else if ((this.vertexType & 4) != 0) {
            this.computeBoundingBox(this.p3fRefCoords);
        } else if ((this.vertexType & 8) != 0) {
            this.computeBoundingBox(this.p3dRefCoords);
        } else if ((this.vertexType & 2) != 0) {
            this.computeBoundingBox(this.doubleRefCoords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCoordsChanged(boolean bl) {
        if (bl) {
            BoundingBox boundingBox = this.geoBounds;
            synchronized (boundingBox) {
                this.geoBounds.setLower(-1.0, -1.0, -1.0);
                this.geoBounds.setUpper(1.0, 1.0, 1.0);
                this.boundsDirty = false;
            }
            Point3d point3d = this.centroid;
            synchronized (point3d) {
                this.recompCentroid = false;
                this.centroid.set((Tuple3d)this.geoBounds.getCenter());
            }
        }
        Point3d point3d = this.centroid;
        synchronized (point3d) {
            this.recompCentroid = true;
        }
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            this.boundsDirty = true;
            this.computeBoundingBox();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(int n, float[] fArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n2 = n * this.stride + this.coordinateOffset;
            double d4 = d3 = (double)fArray[n2];
            double d5 = d2 = (double)fArray[n2 + 1];
            double d6 = d = (double)fArray[n2 + 2];
            n2 += this.stride;
            int n3 = 1;
            while (n3 < this.validVertexCount) {
                if ((double)fArray[n2] > d3) {
                    d3 = fArray[n2];
                }
                if ((double)fArray[n2] < d4) {
                    d4 = fArray[n2];
                }
                if ((double)fArray[n2 + 1] > d2) {
                    d2 = fArray[n2 + 1];
                }
                if ((double)fArray[n2 + 1] < d5) {
                    d5 = fArray[n2 + 1];
                }
                if ((double)fArray[n2 + 2] > d) {
                    d = fArray[n2 + 2];
                }
                if ((double)fArray[n2 + 2] < d6) {
                    d6 = fArray[n2 + 2];
                }
                n2 += this.stride;
                ++n3;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(int n, FloatBufferWrapper floatBufferWrapper) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n2 = n * this.stride + this.coordinateOffset;
            double d4 = d3 = (double)floatBufferWrapper.get(n2);
            double d5 = d2 = (double)floatBufferWrapper.get(n2 + 1);
            double d6 = d = (double)floatBufferWrapper.get(n2 + 2);
            n2 += this.stride;
            int n3 = 1;
            while (n3 < this.validVertexCount) {
                if ((double)floatBufferWrapper.get(n2) > d3) {
                    d3 = floatBufferWrapper.get(n2);
                }
                if ((double)floatBufferWrapper.get(n2) < d4) {
                    d4 = floatBufferWrapper.get(n2);
                }
                if ((double)floatBufferWrapper.get(n2 + 1) > d2) {
                    d2 = floatBufferWrapper.get(n2 + 1);
                }
                if ((double)floatBufferWrapper.get(n2 + 1) < d5) {
                    d5 = floatBufferWrapper.get(n2 + 1);
                }
                if ((double)floatBufferWrapper.get(n2 + 2) > d) {
                    d = floatBufferWrapper.get(n2 + 2);
                }
                if ((double)floatBufferWrapper.get(n2 + 2) < d6) {
                    d6 = floatBufferWrapper.get(n2 + 2);
                }
                n2 += this.stride;
                ++n3;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(DoubleBufferWrapper doubleBufferWrapper) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n = this.initialCoordIndex;
            int n2 = 3 * this.validVertexCount;
            double d4 = d3 = doubleBufferWrapper.get(n++);
            double d5 = d2 = doubleBufferWrapper.get(n++);
            double d6 = d = doubleBufferWrapper.get(n++);
            int n3 = n;
            while (n3 < n2) {
                int n4 = n3 + 1;
                int n5 = n3 + 2;
                if (doubleBufferWrapper.get(n3) > d3) {
                    d3 = doubleBufferWrapper.get(n3);
                }
                if (doubleBufferWrapper.get(n3) < d4) {
                    d4 = doubleBufferWrapper.get(n3);
                }
                if (doubleBufferWrapper.get(n4) > d2) {
                    d2 = doubleBufferWrapper.get(n4);
                }
                if (doubleBufferWrapper.get(n4) < d5) {
                    d5 = doubleBufferWrapper.get(n4);
                }
                if (doubleBufferWrapper.get(n5) > d) {
                    d = doubleBufferWrapper.get(n5);
                }
                if (doubleBufferWrapper.get(n5) < d6) {
                    d6 = doubleBufferWrapper.get(n5);
                }
                n3 += 3;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(FloatBufferWrapper floatBufferWrapper) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n = this.initialCoordIndex;
            int n2 = 3 * this.validVertexCount;
            double d4 = d3 = (double)floatBufferWrapper.get(n++);
            double d5 = d2 = (double)floatBufferWrapper.get(n++);
            double d6 = d = (double)floatBufferWrapper.get(n++);
            int n3 = n;
            while (n3 < n2) {
                int n4 = n3 + 1;
                int n5 = n3 + 2;
                if ((double)floatBufferWrapper.get(n3) > d3) {
                    d3 = floatBufferWrapper.get(n3);
                }
                if ((double)floatBufferWrapper.get(n3) < d4) {
                    d4 = floatBufferWrapper.get(n3);
                }
                if ((double)floatBufferWrapper.get(n4) > d2) {
                    d2 = floatBufferWrapper.get(n4);
                }
                if ((double)floatBufferWrapper.get(n4) < d5) {
                    d5 = floatBufferWrapper.get(n4);
                }
                if ((double)floatBufferWrapper.get(n5) > d) {
                    d = floatBufferWrapper.get(n5);
                }
                if ((double)floatBufferWrapper.get(n5) < d6) {
                    d6 = floatBufferWrapper.get(n5);
                }
                n3 += 3;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(float[] fArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n = this.initialCoordIndex;
            int n2 = 3 * this.validVertexCount;
            double d4 = d3 = (double)fArray[n++];
            double d5 = d2 = (double)fArray[n++];
            double d6 = d = (double)fArray[n++];
            int n3 = n;
            while (n3 < n2) {
                int n4 = n3 + 1;
                int n5 = n3 + 2;
                if ((double)fArray[n3] > d3) {
                    d3 = fArray[n3];
                }
                if ((double)fArray[n3] < d4) {
                    d4 = fArray[n3];
                }
                if ((double)fArray[n4] > d2) {
                    d2 = fArray[n4];
                }
                if ((double)fArray[n4] < d5) {
                    d5 = fArray[n4];
                }
                if ((double)fArray[n5] > d) {
                    d = fArray[n5];
                }
                if ((double)fArray[n5] < d6) {
                    d6 = fArray[n5];
                }
                n3 += 3;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(double[] dArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n = this.initialCoordIndex;
            int n2 = 3 * this.validVertexCount;
            double d4 = d3 = dArray[n++];
            double d5 = d2 = dArray[n++];
            double d6 = d = dArray[n++];
            int n3 = n;
            while (n3 < n2) {
                int n4 = n3 + 1;
                int n5 = n3 + 2;
                if (dArray[n3] > d3) {
                    d3 = dArray[n3];
                }
                if (dArray[n3] < d4) {
                    d4 = dArray[n3];
                }
                if (dArray[n4] > d2) {
                    d2 = dArray[n4];
                }
                if (dArray[n4] < d5) {
                    d5 = dArray[n4];
                }
                if (dArray[n5] > d) {
                    d = dArray[n5];
                }
                if (dArray[n5] < d6) {
                    d6 = dArray[n5];
                }
                n3 += 3;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(Point3f[] point3fArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            double d4 = d3 = (double)point3fArray[this.initialCoordIndex].x;
            double d5 = d2 = (double)point3fArray[this.initialCoordIndex].y;
            double d6 = d = (double)point3fArray[this.initialCoordIndex].z;
            int n = this.initialCoordIndex + 1;
            while (n < this.validVertexCount) {
                Point3f point3f = point3fArray[n];
                if ((double)point3f.x > d3) {
                    d3 = point3f.x;
                }
                if ((double)point3f.x < d4) {
                    d4 = point3f.x;
                }
                if ((double)point3f.y > d2) {
                    d2 = point3f.y;
                }
                if ((double)point3f.y < d5) {
                    d5 = point3f.y;
                }
                if ((double)point3f.z > d) {
                    d = point3f.z;
                }
                if ((double)point3f.z < d6) {
                    d6 = point3f.z;
                }
                ++n;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(Point3d[] point3dArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            double d4 = d3 = point3dArray[this.initialCoordIndex].x;
            double d5 = d2 = point3dArray[this.initialCoordIndex].y;
            double d6 = d = point3dArray[this.initialCoordIndex].z;
            int n = this.initialCoordIndex + 1;
            while (n < this.validVertexCount) {
                Point3d point3d = point3dArray[n];
                if (point3d.x > d3) {
                    d3 = point3d.x;
                }
                if (point3d.x < d4) {
                    d4 = point3d.x;
                }
                if (point3d.y > d2) {
                    d2 = point3d.y;
                }
                if (point3d.y < d5) {
                    d5 = point3d.y;
                }
                if (point3d.z > d) {
                    d = point3d.z;
                }
                if (point3d.z < d6) {
                    d6 = point3d.z;
                }
                ++n;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    synchronized void update() {
    }

    void setupMirrorVertexPointer(int n) {
        switch (n) {
            case 1: {
                if (this.floatRefCoords == null) {
                    if ((this.vertexType & 0xF) != 1) break;
                    this.vertexType &= 0xFFFFFFFE;
                    this.mirrorFloatRefCoords = null;
                    this.mirrorVertexAllocated &= 0xFFFFFFFE;
                    break;
                }
                this.vertexType |= 1;
                this.mirrorFloatRefCoords = this.floatRefCoords;
                this.mirrorVertexAllocated &= 0xFFFFFFFE;
                break;
            }
            case 2: {
                if (this.doubleRefCoords == null) {
                    if ((this.vertexType & 0xF) == 2) {
                        this.mirrorDoubleRefCoords = null;
                        this.mirrorVertexAllocated &= 0xFFFFFFFD;
                        this.vertexType &= 0xFFFFFFFD;
                    }
                    this.vertexType &= 0xFFFFFFFD;
                    break;
                }
                this.vertexType |= 2;
                this.mirrorDoubleRefCoords = this.doubleRefCoords;
                this.mirrorVertexAllocated &= 0xFFFFFFFD;
                break;
            }
            case 4: {
                if (this.p3fRefCoords == null) {
                    this.vertexType &= 0xFFFFFFFB;
                    break;
                }
                this.vertexType |= 4;
                if ((this.mirrorVertexAllocated & 1) == 0) {
                    this.mirrorFloatRefCoords = new float[this.vertexCount * 3];
                    this.mirrorVertexAllocated |= 1;
                }
                int n2 = this.initialCoordIndex * 3;
                int n3 = this.initialCoordIndex;
                while (n3 < this.validVertexCount) {
                    this.mirrorFloatRefCoords[n2++] = this.p3fRefCoords[n3].x;
                    this.mirrorFloatRefCoords[n2++] = this.p3fRefCoords[n3].y;
                    this.mirrorFloatRefCoords[n2++] = this.p3fRefCoords[n3].z;
                    ++n3;
                }
                break;
            }
            case 8: {
                if (this.p3dRefCoords == null) {
                    this.vertexType &= 0xFFFFFFF7;
                    break;
                }
                this.vertexType |= 8;
                if ((this.mirrorVertexAllocated & 2) == 0) {
                    this.mirrorDoubleRefCoords = new double[this.vertexCount * 3];
                    this.mirrorVertexAllocated |= 2;
                }
                int n4 = this.initialCoordIndex * 3;
                int n5 = this.initialCoordIndex;
                while (n5 < this.validVertexCount) {
                    this.mirrorDoubleRefCoords[n4++] = this.p3dRefCoords[n5].x;
                    this.mirrorDoubleRefCoords[n4++] = this.p3dRefCoords[n5].y;
                    this.mirrorDoubleRefCoords[n4++] = this.p3dRefCoords[n5].z;
                    ++n5;
                }
                break;
            }
        }
    }

    void setupMirrorVertexPointerNIOBuffer(int n) {
        boolean bl = false;
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    void setupMirrorInterleavedColorPointer(boolean bl) {
        if (bl || this.c4fAllocated != 0) {
            int n = 4 * this.vertexCount;
            if (this.mirrorInterleavedColorPointer == null) {
                this.mirrorInterleavedColorPointer = new float[1][n];
            }
            int n2 = 4 * this.initialVertexIndex;
            int n3 = this.stride * this.initialVertexIndex + this.colorOffset;
            if ((this.vertexFormat & 0x800) == 0 && this.interLeavedVertexData != null) {
                if ((this.vertexFormat & 8) != 0) {
                    int n4 = this.initialVertexIndex;
                    while (n4 < this.validVertexCount) {
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3];
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3 + 1];
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3 + 2];
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3 + 3];
                        n3 += this.stride;
                        ++n4;
                    }
                } else {
                    int n5 = this.initialVertexIndex;
                    while (n5 < this.validVertexCount) {
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3];
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3 + 1];
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3 + 2];
                        this.mirrorInterleavedColorPointer[0][n2++] = 1.0f;
                        n3 += this.stride;
                        ++n5;
                    }
                }
            } else if ((this.vertexFormat & 8) != 0 && this.interleavedFloatBufferImpl != null) {
                int n6 = this.initialVertexIndex;
                while (n6 < this.validVertexCount) {
                    this.interleavedFloatBufferImpl.position(n3);
                    this.interleavedFloatBufferImpl.get(this.mirrorInterleavedColorPointer[0], n2, 4);
                    n2 += 4;
                    n3 += this.stride;
                    ++n6;
                }
            } else {
                int n7 = this.initialVertexIndex;
                while (n7 < this.validVertexCount) {
                    this.interleavedFloatBufferImpl.position(n3);
                    this.interleavedFloatBufferImpl.get(this.mirrorInterleavedColorPointer[0], n2, 3);
                    this.mirrorInterleavedColorPointer[0][n2 + 3] = 1.0f;
                    n2 += 4;
                    n3 += this.stride;
                    ++n7;
                }
            }
            this.c4fAllocated = 8;
        }
    }

    /*
     * Unable to fully structure code
     */
    void setupMirrorColorPointer(int var1_1, boolean var2_2) {
        block60: {
            block59: {
                var4_3 = 0;
                var5_4 = 0;
                if (this.c4fAllocated == 0 && !var2_2) {
                    var6_5 = 3;
                } else {
                    if (var2_2 && this.c4fAllocated == 0 && (this.vertexFormat & 8) == 0) {
                        this.mirrorColorAllocated = 0;
                    }
                    this.c4fAllocated = 8;
                    var6_5 = 4;
                }
                if ((this.vertexFormat & 2048) != 0) break block59;
                switch (var1_1) {
                    case 16: {
                        if (this.floatRefColors == null) {
                            if (this.c4fAllocated == 0 && !var2_2 && (this.vertexType & 1008) == 16) {
                                this.mirrorFloatRefColors[0] = null;
                                this.mirrorColorAllocated &= -17;
                            }
                            this.vertexType &= -17;
                            return;
                        }
                        this.vertexType |= 16;
                        if (this.c4fAllocated == 0 && !var2_2) {
                            this.mirrorFloatRefColors[0] = this.floatRefColors;
                            this.mirrorColorAllocated &= -17;
                            break;
                        }
                        if ((this.mirrorColorAllocated & 16) == 0) {
                            this.mirrorFloatRefColors[0] = new float[4 * this.vertexCount];
                            this.mirrorColorAllocated |= 16;
                        }
                        if ((this.vertexFormat & 8) != 0) ** GOTO lbl39
                        var4_3 = this.initialColorIndex * 3;
                        var5_4 = this.initialColorIndex * 4;
                        var3_6 = this.initialColorIndex;
                        while (var3_6 < this.validVertexCount) {
                            this.mirrorFloatRefColors[0][var5_4++] = this.floatRefColors[var4_3++];
                            this.mirrorFloatRefColors[0][var5_4++] = this.floatRefColors[var4_3++];
                            this.mirrorFloatRefColors[0][var5_4++] = this.floatRefColors[var4_3++];
                            this.mirrorFloatRefColors[0][var5_4++] = 1.0f;
                            ++var3_6;
                        }
                        break block60;
lbl39:
                        // 1 sources

                        var4_3 = this.initialColorIndex * 4;
                        System.arraycopy(this.floatRefColors, var4_3, this.mirrorFloatRefColors[0], var4_3, 4 * this.validVertexCount);
                        break;
                    }
                    case 32: {
                        if (this.byteRefColors == null) {
                            if (this.c4fAllocated == 0 && !var2_2 && (this.vertexType & 1008) == 32) {
                                this.mirrorUnsignedByteRefColors[0] = null;
                                this.mirrorColorAllocated &= -33;
                            }
                            this.vertexType &= -33;
                            return;
                        }
                        this.vertexType |= 32;
                        if (this.c4fAllocated == 0 && !var2_2) {
                            this.mirrorUnsignedByteRefColors[0] = this.byteRefColors;
                            this.mirrorColorAllocated &= -33;
                            break;
                        }
                        if ((this.mirrorColorAllocated & 32) == 0) {
                            this.mirrorUnsignedByteRefColors[0] = new byte[4 * this.vertexCount];
                            this.mirrorColorAllocated |= 32;
                        }
                        if ((this.vertexFormat & 8) != 0) ** GOTO lbl69
                        var4_3 = this.initialColorIndex * 3;
                        var5_4 = this.initialColorIndex * 4;
                        var3_7 = this.initialColorIndex;
                        while (var3_7 < this.validVertexCount) {
                            this.mirrorUnsignedByteRefColors[0][var5_4++] = this.byteRefColors[var4_3++];
                            this.mirrorUnsignedByteRefColors[0][var5_4++] = this.byteRefColors[var4_3++];
                            this.mirrorUnsignedByteRefColors[0][var5_4++] = this.byteRefColors[var4_3++];
                            this.mirrorUnsignedByteRefColors[0][var5_4++] = -1;
                            ++var3_7;
                        }
                        break block60;
lbl69:
                        // 1 sources

                        var4_3 = this.initialColorIndex * 4;
                        System.arraycopy(this.byteRefColors, var4_3, this.mirrorUnsignedByteRefColors[0], var4_3, 4 * this.validVertexCount);
                        break;
                    }
                    case 64: {
                        if (this.c3fRefColors == null) {
                            this.vertexType &= -65;
                            return;
                        }
                        this.vertexType |= 64;
                        if ((this.mirrorColorAllocated & 16) == 0) {
                            this.mirrorFloatRefColors[0] = new float[this.vertexCount * var6_5];
                            this.mirrorColorAllocated |= 16;
                        }
                        if ((this.c4fAllocated & 8) == 0) {
                            var5_4 = this.initialColorIndex * 3;
                            var3_8 = this.initialColorIndex;
                            while (var3_8 < this.validVertexCount) {
                                this.mirrorFloatRefColors[0][var5_4++] = this.c3fRefColors[var3_8].x;
                                this.mirrorFloatRefColors[0][var5_4++] = this.c3fRefColors[var3_8].y;
                                this.mirrorFloatRefColors[0][var5_4++] = this.c3fRefColors[var3_8].z;
                                ++var3_8;
                            }
                        } else {
                            var5_4 = this.initialColorIndex * 4;
                            var3_9 = this.initialColorIndex;
                            while (var3_9 < this.validVertexCount) {
                                this.mirrorFloatRefColors[0][var5_4++] = this.c3fRefColors[var3_9].x;
                                this.mirrorFloatRefColors[0][var5_4++] = this.c3fRefColors[var3_9].y;
                                this.mirrorFloatRefColors[0][var5_4++] = this.c3fRefColors[var3_9].z;
                                this.mirrorFloatRefColors[0][var5_4++] = 1.0f;
                                ++var3_9;
                            }
                        }
                        break block60;
                    }
                    case 128: {
                        if (this.c4fRefColors == null) {
                            this.vertexType &= -129;
                            return;
                        }
                        this.vertexType |= 128;
                        if ((this.mirrorColorAllocated & 16) == 0) {
                            this.mirrorFloatRefColors[0] = new float[this.vertexCount << 2];
                            this.mirrorColorAllocated |= 16;
                        }
                        var5_4 = this.initialColorIndex * 4;
                        var3_10 = this.initialColorIndex;
                        while (var3_10 < this.validVertexCount) {
                            this.mirrorFloatRefColors[0][var5_4++] = this.c4fRefColors[var3_10].x;
                            this.mirrorFloatRefColors[0][var5_4++] = this.c4fRefColors[var3_10].y;
                            this.mirrorFloatRefColors[0][var5_4++] = this.c4fRefColors[var3_10].z;
                            this.mirrorFloatRefColors[0][var5_4++] = this.c4fRefColors[var3_10].w;
                            ++var3_10;
                        }
                        break block60;
                    }
                    case 256: {
                        if (this.c3bRefColors == null) {
                            this.vertexType &= -257;
                            return;
                        }
                        this.vertexType |= 256;
                        if ((this.mirrorColorAllocated & 32) == 0) {
                            this.mirrorUnsignedByteRefColors[0] = new byte[this.vertexCount * var6_5];
                            this.mirrorColorAllocated |= 32;
                        }
                        if ((this.c4fAllocated & 8) == 0) {
                            var5_4 = this.initialColorIndex * 3;
                            var3_11 = this.initialColorIndex;
                            while (var3_11 < this.validVertexCount) {
                                this.mirrorUnsignedByteRefColors[0][var5_4++] = this.c3bRefColors[var3_11].x;
                                this.mirrorUnsignedByteRefColors[0][var5_4++] = this.c3bRefColors[var3_11].y;
                                this.mirrorUnsignedByteRefColors[0][var5_4++] = this.c3bRefColors[var3_11].z;
                                ++var3_11;
                            }
                        } else {
                            var5_4 = this.initialColorIndex * 4;
                            var3_12 = this.initialColorIndex;
                            while (var3_12 < this.validVertexCount) {
                                this.mirrorUnsignedByteRefColors[0][var5_4++] = this.c3bRefColors[var3_12].x;
                                this.mirrorUnsignedByteRefColors[0][var5_4++] = this.c3bRefColors[var3_12].y;
                                this.mirrorUnsignedByteRefColors[0][var5_4++] = this.c3bRefColors[var3_12].z;
                                this.mirrorUnsignedByteRefColors[0][var5_4++] = -1;
                                ++var3_12;
                            }
                        }
                        break block60;
                    }
                    case 512: {
                        if (this.c4bRefColors == null) {
                            this.vertexType &= -513;
                            return;
                        }
                        this.vertexType |= 512;
                        if ((this.mirrorColorAllocated & 32) == 0) {
                            this.mirrorUnsignedByteRefColors[0] = new byte[this.vertexCount << 2];
                            this.mirrorColorAllocated |= 32;
                        }
                        var5_4 = this.initialColorIndex * 4;
                        var3_13 = this.initialColorIndex;
                        while (var3_13 < this.validVertexCount) {
                            this.mirrorUnsignedByteRefColors[0][var5_4++] = this.c4bRefColors[var3_13].x;
                            this.mirrorUnsignedByteRefColors[0][var5_4++] = this.c4bRefColors[var3_13].y;
                            this.mirrorUnsignedByteRefColors[0][var5_4++] = this.c4bRefColors[var3_13].z;
                            this.mirrorUnsignedByteRefColors[0][var5_4++] = this.c4bRefColors[var3_13].w;
                            ++var3_13;
                        }
                        break block60;
                    }
                }
                break block60;
            }
            if (this.colorRefBuffer == null) {
                if (this.c4fAllocated == 0 && !var2_2 && (this.vertexType & 1008) == 16) {
                    this.mirrorFloatRefColors[0] = null;
                    this.mirrorColorAllocated &= -17;
                }
                this.vertexType &= -17;
                if (this.c4fAllocated == 0 && !var2_2 && (this.vertexType & 1008) == 32) {
                    this.mirrorUnsignedByteRefColors[0] = null;
                    this.mirrorColorAllocated &= -33;
                }
                this.vertexType &= -33;
                return;
            }
            if (this.floatBufferRefColors != null) {
                this.vertexType |= 16;
                this.vertexType &= -33;
                if (this.c4fAllocated == 0 && !var2_2) {
                    this.mirrorFloatRefColors[0] = null;
                    this.mirrorColorAllocated &= -17;
                } else {
                    if ((this.mirrorColorAllocated & 16) == 0) {
                        this.mirrorFloatRefColors[0] = new float[4 * this.vertexCount];
                        this.mirrorColorAllocated |= 16;
                    }
                    this.floatBufferRefColors.rewind();
                    if ((this.vertexFormat & 8) == 0) {
                        var4_3 = this.initialColorIndex * 3;
                        var5_4 = this.initialColorIndex * 4;
                        this.floatBufferRefColors.position(var4_3);
                        var3_14 = this.initialColorIndex;
                        while (var3_14 < this.validVertexCount) {
                            this.floatBufferRefColors.get(this.mirrorFloatRefColors[0], var5_4, 3);
                            this.mirrorFloatRefColors[0][var5_4 + 3] = 1.0f;
                            var5_4 += 4;
                            ++var3_14;
                        }
                    } else {
                        var4_3 = this.initialColorIndex * 4;
                        var5_4 = this.initialColorIndex * 4;
                        this.floatBufferRefColors.position(var4_3);
                        var3_15 = this.initialColorIndex;
                        while (var3_15 < this.validVertexCount) {
                            this.floatBufferRefColors.get(this.mirrorFloatRefColors[0], var5_4, 4);
                            var5_4 += 4;
                            ++var3_15;
                        }
                    }
                }
            } else if (this.byteBufferRefColors != null) {
                this.vertexType |= 32;
                this.vertexType &= -17;
                if (this.c4fAllocated == 0 && !var2_2) {
                    this.mirrorUnsignedByteRefColors[0] = null;
                    this.mirrorColorAllocated &= -33;
                } else {
                    if ((this.mirrorColorAllocated & 32) == 0) {
                        this.mirrorUnsignedByteRefColors[0] = new byte[4 * this.vertexCount];
                        this.mirrorColorAllocated |= 32;
                    }
                    this.byteBufferRefColors.rewind();
                    if ((this.vertexFormat & 8) == 0) {
                        var4_3 = this.initialColorIndex * 3;
                        var5_4 = this.initialColorIndex * 4;
                        this.byteBufferRefColors.position(var4_3);
                        var3_16 = this.initialColorIndex;
                        while (var3_16 < this.validVertexCount) {
                            this.byteBufferRefColors.get(this.mirrorUnsignedByteRefColors[0], var5_4, 3);
                            this.mirrorUnsignedByteRefColors[0][var5_4 + 3] = -1;
                            var5_4 += 4;
                            ++var3_16;
                        }
                    } else {
                        var4_3 = this.initialColorIndex * 4;
                        var5_4 = this.initialColorIndex * 4;
                        this.byteBufferRefColors.position(var4_3);
                        var3_17 = this.initialColorIndex;
                        while (var3_17 < this.validVertexCount) {
                            this.byteBufferRefColors.get(this.mirrorUnsignedByteRefColors[0], var5_4, 4);
                            var5_4 += 4;
                            ++var3_17;
                        }
                    }
                }
            }
        }
        this.colorChanged = 65535;
    }

    void setupMirrorNormalPointer(int n) {
        switch (n) {
            case 1024: {
                if (this.floatRefNormals == null) {
                    if ((this.vertexType & 0xC00) != 1024) break;
                    this.vertexType &= 0xFFFFFBFF;
                    this.mirrorFloatRefNormals = null;
                    this.mirrorNormalAllocated = false;
                    break;
                }
                this.vertexType |= 0x400;
                this.mirrorFloatRefNormals = this.floatRefNormals;
                this.mirrorNormalAllocated = false;
                break;
            }
            case 2048: {
                if (this.v3fRefNormals == null) {
                    if ((this.vertexType & 0xC00) == 2048) {
                        this.vertexType &= 0xFFFFF7FF;
                    }
                    return;
                }
                this.vertexType |= 0x800;
                if (!this.mirrorNormalAllocated) {
                    this.mirrorFloatRefNormals = new float[this.vertexCount * 3];
                    this.mirrorNormalAllocated = true;
                }
                int n2 = this.initialNormalIndex * 3;
                int n3 = this.initialNormalIndex;
                while (n3 < this.validVertexCount) {
                    this.mirrorFloatRefNormals[n2++] = this.v3fRefNormals[n3].x;
                    this.mirrorFloatRefNormals[n2++] = this.v3fRefNormals[n3].y;
                    this.mirrorFloatRefNormals[n2++] = this.v3fRefNormals[n3].z;
                    ++n3;
                }
                break;
            }
        }
    }

    void setupMirrorTexCoordPointer(int n) {
        int n2 = 0;
        while (n2 < this.texCoordSetCount) {
            this.setupMirrorTexCoordPointer(n2, n);
            ++n2;
        }
    }

    void setupMirrorTexCoordPointer(int n, int n2) {
        if (this.mirrorRefTexCoords == null) {
            this.mirrorRefTexCoords = new Object[this.texCoordSetCount];
        }
        switch (n2) {
            case 4096: {
                if (this.refTexCoords[n] == null) {
                    if ((this.vertexType & 0x7000) != 4096) break;
                    this.vertexType &= 0xFFFFEFFF;
                    this.mirrorRefTexCoords[n] = null;
                    this.mirrorTexCoordAllocated = false;
                    break;
                }
                this.vertexType |= 0x1000;
                this.mirrorRefTexCoords[n] = this.refTexCoords[n];
                this.mirrorTexCoordAllocated = false;
                break;
            }
            case 8192: {
                this.t2fRefTexCoords = (TexCoord2f[])this.refTexCoords[n];
                if (this.t2fRefTexCoords == null) {
                    if ((this.vertexType & 0x7000) == 8192) {
                        this.vertexType &= 0xFFFFDFFF;
                    }
                    return;
                }
                this.vertexType |= 0x2000;
                this.mirrorFloatRefTexCoords = (float[])this.mirrorRefTexCoords[n];
                if (this.mirrorFloatRefTexCoords != null) {
                    if (this.mirrorFloatRefTexCoords.length < this.vertexCount * 2) {
                        this.mirrorFloatRefTexCoords = new float[this.vertexCount * 2];
                        this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                    }
                } else {
                    this.mirrorFloatRefTexCoords = new float[this.vertexCount * 2];
                    this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                }
                int n3 = this.initialTexCoordIndex[n] * 2;
                int n4 = this.initialTexCoordIndex[n];
                while (n4 < this.validVertexCount) {
                    this.mirrorFloatRefTexCoords[n3++] = this.t2fRefTexCoords[n4].x;
                    this.mirrorFloatRefTexCoords[n3++] = this.t2fRefTexCoords[n4].y;
                    ++n4;
                }
                this.mirrorTexCoordAllocated = true;
                break;
            }
            case 16384: {
                this.t3fRefTexCoords = (TexCoord3f[])this.refTexCoords[n];
                if (this.t3fRefTexCoords == null) {
                    if ((this.vertexType & 0x7000) == 16384) {
                        this.vertexType &= 0xFFFFBFFF;
                    }
                    return;
                }
                this.vertexType |= 0x4000;
                this.mirrorFloatRefTexCoords = (float[])this.mirrorRefTexCoords[n];
                if (this.mirrorFloatRefTexCoords != null) {
                    if (this.mirrorFloatRefTexCoords.length < this.vertexCount * 3) {
                        this.mirrorFloatRefTexCoords = new float[this.vertexCount * 3];
                        this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                    }
                } else {
                    this.mirrorFloatRefTexCoords = new float[this.vertexCount * 3];
                    this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                }
                int n5 = this.initialTexCoordIndex[n] * 3;
                int n6 = this.initialTexCoordIndex[n];
                while (n6 < this.validVertexCount) {
                    this.mirrorFloatRefTexCoords[n5++] = this.t3fRefTexCoords[n6].x;
                    this.mirrorFloatRefTexCoords[n5++] = this.t3fRefTexCoords[n6].y;
                    this.mirrorFloatRefTexCoords[n5++] = this.t3fRefTexCoords[n6].z;
                    ++n6;
                }
                this.mirrorTexCoordAllocated = true;
                break;
            }
        }
    }

    void createGeometryArrayData(int n, int n2) {
        if ((n2 & 0x460) != 0) {
            this.createGeometryArrayData(n, n2, 1, defaultTexCoordSetMap);
        } else {
            this.createGeometryArrayData(n, n2, 0, null);
        }
    }

    void createGeometryArrayData(int n, int n2, int n3, int[] nArray) {
        this.vertexFormat = n2;
        this.vertexCount = n;
        this.validVertexCount = n;
        this.texCoordSetCount = n3;
        this.texCoordSetMap = nArray;
        this.stride = this.stride();
        this.texCoordSetMapOffset = this.texCoordSetMapOffset();
        this.textureOffset = 0;
        this.colorOffset = this.colorOffset();
        this.normalOffset = this.normalOffset();
        this.coordinateOffset = this.coordinateOffset();
        if ((n2 & 0x80) == 0) {
            this.vertexData = new float[this.vertexCount * this.stride];
        } else {
            this.vertexData = null;
            if ((n2 & 0x460) != 0) {
                this.refTexCoords = new Object[n3];
                if ((n2 & 0x800) != 0) {
                    this.refTexCoordsBuffer = new Object[n3];
                }
            }
        }
        if ((n2 & 0x460) != 0) {
            this.initialTexCoordIndex = new int[n3];
        }
        this.noAlpha = (n2 & 8) == 0;
        this.lastAlpha[0] = 1.0f;
    }

    native void execute(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8, int var9, int var10, int var11, int var12, int[] var13, int var14, int[] var15, int var16, int[] var17, float[] var18, float[] var19, int var20, int var21);

    native void executeVA(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11, float[] var12, double[] var13, int var14, float[] var15, byte[] var16, int var17, float[] var18, int var19, int var20, int[] var21, int var22, int[] var23, int[] var24, int var25, Object[] var26, int var27);

    native void executeVABuffer(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11, Object var12, int var13, Object var14, float[] var15, byte[] var16, int var17, Object var18, int var19, int var20, int[] var21, int var22, int[] var23, int[] var24, int var25, Object[] var26, int var27);

    native void executeInterleavedBuffer(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8, int var9, int var10, int var11, int var12, int[] var13, int var14, int[] var15, int var16, int[] var17, Object var18, float[] var19, int var20, int var21);

    native void setVertexFormat(int var1, boolean var2, boolean var3, long var4);

    native void disableGlobalAlpha(long var1, int var3, boolean var4, boolean var5);

    void setVertexFormat(boolean bl, boolean bl2, long l) {
        this.setVertexFormat(this.vertexFormat, bl, bl2, l);
    }

    void disableGlobalAlpha(long l, boolean bl, boolean bl2) {
        this.disableGlobalAlpha(l, this.vertexFormat, bl, bl2);
    }

    float[] updateAlphaInFloatRefColors(Canvas3D canvas3D, int n, float f) {
        int n2;
        Object object;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f);
            return this.mirrorFloatRefColors[0];
        }
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            return this.mirrorFloatRefColors[0];
        }
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        if (this.lastAlpha == null) {
            this.lastAlpha = new float[n + 1];
            this.lastAlpha[n] = 1.0f;
        } else if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            n2 = 0;
            while (n2 < this.lastAlpha.length) {
                object[n2] = this.lastAlpha[n2];
                ++n2;
            }
            this.lastAlpha = object;
            this.lastAlpha[n] = 1.0f;
        }
        if (this.mirrorFloatRefColors.length <= n) {
            object = new float[n + 1][];
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.mirrorFloatRefColors.length) {
                object[n4] = (float)this.mirrorFloatRefColors[n4];
                if ((double)Math.abs(this.lastAlpha[n4] - f) < 1.0E-6) {
                    n3 = n4;
                }
                ++n4;
            }
            float[] fArray = new float[4 * this.vertexCount];
            object[n] = (float)fArray;
            float[] fArray2 = fArray;
            if (n3 >= 0) {
                System.arraycopy(object[n3], 0, fArray2, 0, 4 * this.vertexCount);
                this.lastAlpha[n] = this.lastAlpha[n3];
            } else {
                float f2 = f / this.lastAlpha[0];
                float f3 = object[0];
                int n5 = this.initialColorIndex * 4;
                int n6 = this.initialColorIndex;
                while (n6 < this.validVertexCount) {
                    fArray2[n5] = f3[n5++];
                    fArray2[n5] = f3[n5++];
                    fArray2[n5] = f3[n5++];
                    fArray2[n5] = f3[n5++] * f2;
                    ++n6;
                }
                this.lastAlpha[n] = f;
            }
            this.mirrorFloatRefColors = (float[][])object;
            this.colorChanged &= ~(1 << n);
            this.dirtyFlag |= 4;
            return fArray2;
        }
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) < 1.0E-6) {
                return this.mirrorFloatRefColors[n];
            }
            float f4 = f / this.lastAlpha[n];
            float[] fArray = this.mirrorFloatRefColors[n];
            int n7 = 0;
            int n8 = 0;
            while (n7 < this.vertexCount) {
                fArray[n8 + 3] = fArray[n8 + 3] * f4;
                ++n7;
                n8 += 4;
            }
        } else if (n == 0) {
            object = this.mirrorFloatRefColors[n];
            n2 = this.initialColorIndex * 4;
            int n9 = this.initialColorIndex;
            while (n9 < this.validVertexCount) {
                object[n2 + 3] = object[n2 + 3] * f;
                ++n9;
                n2 += 4;
            }
        } else {
            float f5 = (this.colorChanged & 1) == 0 ? f / this.lastAlpha[0] : f;
            float[] fArray = this.mirrorFloatRefColors[0];
            float[] fArray3 = this.mirrorFloatRefColors[n];
            int n10 = this.initialColorIndex * 4;
            int n11 = this.initialColorIndex;
            while (n11 < this.validVertexCount) {
                fArray3[n10] = fArray[n10++];
                fArray3[n10] = fArray[n10++];
                fArray3[n10] = fArray[n10++];
                fArray3[n10] = fArray[n10++] * f5;
                ++n11;
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.dirtyFlag |= 4;
        return this.mirrorFloatRefColors[n];
    }

    byte[] updateAlphaInByteRefColors(Canvas3D canvas3D, int n, float f) {
        int n2;
        Object object;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f);
            return this.mirrorUnsignedByteRefColors[0];
        }
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            return this.mirrorUnsignedByteRefColors[0];
        }
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        if (this.lastAlpha == null) {
            this.lastAlpha = new float[n + 1];
            this.lastAlpha[n] = -1.0f;
        } else if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            n2 = 0;
            while (n2 < this.lastAlpha.length) {
                object[n2] = this.lastAlpha[n2];
                ++n2;
            }
            this.lastAlpha = object;
            this.lastAlpha[n] = -1.0f;
        }
        if (this.mirrorUnsignedByteRefColors.length <= n) {
            object = new byte[n + 1][];
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.mirrorUnsignedByteRefColors.length) {
                object[n4] = (float)this.mirrorUnsignedByteRefColors[n4];
                if ((double)Math.abs(this.lastAlpha[n4] - f) < 1.0E-6) {
                    n3 = n4;
                }
                ++n4;
            }
            byte[] byArray = new byte[4 * this.vertexCount];
            object[n] = (float)byArray;
            byte[] byArray2 = byArray;
            if (n3 >= 0) {
                System.arraycopy(object[n3], 0, byArray2, 0, 4 * this.vertexCount);
                this.lastAlpha[n] = this.lastAlpha[n3];
            } else {
                float f2 = f / this.lastAlpha[0];
                float f3 = object[0];
                int n5 = this.initialColorIndex * 4;
                int n6 = this.initialColorIndex;
                while (n6 < this.validVertexCount) {
                    byArray2[n5] = f3[n5++];
                    byArray2[n5] = f3[n5++];
                    byArray2[n5] = f3[n5++];
                    byArray2[n5] = (byte)((float)(f3[n5++] & 0xFF) * f2);
                    ++n6;
                }
                this.lastAlpha[n] = f;
            }
            this.mirrorUnsignedByteRefColors = (byte[][])object;
            this.colorChanged &= ~(1 << n);
            this.dirtyFlag |= 4;
            return byArray2;
        }
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) < 1.0E-6) {
                return this.mirrorUnsignedByteRefColors[n];
            }
            float f4 = f / this.lastAlpha[n];
            byte[] byArray = this.mirrorUnsignedByteRefColors[n];
            int n7 = 0;
            int n8 = 0;
            while (n7 < this.vertexCount) {
                byArray[n8 + 3] = (byte)((float)(byArray[n8 + 3] & 0xFF) * f4);
                ++n7;
                n8 += 4;
            }
        } else if (n == 0) {
            object = this.mirrorUnsignedByteRefColors[n];
            n2 = this.initialColorIndex * 4;
            int n9 = this.initialColorIndex;
            while (n9 < this.validVertexCount) {
                object[n2 + 3] = (byte)((float)(object[n2 + 3] & 0xFF) * f);
                ++n9;
                n2 += 4;
            }
        } else {
            float f5 = (this.colorChanged & 1) == 0 ? f / this.lastAlpha[0] : f;
            byte[] byArray = this.mirrorUnsignedByteRefColors[0];
            byte[] byArray3 = this.mirrorUnsignedByteRefColors[n];
            int n10 = this.initialColorIndex * 4;
            int n11 = this.initialColorIndex;
            while (n11 < this.validVertexCount) {
                byArray3[n10] = byArray[n10++];
                byArray3[n10] = byArray[n10++];
                byArray3[n10] = byArray[n10++];
                byArray3[n10] = (byte)((float)(byArray[n10++] & 0xFF) * f5);
                ++n11;
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.dirtyFlag |= 4;
        return this.mirrorUnsignedByteRefColors[n];
    }

    Object[] updateAlphaInVertexData(Canvas3D canvas3D, int n, float f) {
        Object object;
        Object[] objectArray = new Object[2];
        objectArray[0] = Boolean.FALSE;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f);
            objectArray[1] = this.vertexData;
            return objectArray;
        }
        if ((this.vertexFormat & 4) == 0) {
            objectArray[1] = this.vertexData;
            return objectArray;
        }
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        objectArray[0] = Boolean.TRUE;
        if (this.lastAlpha == null) {
            this.lastAlpha = new float[n + 1];
            this.lastAlpha[n] = 1.0f;
        } else if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            int n2 = 0;
            while (n2 < this.lastAlpha.length) {
                object[n2] = this.lastAlpha[n2];
                ++n2;
            }
            this.lastAlpha = object;
            this.lastAlpha[n] = 1.0f;
        }
        if (this.mvertexData == null || this.mvertexData.length <= n) {
            object = new float[n + 1][];
            int n3 = -1;
            if (this.mvertexData != null) {
                int n4 = 0;
                while (n4 < this.mvertexData.length) {
                    object[n4] = (float)this.mvertexData[n4];
                    if ((double)Math.abs(this.lastAlpha[n4] - f) < 1.0E-6) {
                        n3 = n4;
                    }
                    ++n4;
                }
            }
            if (object[0] == null) {
                object[n] = (float)this.vertexData;
            }
            if (n > 0) {
                object[n] = (float)new float[this.stride * this.vertexCount];
            }
            float f2 = object[n];
            if (n3 >= 0) {
                System.arraycopy(object[n3], 0, f2, 0, this.stride * this.vertexCount);
                this.lastAlpha[n] = this.lastAlpha[n3];
            } else {
                float f3 = f / this.lastAlpha[0];
                float f4 = object[0];
                int n5 = 0;
                int n6 = this.colorOffset;
                while (n5 < this.vertexCount) {
                    f2[n6 + 3] = f4[n6 + 3] * f3;
                    ++n5;
                    n6 += this.stride;
                }
                this.lastAlpha[n] = f;
            }
            this.mvertexData = (float[][])object;
            this.dirtyFlag |= 4;
            this.colorChanged &= ~(1 << n);
            objectArray[1] = f2;
            return objectArray;
        }
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) < 1.0E-6) {
                objectArray[1] = this.mvertexData[n];
                return objectArray;
            }
            float f5 = f / this.lastAlpha[n];
            float[] fArray = this.mvertexData[n];
            int n7 = 0;
            int n8 = this.colorOffset;
            while (n7 < this.vertexCount) {
                int n9 = n8 + 3;
                fArray[n9] = fArray[n9] * f5;
                ++n7;
                n8 += this.stride;
            }
        } else if (n == 0) {
            object = this.mvertexData[n];
            double d = f / this.lastAlpha[0];
            int n10 = 0;
            int n11 = this.colorOffset;
            while (n10 < this.vertexCount) {
                int n12 = n11 + 3;
                object[n12] = (float)((double)object[n12] * d);
                ++n10;
                n11 += this.stride;
            }
        } else {
            float f6 = f / this.lastAlpha[0];
            float[] fArray = this.mvertexData[0];
            float[] fArray2 = this.mvertexData[n];
            int n13 = 0;
            int n14 = this.colorOffset;
            while (n13 < this.vertexCount) {
                System.arraycopy(fArray, n14, fArray2, n14, 3);
                fArray2[n14 + 3] = fArray[n14 + 3] * f6;
                ++n13;
                n14 += this.stride;
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.dirtyFlag |= 4;
        objectArray[1] = this.mvertexData[n];
        return objectArray;
    }

    Object[] updateAlphaInInterLeavedData(Canvas3D canvas3D, int n, float f) {
        int n2;
        Object object;
        Object[] objectArray = new Object[2];
        objectArray[0] = Boolean.FALSE;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f);
            objectArray[1] = null;
            return objectArray;
        }
        if (((this.vertexFormat | this.c4fAllocated) & 4) == 0) {
            objectArray[1] = this.mirrorInterleavedColorPointer[0];
            return objectArray;
        }
        int n3 = this.initialColorIndex << 2;
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        objectArray[0] = Boolean.TRUE;
        if (this.lastAlpha == null) {
            this.lastAlpha = new float[n + 1];
            this.lastAlpha[n] = 1.0f;
        } else if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            n2 = 0;
            while (n2 < this.lastAlpha.length) {
                object[n2] = this.lastAlpha[n2];
                ++n2;
            }
            this.lastAlpha = object;
            this.lastAlpha[n] = 1.0f;
        }
        if (this.mirrorInterleavedColorPointer.length <= n) {
            object = new float[n + 1][];
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.mirrorInterleavedColorPointer.length) {
                object[n5] = (float)this.mirrorInterleavedColorPointer[n5];
                if ((double)Math.abs(this.lastAlpha[n5] - f) < 1.0E-6) {
                    n4 = n5;
                }
                ++n5;
            }
            float[] fArray = new float[4 * this.vertexCount];
            object[n] = (float)fArray;
            float[] fArray2 = fArray;
            if (n4 >= 0) {
                System.arraycopy(object[n4], 0, fArray2, 0, 4 * this.vertexCount);
                this.lastAlpha[n] = this.lastAlpha[n4];
            } else {
                float f2 = f / this.lastAlpha[0];
                float f3 = object[0];
                int n6 = n3;
                while (n6 < n3 + (this.vertexCount << 2)) {
                    fArray2[n6 + 3] = f3[n6 + 3] * f2;
                    n6 += 4;
                }
                this.lastAlpha[n] = f;
            }
            this.mirrorInterleavedColorPointer = (float[][])object;
            this.colorChanged &= ~(1 << n);
            this.dirtyFlag |= 4;
            objectArray[1] = fArray2;
            return objectArray;
        }
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) < 1.0E-6) {
                objectArray[1] = this.mirrorInterleavedColorPointer[n];
                return objectArray;
            }
            float f4 = f / this.lastAlpha[n];
            float[] fArray = this.mirrorInterleavedColorPointer[n];
            int n7 = n3 = this.initialColorIndex << 2;
            while (n7 < n3 + (this.vertexCount << 2)) {
                fArray[n7 + 3] = fArray[n7 + 3] * f4;
                n7 += 4;
            }
        } else if (n == 0) {
            object = this.mirrorInterleavedColorPointer[n];
            n2 = n3;
            while (n2 < n3 + (this.vertexCount << 2)) {
                object[n2 + 3] = object[n2 + 3] * f;
                n2 += 4;
            }
        } else {
            float f5 = (this.colorChanged & 1) == 0 ? f / this.lastAlpha[0] : f;
            float[] fArray = this.mirrorInterleavedColorPointer[0];
            float[] fArray3 = this.mirrorInterleavedColorPointer[n];
            int n8 = n3;
            while (n8 < n3 + (this.vertexCount << 2)) {
                fArray3[n8] = fArray[n8++];
                fArray3[n8] = fArray[n8++];
                fArray3[n8] = fArray[n8++];
                fArray3[n8] = fArray[n8++] * f5;
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.dirtyFlag |= 4;
        objectArray[1] = this.mirrorInterleavedColorPointer[n];
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, int n, boolean bl4, int n2) {
        boolean bl5 = false;
        if ((this.vertexFormat & 0x80) == 0) {
            float[] fArray;
            int n3;
            GeometryArrayRetained geometryArrayRetained = this;
            synchronized (geometryArrayRetained) {
                n3 = this.dirtyFlag;
                if (bl2 && !bl4) {
                    Object[] objectArray = this.updateAlphaInVertexData(canvas3D, n, f);
                    bl5 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f;
                        n3 |= 4;
                    }
                } else {
                    fArray = this.vertexData;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n3 |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            this.execute(canvas3D.ctx, this, this.geoType, bl, bl5, bl3, bl4, this.initialVertexIndex, this.validVertexCount, (this.vertexFormat & 4) != 0 ? this.vertexFormat | 0xC : this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, canvas3D.texUnitStateMap, fArray, null, n2, n3);
        } else if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                int n4;
                if (this.interLeavedVertexData == null) {
                    return;
                }
                float[] fArray = null;
                GeometryArrayRetained geometryArrayRetained = this;
                synchronized (geometryArrayRetained) {
                    n4 = this.dirtyFlag;
                    if (bl2 && !bl4) {
                        Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n, f);
                        bl5 = objectArray[0] == Boolean.TRUE;
                        fArray = (float[])objectArray[1];
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n4 |= 4;
                        }
                    } else if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n4 |= 4;
                    }
                    this.dirtyFlag = 0;
                }
                this.execute(canvas3D.ctx, this, this.geoType, bl, bl5, bl3, bl4, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, canvas3D.texUnitStateMap, this.interLeavedVertexData, fArray, n2, n4);
            } else {
                int n5;
                GeometryArrayRetained geometryArrayRetained;
                if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                    return;
                }
                byte[] byArray = null;
                float[] fArray = null;
                if ((this.vertexType & 0xD0) != 0) {
                    geometryArrayRetained = this;
                    synchronized (geometryArrayRetained) {
                        n5 = this.dirtyFlag;
                        if (bl2 && !bl4) {
                            fArray = this.updateAlphaInFloatRefColors(canvas3D, n, f);
                            if (f != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f;
                                n5 |= 4;
                            }
                        } else {
                            fArray = this.mirrorFloatRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n5 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else if ((this.vertexType & 0x320) != 0) {
                    geometryArrayRetained = this;
                    synchronized (geometryArrayRetained) {
                        n5 = this.dirtyFlag;
                        if (bl2 && !bl4) {
                            byArray = this.updateAlphaInByteRefColors(canvas3D, n, f);
                            if (f != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f;
                                n5 |= 4;
                            }
                        } else {
                            byArray = this.mirrorUnsignedByteRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n5 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else {
                    n5 = this.dirtyFlag;
                }
                int n6 = 0;
                if ((this.vertexType & 5) != 0) {
                    n6 |= 1;
                }
                if ((this.vertexType & 0xA) != 0) {
                    n6 |= 2;
                }
                if ((this.vertexType & 0xD0) != 0) {
                    n6 |= 4;
                }
                if ((this.vertexType & 0x320) != 0) {
                    n6 |= 8;
                }
                if ((this.vertexType & 0xC00) != 0) {
                    n6 |= 0x10;
                }
                if ((this.vertexType & 0x7000) != 0) {
                    n6 |= 0x20;
                }
                this.executeVA(canvas3D.ctx, this, this.geoType, bl, bl3, bl4, this.validVertexCount, this.vertexFormat | this.c4fAllocated, n6, this.initialCoordIndex, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, this.initialColorIndex, fArray, byArray, this.initialNormalIndex, this.mirrorFloatRefNormals, n2, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, canvas3D.texUnitStateMap, this.initialTexCoordIndex, this.texCoordStride, this.mirrorRefTexCoords, n5);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int n7;
            if (this.interleavedFloatBufferImpl == null) {
                return;
            }
            float[] fArray = null;
            GeometryArrayRetained geometryArrayRetained = this;
            synchronized (geometryArrayRetained) {
                n7 = this.dirtyFlag;
                if (bl2 && !bl4) {
                    Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n, f);
                    bl5 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f;
                        n7 |= 4;
                    }
                } else {
                    fArray = null;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n7 |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            this.executeInterleavedBuffer(canvas3D.ctx, this, this.geoType, bl, bl5, bl3, bl4, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, canvas3D.texUnitStateMap, this.interleavedFloatBufferImpl.getBufferAsObject(), fArray, n2, n7);
        } else {
            int n8;
            Object object;
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            byte[] byArray = null;
            float[] fArray = null;
            if ((this.vertexType & 0x10) != 0) {
                object = this;
                synchronized (object) {
                    n8 = this.dirtyFlag;
                    if (bl2 && !bl4) {
                        fArray = this.updateAlphaInFloatRefColors(canvas3D, n, f);
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n8 |= 4;
                        }
                    } else {
                        fArray = this.mirrorFloatRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n8 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else if ((this.vertexType & 0x20) != 0) {
                object = this;
                synchronized (object) {
                    n8 = this.dirtyFlag;
                    if (bl2 && !bl4) {
                        byArray = this.updateAlphaInByteRefColors(canvas3D, n, f);
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n8 |= 4;
                        }
                    } else {
                        byArray = this.mirrorUnsignedByteRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n8 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else {
                n8 = this.dirtyFlag;
            }
            object = null;
            Object object2 = null;
            Object object3 = null;
            int n9 = 0;
            if ((this.vertexType & 1) != 0) {
                n9 |= 1;
                object = this.floatBufferRefCoords.getBufferAsObject();
            } else if ((this.vertexType & 2) != 0) {
                n9 |= 2;
                object = this.doubleBufferRefCoords.getBufferAsObject();
            }
            if ((this.vertexType & 0x10) != 0) {
                n9 |= 4;
                object2 = this.floatBufferRefColors.getBufferAsObject();
            } else if ((this.vertexType & 0x20) != 0) {
                n9 |= 8;
                object2 = this.byteBufferRefColors.getBufferAsObject();
            }
            if ((this.vertexType & 0xC00) != 0) {
                n9 |= 0x10;
                object3 = this.floatBufferRefNormals.getBufferAsObject();
            }
            if ((this.vertexType & 0x7000) != 0) {
                n9 |= 0x20;
            }
            this.executeVABuffer(canvas3D.ctx, this, this.geoType, bl, bl3, bl4, this.validVertexCount, this.vertexFormat | this.c4fAllocated, n9, this.initialCoordIndex, object, this.initialColorIndex, object2, fArray, byArray, this.initialNormalIndex, object3, n2, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, canvas3D.texUnitStateMap, this.initialTexCoordIndex, this.texCoordStride, this.refTexCoords, n8);
        }
    }

    native void buildGA(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, float var7, boolean var8, int var9, int var10, int var11, int var12, int[] var13, int var14, int[] var15, double[] var16, double[] var17, float[] var18);

    native void buildGAForByRef(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, float var7, boolean var8, int var9, int var10, int var11, int var12, float[] var13, double[] var14, int var15, float[] var16, byte[] var17, int var18, float[] var19, int var20, int[] var21, int[] var22, int var23, Object[] var24, double[] var25, double[] var26);

    native void buildGAForBuffer(long var1, GeometryArrayRetained var3, int var4, boolean var5, boolean var6, float var7, boolean var8, int var9, int var10, int var11, int var12, Object var13, int var14, Object var15, int var16, Object var17, int var18, int[] var19, int[] var20, int var21, Object[] var22, double[] var23, double[] var24);

    void buildGA(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, Transform3D transform3D, Transform3D transform3D2) {
        float[] fArray = null;
        if ((this.vertexFormat & 0x80) == 0) {
            fArray = this.vertexData;
        } else if ((this.vertexFormat & 0x100) != 0 && (this.vertexFormat & 0x800) == 0) {
            fArray = this.interLeavedVertexData;
        }
        if (fArray != null) {
            this.buildGA(canvas3D.ctx, this, this.geoType, bl, bl2, f, bl3, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, transform3D == null ? null : transform3D.mat, transform3D2 == null ? null : transform3D2.mat, fArray);
        } else if ((this.vertexFormat & 0x800) == 0) {
            int n = 0;
            if ((this.vertexType & 5) != 0) {
                n |= 1;
            }
            if ((this.vertexType & 0xA) != 0) {
                n |= 2;
            }
            if ((this.vertexType & 0xD0) != 0) {
                n |= 4;
            }
            if ((this.vertexType & 0x320) != 0) {
                n |= 8;
            }
            if ((this.vertexType & 0xC00) != 0) {
                n |= 0x10;
            }
            if ((this.vertexType & 0x7000) != 0) {
                n |= 0x20;
            }
            this.buildGAForByRef(canvas3D.ctx, this, this.geoType, bl, bl2, f, bl3, this.validVertexCount, this.vertexFormat, n, this.initialCoordIndex, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, this.initialColorIndex, this.mirrorFloatRefColors[0], this.mirrorUnsignedByteRefColors[0], this.initialNormalIndex, this.mirrorFloatRefNormals, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, this.initialTexCoordIndex, this.texCoordStride, this.mirrorRefTexCoords, transform3D == null ? null : transform3D.mat, transform3D2 == null ? null : transform3D2.mat);
        } else {
            Object object = null;
            Object object2 = null;
            Object object3 = null;
            int n = 0;
            if ((this.vertexType & 1) != 0) {
                n |= 1;
                object = this.floatBufferRefCoords.getBufferAsObject();
            } else if ((this.vertexType & 2) != 0) {
                n |= 2;
                object = this.doubleBufferRefCoords.getBufferAsObject();
            }
            if ((this.vertexType & 0x10) != 0) {
                n |= 4;
                object2 = this.floatBufferRefColors.getBufferAsObject();
            } else if ((this.vertexType & 0x20) != 0) {
                n |= 8;
                object2 = this.byteBufferRefColors.getBufferAsObject();
            }
            if ((this.vertexType & 0xC00) != 0) {
                n |= 0x10;
                object3 = this.floatBufferRefNormals.getBufferAsObject();
            }
            if ((this.vertexType & 0x7000) != 0) {
                n |= 0x20;
            }
            this.buildGAForBuffer(canvas3D.ctx, this, this.geoType, bl, bl2, f, bl3, this.validVertexCount, this.vertexFormat, n, this.initialCoordIndex, object, this.initialColorIndex, object2, this.initialNormalIndex, object3, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, this.initialTexCoordIndex, this.texCoordStride, this.refTexCoords, transform3D == null ? null : transform3D.mat, transform3D2 == null ? null : transform3D2.mat);
        }
    }

    void unIndexify(IndexedGeometryArrayRetained indexedGeometryArrayRetained) {
        if ((indexedGeometryArrayRetained.vertexFormat & 0x800) == 0) {
            this.unIndexifyJavaArray(indexedGeometryArrayRetained);
        } else {
            this.unIndexifyNIOBuffer(indexedGeometryArrayRetained);
        }
    }

    void unIndexifyJavaArray(IndexedGeometryArrayRetained indexedGeometryArrayRetained) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float[] fArray = null;
        int n4 = indexedGeometryArrayRetained.initialIndexIndex;
        int n5 = indexedGeometryArrayRetained.initialIndexIndex + indexedGeometryArrayRetained.validIndexCount;
        if ((indexedGeometryArrayRetained.vertexFormat & 0x80) == 0 || (indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryArrayRetained.vertexFormat & 0x80) == 0) {
                fArray = indexedGeometryArrayRetained.vertexData;
                if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
                    n3 = 4;
                }
            } else if ((indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
                fArray = indexedGeometryArrayRetained.interLeavedVertexData;
                if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                    n3 = 4;
                } else if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
                    n3 = 3;
                }
            }
            int n6 = n4;
            while (n6 < n5) {
                if ((this.vertexFormat & 2) != 0) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexNormal[n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.normalOffset, this.vertexData, n + this.normalOffset, 3);
                }
                if (n3 == 4) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexColor[n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n3);
                } else if (n3 == 3) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexColor[n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n3);
                    this.vertexData[n + this.colorOffset + 3] = 1.0f;
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    int n7 = n + this.textureOffset;
                    int n8 = 0;
                    int n9 = 0;
                    while (n9 < this.texCoordSetCount) {
                        if ((indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
                            n8 = n9 * this.texCoordStride;
                        }
                        System.arraycopy(fArray, ((int[])indexedGeometryArrayRetained.indexTexCoord[n9])[n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.textureOffset + n8, this.vertexData, n7, this.texCoordStride);
                        ++n9;
                        n7 += this.texCoordStride;
                    }
                }
                if ((this.vertexFormat & 1) != 0) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexCoord[n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.coordinateOffset, this.vertexData, n + this.coordinateOffset, 3);
                }
                n += this.stride;
                ++n6;
            }
        } else {
            int n10;
            int n11;
            if ((this.vertexFormat & 2) != 0) {
                n = this.normalOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0xC00) {
                    case 1024: {
                        n11 = n4;
                        while (n11 < n5) {
                            System.arraycopy(indexedGeometryArrayRetained.floatRefNormals, indexedGeometryArrayRetained.indexNormal[n11] * 3, this.vertexData, n, 3);
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                    case 2048: {
                        n11 = n4;
                        while (n11 < n5) {
                            n10 = indexedGeometryArrayRetained.indexNormal[n11];
                            this.vertexData[n] = indexedGeometryArrayRetained.v3fRefNormals[n10].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.v3fRefNormals[n10].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.v3fRefNormals[n10].z;
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n = this.colorOffset;
                int n12 = 3;
                if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                    n12 = 4;
                }
                switch (indexedGeometryArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        n11 = n4;
                        while (n11 < n5) {
                            if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                                System.arraycopy(indexedGeometryArrayRetained.floatRefColors, indexedGeometryArrayRetained.indexColor[n11] * n12, this.vertexData, n, 4);
                            } else {
                                System.arraycopy(indexedGeometryArrayRetained.floatRefColors, indexedGeometryArrayRetained.indexColor[n11] * n12, this.vertexData, n, 3);
                                this.vertexData[n + 3] = 1.0f;
                            }
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                    case 32: {
                        n11 = n4;
                        while (n11 < n5) {
                            n10 = indexedGeometryArrayRetained.indexColor[n11] * n12;
                            this.vertexData[n] = (float)(indexedGeometryArrayRetained.byteRefColors[n10] & 0xFF) * 0.003921569f;
                            this.vertexData[n + 1] = (float)(indexedGeometryArrayRetained.byteRefColors[n10 + 1] & 0xFF) * 0.003921569f;
                            this.vertexData[n + 2] = (float)(indexedGeometryArrayRetained.byteRefColors[n10 + 2] & 0xFF) * 0.003921569f;
                            this.vertexData[n + 3] = (indexedGeometryArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryArrayRetained.byteRefColors[n10 + 3] & 0xFF) * 0.003921569f : 1.0f;
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                    case 64: {
                        n11 = n4;
                        while (n11 < n5) {
                            n10 = indexedGeometryArrayRetained.indexColor[n11];
                            this.vertexData[n] = indexedGeometryArrayRetained.c3fRefColors[n10].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.c3fRefColors[n10].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.c3fRefColors[n10].z;
                            this.vertexData[n + 3] = 1.0f;
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                    case 128: {
                        n11 = n4;
                        while (n11 < n5) {
                            n10 = indexedGeometryArrayRetained.indexColor[n11];
                            this.vertexData[n] = indexedGeometryArrayRetained.c4fRefColors[n10].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.c4fRefColors[n10].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.c4fRefColors[n10].z;
                            this.vertexData[n + 3] = indexedGeometryArrayRetained.c4fRefColors[n10].w;
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                    case 256: {
                        n11 = n4;
                        while (n11 < n5) {
                            n10 = indexedGeometryArrayRetained.indexColor[n11];
                            this.vertexData[n] = (float)(indexedGeometryArrayRetained.c3bRefColors[n10].x & 0xFF) * 0.003921569f;
                            this.vertexData[n + 1] = (float)(indexedGeometryArrayRetained.c3bRefColors[n10].y & 0xFF) * 0.003921569f;
                            this.vertexData[n + 2] = (float)(indexedGeometryArrayRetained.c3bRefColors[n10].z & 0xFF) * 0.003921569f;
                            this.vertexData[n + 3] = 1.0f;
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                    case 512: {
                        n11 = n4;
                        while (n11 < n5) {
                            n10 = indexedGeometryArrayRetained.indexColor[n11];
                            this.vertexData[n] = (float)(indexedGeometryArrayRetained.c4bRefColors[n10].x & 0xFF) * 0.003921569f;
                            this.vertexData[n + 1] = (float)(indexedGeometryArrayRetained.c4bRefColors[n10].y & 0xFF) * 0.003921569f;
                            this.vertexData[n + 2] = (float)(indexedGeometryArrayRetained.c4bRefColors[n10].z & 0xFF) * 0.003921569f;
                            this.vertexData[n + 3] = (float)(indexedGeometryArrayRetained.c4bRefColors[n10].w & 0xFF) * 0.003921569f;
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n = this.textureOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0x7000) {
                    case 4096: {
                        int n13;
                        n11 = n4;
                        while (n11 < n5) {
                            n13 = 0;
                            n2 = n;
                            while (n13 < this.texCoordSetCount) {
                                System.arraycopy(indexedGeometryArrayRetained.refTexCoords[n13], ((int[])indexedGeometryArrayRetained.indexTexCoord[n13])[n11] * this.texCoordStride, this.vertexData, n2, this.texCoordStride);
                                n2 += this.texCoordStride;
                                ++n13;
                            }
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                    case 8192: {
                        int n13;
                        n11 = n4;
                        while (n11 < n5) {
                            n13 = 0;
                            n2 = n;
                            while (n13 < this.texCoordSetCount) {
                                n10 = ((int[])indexedGeometryArrayRetained.indexTexCoord[n13])[n11];
                                this.vertexData[n2] = ((TexCoord2f[])indexedGeometryArrayRetained.refTexCoords[n13])[n10].x;
                                this.vertexData[n2 + 1] = ((TexCoord2f[])indexedGeometryArrayRetained.refTexCoords[n13])[n10].y;
                                n2 += this.texCoordStride;
                                ++n13;
                            }
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                    case 16384: {
                        int n13;
                        n11 = n4;
                        while (n11 < n5) {
                            n13 = 0;
                            n2 = n;
                            while (n13 < this.texCoordSetCount) {
                                n10 = ((int[])indexedGeometryArrayRetained.indexTexCoord[n13])[n11];
                                this.vertexData[n2] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n13])[n10].x;
                                this.vertexData[n2 + 1] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n13])[n10].y;
                                this.vertexData[n2 + 2] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n13])[n10].z;
                                n2 += this.texCoordStride;
                                ++n13;
                            }
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n = this.coordinateOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0xF) {
                    case 1: {
                        n11 = n4;
                        while (n11 < n5) {
                            System.arraycopy(indexedGeometryArrayRetained.floatRefCoords, indexedGeometryArrayRetained.indexCoord[n11] * 3, this.vertexData, n, 3);
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                    case 2: {
                        n11 = n4;
                        while (n11 < n5) {
                            n10 = indexedGeometryArrayRetained.indexCoord[n11] * 3;
                            this.vertexData[n] = (float)indexedGeometryArrayRetained.doubleRefCoords[n10];
                            this.vertexData[n + 1] = (float)indexedGeometryArrayRetained.doubleRefCoords[n10 + 1];
                            this.vertexData[n + 2] = (float)indexedGeometryArrayRetained.doubleRefCoords[n10 + 2];
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                    case 4: {
                        n11 = n4;
                        while (n11 < n5) {
                            n10 = indexedGeometryArrayRetained.indexCoord[n11];
                            this.vertexData[n] = indexedGeometryArrayRetained.p3fRefCoords[n10].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.p3fRefCoords[n10].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.p3fRefCoords[n10].z;
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                    case 8: {
                        n11 = n4;
                        while (n11 < n5) {
                            n10 = indexedGeometryArrayRetained.indexCoord[n11];
                            this.vertexData[n] = (float)indexedGeometryArrayRetained.p3dRefCoords[n10].x;
                            this.vertexData[n + 1] = (float)indexedGeometryArrayRetained.p3dRefCoords[n10].y;
                            this.vertexData[n + 2] = (float)indexedGeometryArrayRetained.p3dRefCoords[n10].z;
                            n += this.stride;
                            ++n11;
                        }
                        break;
                    }
                }
            }
        }
    }

    void unIndexifyNIOBuffer(IndexedGeometryArrayRetained indexedGeometryArrayRetained) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Object var7_5 = null;
        int n4 = indexedGeometryArrayRetained.initialIndexIndex;
        int n5 = indexedGeometryArrayRetained.initialIndexIndex + indexedGeometryArrayRetained.validIndexCount;
        if ((indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                n3 = 4;
            } else if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
                n3 = 3;
            }
            int n6 = n4;
            while (n6 < n5) {
                if ((this.vertexFormat & 2) != 0) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexNormal[n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.normalOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.normalOffset, 3);
                }
                if (n3 == 4) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexColor[n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.colorOffset, n3);
                } else if (n3 == 3) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexColor[n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.colorOffset, n3);
                    this.vertexData[n + this.colorOffset + 3] = 1.0f;
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    int n7 = n + this.textureOffset;
                    int n8 = 0;
                    while (n8 < this.texCoordSetCount) {
                        indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(((int[])indexedGeometryArrayRetained.indexTexCoord[n8])[n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.textureOffset);
                        indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n7, this.texCoordStride);
                        ++n8;
                        n7 += this.texCoordStride;
                    }
                }
                if ((this.vertexFormat & 1) != 0) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexCoord[n6] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.coordinateOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.coordinateOffset, 3);
                }
                n += this.stride;
                ++n6;
            }
        } else {
            int n9;
            int n10;
            if ((this.vertexFormat & 2) != 0) {
                n = this.normalOffset;
                if ((indexedGeometryArrayRetained.vertexType & 0xC00) != 0) {
                    n10 = n4;
                    while (n10 < n5) {
                        indexedGeometryArrayRetained.floatBufferRefNormals.position(indexedGeometryArrayRetained.indexNormal[n10] * 3);
                        indexedGeometryArrayRetained.floatBufferRefNormals.get(this.vertexData, n, 3);
                        n += this.stride;
                        ++n10;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n = this.colorOffset;
                int n11 = 3;
                if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                    n11 = 4;
                }
                switch (indexedGeometryArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        n10 = n4;
                        while (n10 < n5) {
                            if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                                indexedGeometryArrayRetained.floatBufferRefColors.position(indexedGeometryArrayRetained.indexColor[n10] * n11);
                                indexedGeometryArrayRetained.floatBufferRefColors.get(this.vertexData, n, 4);
                            } else {
                                indexedGeometryArrayRetained.floatBufferRefColors.position(indexedGeometryArrayRetained.indexColor[n10] * n11);
                                indexedGeometryArrayRetained.floatBufferRefColors.get(this.vertexData, n, 3);
                                this.vertexData[n + 3] = 1.0f;
                            }
                            n += this.stride;
                            ++n10;
                        }
                        break;
                    }
                    case 32: {
                        n10 = n4;
                        while (n10 < n5) {
                            n9 = indexedGeometryArrayRetained.indexColor[n10] * n11;
                            this.vertexData[n] = (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n9) & 0xFF) * 0.003921569f;
                            this.vertexData[n + 1] = (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n9 + 1) & 0xFF) * 0.003921569f;
                            this.vertexData[n + 2] = (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n9 + 2) & 0xFF) * 0.003921569f;
                            this.vertexData[n + 3] = (indexedGeometryArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n9 + 3) & 0xFF) * 0.003921569f : 1.0f;
                            n += this.stride;
                            ++n10;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n = this.textureOffset;
                if ((indexedGeometryArrayRetained.vertexType & 0x7000) != 0) {
                    n10 = n4;
                    while (n10 < n5) {
                        int n12 = 0;
                        n2 = n;
                        while (n12 < this.texCoordSetCount) {
                            FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)indexedGeometryArrayRetained.refTexCoordsBuffer[n12]).getBufferImpl();
                            floatBufferWrapper.position(((int[])indexedGeometryArrayRetained.indexTexCoord[n12])[n10] * this.texCoordStride);
                            floatBufferWrapper.get(this.vertexData, n2, this.texCoordStride);
                            n2 += this.texCoordStride;
                            ++n12;
                        }
                        n += this.stride;
                        ++n10;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n = this.coordinateOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0xF) {
                    case 1: {
                        n10 = n4;
                        while (n10 < n5) {
                            indexedGeometryArrayRetained.floatBufferRefCoords.position(indexedGeometryArrayRetained.indexCoord[n10] * 3);
                            indexedGeometryArrayRetained.floatBufferRefCoords.get(this.vertexData, n, 3);
                            n += this.stride;
                            ++n10;
                        }
                        break;
                    }
                    case 2: {
                        n10 = n4;
                        while (n10 < n5) {
                            n9 = indexedGeometryArrayRetained.indexCoord[n10] * 3;
                            this.vertexData[n] = (float)indexedGeometryArrayRetained.doubleBufferRefCoords.get(n9);
                            this.vertexData[n + 1] = (float)indexedGeometryArrayRetained.doubleBufferRefCoords.get(n9 + 1);
                            this.vertexData[n + 2] = (float)indexedGeometryArrayRetained.doubleBufferRefCoords.get(n9 + 2);
                            n += this.stride;
                            ++n10;
                        }
                        break;
                    }
                }
            }
        }
    }

    int stride() {
        int n = 0;
        if ((this.vertexFormat & 1) != 0) {
            n += 3;
        }
        if ((this.vertexFormat & 2) != 0) {
            n += 3;
        }
        if ((this.vertexFormat & 4) != 0) {
            n = (this.vertexFormat & 0x80) == 0 ? (n += 4) : ((this.vertexFormat & 8) == 0 ? (n += 3) : (n += 4));
        }
        if ((this.vertexFormat & 0x460) != 0) {
            if ((this.vertexFormat & 0x20) != 0) {
                this.texCoordStride = 2;
            } else if ((this.vertexFormat & 0x40) != 0) {
                this.texCoordStride = 3;
            } else if ((this.vertexFormat & 0x400) != 0) {
                this.texCoordStride = 4;
            }
            n += this.texCoordStride * this.texCoordSetCount;
        }
        return n;
    }

    int[] texCoordSetMapOffset() {
        if (this.texCoordSetMap == null) {
            return null;
        }
        this.texCoordSetMapOffset = new int[this.texCoordSetMap.length];
        int n = 0;
        while (n < this.texCoordSetMap.length) {
            this.texCoordSetMapOffset[n] = this.texCoordSetMap[n] == -1 ? -1 : this.texCoordSetMap[n] * this.texCoordStride;
            ++n;
        }
        return this.texCoordSetMapOffset;
    }

    int colorOffset() {
        int n = this.textureOffset;
        if ((this.vertexFormat & 0x20) != 0) {
            n += 2 * this.texCoordSetCount;
        } else if ((this.vertexFormat & 0x40) != 0) {
            n += 3 * this.texCoordSetCount;
        } else if ((this.vertexFormat & 0x400) != 0) {
            n += 4 * this.texCoordSetCount;
        }
        return n;
    }

    int normalOffset() {
        int n = this.colorOffset;
        if ((this.vertexFormat & 4) != 0) {
            n = (this.vertexFormat & 0x80) == 0 ? (n += 4) : ((this.vertexFormat & 8) == 0 ? (n += 3) : (n += 4));
        }
        return n;
    }

    int coordinateOffset() {
        int n = this.normalOffset;
        if ((this.vertexFormat & 2) != 0) {
            n += 3;
        }
        return n;
    }

    int getVertexCount() {
        return this.vertexCount;
    }

    int getVertexFormat() {
        return this.vertexFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDataChangedMessage(boolean bl) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source != null && this.source.isLive()) {
                Cloneable cloneable;
                int n;
                int n2;
                int n3;
                int n4 = 128;
                n4 |= 0x400;
                ArrayList arrayList = this.universeList;
                synchronized (arrayList) {
                    int n5 = this.universeList.size();
                    J3dMessage[] j3dMessageArray = new J3dMessage[n5];
                    n3 = 0;
                    n2 = 0;
                    while (n2 < n5) {
                        Shape3DRetained shape3DRetained;
                        this.gaList.clear();
                        ArrayList arrayList2 = (ArrayList)this.userLists.get(n2);
                        n = 0;
                        while (n < arrayList2.size()) {
                            shape3DRetained = (Shape3DRetained)arrayList2.get(n);
                            cloneable = (LeafRetained)shape3DRetained.sourceNode;
                            if (bl && ((LeafRetained)cloneable).boundsAutoCompute) {
                                ((LeafRetained)cloneable).boundsDirty = true;
                            }
                            ++n;
                        }
                        n = 0;
                        while (n < arrayList2.size()) {
                            shape3DRetained = (Shape3DRetained)arrayList2.get(n);
                            cloneable = (LeafRetained)shape3DRetained.sourceNode;
                            if (((LeafRetained)cloneable).boundsDirty) {
                                ((LeafRetained)cloneable).updateBounds();
                                ((LeafRetained)cloneable).boundsDirty = false;
                            }
                            this.gaList.add(Shape3DRetained.getGeomAtom(shape3DRetained));
                            ++n;
                        }
                        j3dMessageArray[n3] = VirtualUniverse.mc.getMessage();
                        j3dMessageArray[n3].type = 17;
                        j3dMessageArray[n3].threads = n4;
                        j3dMessageArray[n3].args[0] = this.gaList.toArray();
                        j3dMessageArray[n3].args[1] = this;
                        j3dMessageArray[n3].args[2] = null;
                        j3dMessageArray[n3].args[3] = new Integer(this.changedFrequent);
                        j3dMessageArray[n3].universe = (VirtualUniverse)this.universeList.get(n2);
                        ++n2;
                        ++n3;
                    }
                    VirtualUniverse.mc.processMessage(j3dMessageArray);
                }
                if (this.morphUniverseList != null) {
                    cloneable = this.morphUniverseList;
                    synchronized (cloneable) {
                        int n6 = this.morphUniverseList.size();
                        if (n6 > 0) {
                            ArrayList arrayList3 = this.morphUniverseList;
                            synchronized (arrayList3) {
                                n2 = 0;
                                while (n2 < n6) {
                                    ArrayList arrayList4 = (ArrayList)this.morphUserLists.get(n2);
                                    n = 0;
                                    while (n < arrayList4.size()) {
                                        MorphRetained morphRetained = (MorphRetained)arrayList4.get(n);
                                        morphRetained.updateMorphedGeometryArray(this, bl);
                                        ++n;
                                    }
                                    ++n2;
                                    ++n3;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    void setCoordinate(int n, float[] fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.vertexData[n2] = fArray[0];
        this.vertexData[n2 + 1] = fArray[1];
        this.vertexData[n2 + 2] = fArray[2];
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n, double[] dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.vertexData[n2] = (float)dArray[0];
        this.vertexData[n2 + 1] = (float)dArray[1];
        this.vertexData[n2 + 2] = (float)dArray[2];
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n, Point3f point3f) {
        int n2 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.vertexData[n2] = point3f.x;
        this.vertexData[n2 + 1] = point3f.y;
        this.vertexData[n2 + 2] = point3f.z;
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n, Point3d point3d) {
        int n2 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.vertexData[n2] = (float)point3d.x;
        this.vertexData[n2 + 1] = (float)point3d.y;
        this.vertexData[n2 + 2] = (float)point3d.z;
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, float[] fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = fArray[n4];
            this.vertexData[n5 + 1] = fArray[n4 + 1];
            this.vertexData[n5 + 2] = fArray[n4 + 2];
            n4 += 3;
            n5 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, double[] dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = dArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)dArray[n4];
            this.vertexData[n5 + 1] = (float)dArray[n4 + 1];
            this.vertexData[n5 + 2] = (float)dArray[n4 + 2];
            n4 += 3;
            n5 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3f[] point3fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = point3fArray[n4].x;
            this.vertexData[n5 + 1] = point3fArray[n4].y;
            this.vertexData[n5 + 2] = point3fArray[n4].z;
            ++n4;
            n5 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3d[] point3dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3dArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)point3dArray[n4].x;
            this.vertexData[n5 + 1] = (float)point3dArray[n4].y;
            this.vertexData[n5 + 2] = (float)point3dArray[n4].z;
            ++n4;
            n5 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, float[] fArray, int n2, int n3) {
        int n4 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n5 = n2 * 3;
        int n6 = n4;
        while (n5 < (n2 + n3) * 3) {
            this.vertexData[n6] = fArray[n5];
            this.vertexData[n6 + 1] = fArray[n5 + 1];
            this.vertexData[n6 + 2] = fArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, double[] dArray, int n2, int n3) {
        int n4 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n5 = n2 * 3;
        int n6 = n4;
        while (n5 < (n2 + n3) * 3) {
            this.vertexData[n6] = (float)dArray[n5];
            this.vertexData[n6 + 1] = (float)dArray[n5 + 1];
            this.vertexData[n6 + 2] = (float)dArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3f[] point3fArray, int n2, int n3) {
        int n4 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = point3fArray[n5].x;
            this.vertexData[n6 + 1] = point3fArray[n5].y;
            this.vertexData[n6 + 2] = point3fArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3d[] point3dArray, int n2, int n3) {
        int n4 = this.stride * n + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = (float)point3dArray[n5].x;
            this.vertexData[n6 + 1] = (float)point3dArray[n5].y;
            this.vertexData[n6 + 2] = (float)point3dArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setColor(int n, float[] fArray) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = fArray[0];
        this.vertexData[n2 + 1] = fArray[1];
        this.vertexData[n2 + 2] = fArray[2];
        this.vertexData[n2 + 3] = (this.vertexFormat & 8) != 0 ? fArray[3] * this.lastAlpha[0] : this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n, byte[] byArray) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = (float)(byArray[0] & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 1] = (float)(byArray[1] & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 2] = (float)(byArray[2] & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 3] = (this.vertexFormat & 8) != 0 ? (float)(byArray[3] & 0xFF) * 0.003921569f * this.lastAlpha[0] : this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n, Color3f color3f) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = color3f.x;
        this.vertexData[n2 + 1] = color3f.y;
        this.vertexData[n2 + 2] = color3f.z;
        this.vertexData[n2 + 3] = this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n, Color4f color4f) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = color4f.x;
        this.vertexData[n2 + 1] = color4f.y;
        this.vertexData[n2 + 2] = color4f.z;
        this.vertexData[n2 + 3] = color4f.w * this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n, Color3b color3b) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = (float)(color3b.x & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 1] = (float)(color3b.y & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 2] = (float)(color3b.z & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 3] = this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n, Color4b color4b) {
        int n2 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = (float)(color4b.x * 255) * 0.003921569f;
        this.vertexData[n2 + 1] = (float)(color4b.y * 255) * 0.003921569f;
        this.vertexData[n2 + 2] = (float)(color4b.z * 255) * 0.003921569f;
        this.vertexData[n2 + 3] = (float)(color4b.w & 0xFF) * 0.003921569f * this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, float[] fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                this.vertexData[n5] = fArray[n4];
                this.vertexData[n5 + 1] = fArray[n4 + 1];
                this.vertexData[n5 + 2] = fArray[n4 + 2];
                this.vertexData[n5 + 3] = fArray[n4 + 3] * this.lastAlpha[0];
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                this.vertexData[n7] = fArray[n6];
                this.vertexData[n7 + 1] = fArray[n6 + 1];
                this.vertexData[n7 + 2] = fArray[n6 + 2];
                this.vertexData[n7 + 3] = this.lastAlpha[0];
                n6 += 3;
                n7 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, byte[] byArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = byArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                this.vertexData[n5] = (float)(byArray[n4] & 0xFF) * 0.003921569f;
                this.vertexData[n5 + 1] = (float)(byArray[n4 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n5 + 2] = (float)(byArray[n4 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n5 + 3] = (float)(byArray[n4 + 3] & 0xFF) * 0.003921569f * this.lastAlpha[0];
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                this.vertexData[n7] = (float)(byArray[n6] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 1] = (float)(byArray[n6 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 2] = (float)(byArray[n6 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 3] = this.lastAlpha[0];
                n6 += 3;
                n7 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color3f[] color3fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = color3fArray[n4].x;
            this.vertexData[n5 + 1] = color3fArray[n4].y;
            this.vertexData[n5 + 2] = color3fArray[n4].z;
            this.vertexData[n5 + 3] = this.lastAlpha[0];
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color4f[] color4fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = color4fArray[n4].x;
            this.vertexData[n5 + 1] = color4fArray[n4].y;
            this.vertexData[n5 + 2] = color4fArray[n4].z;
            this.vertexData[n5 + 3] = color4fArray[n4].w * this.lastAlpha[0];
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color3b[] color3bArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3bArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)(color3bArray[n4].x & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 1] = (float)(color3bArray[n4].y & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 2] = (float)(color3bArray[n4].z & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 3] = this.lastAlpha[0];
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color4b[] color4bArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4bArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)(color4bArray[n4].x & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 1] = (float)(color4bArray[n4].y & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 2] = (float)(color4bArray[n4].z & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 3] = (float)(color4bArray[n4].w & 0xFF) * 0.003921569f * this.lastAlpha[0];
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, float[] fArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n5 = n2 * 4;
            int n6 = n4;
            while (n5 < (n2 + n3) * 4) {
                this.vertexData[n6] = fArray[n5];
                this.vertexData[n6 + 1] = fArray[n5 + 1];
                this.vertexData[n6 + 2] = fArray[n5 + 2];
                this.vertexData[n6 + 3] = fArray[n5 + 3] * this.lastAlpha[0];
                n5 += 4;
                n6 += this.stride;
            }
        } else {
            int n7 = n2 * 3;
            int n8 = n4;
            while (n7 < (n2 + n3) * 3) {
                this.vertexData[n8] = fArray[n7];
                this.vertexData[n8 + 1] = fArray[n7 + 1];
                this.vertexData[n8 + 2] = fArray[n7 + 2];
                this.vertexData[n8 + 3] = this.lastAlpha[0];
                n7 += 3;
                n8 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, byte[] byArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n5 = n2 * 4;
            int n6 = n4;
            while (n5 < (n2 + n3) * 4) {
                this.vertexData[n6] = (float)(byArray[n5] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 1] = (float)(byArray[n5 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 2] = (float)(byArray[n5 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 3] = (float)(byArray[n5 + 3] & 0xFF) * 0.003921569f * this.lastAlpha[0];
                n5 += 4;
                n6 += this.stride;
            }
        } else {
            int n7 = n2 * 3;
            int n8 = n4;
            while (n7 < (n2 + n3) * 3) {
                this.vertexData[n8] = (float)(byArray[n7] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 1] = (float)(byArray[n7 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 2] = (float)(byArray[n7 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 3] = this.lastAlpha[0];
                n7 += 3;
                n8 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color3f[] color3fArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = color3fArray[n5].x;
            this.vertexData[n6 + 1] = color3fArray[n5].y;
            this.vertexData[n6 + 2] = color3fArray[n5].z;
            this.vertexData[n6 + 3] = this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color4f[] color4fArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = color4fArray[n5].x;
            this.vertexData[n6 + 1] = color4fArray[n5].y;
            this.vertexData[n6 + 2] = color4fArray[n5].z;
            this.vertexData[n6 + 3] = color4fArray[n5].w * this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color3b[] color3bArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = (float)(color3bArray[n5].x & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 1] = (float)(color3bArray[n5].y & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 2] = (float)(color3bArray[n5].z & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 3] = this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n, Color4b[] color4bArray, int n2, int n3) {
        int n4 = this.stride * n + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = (float)(color4bArray[n5].x & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 1] = (float)(color4bArray[n5].y & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 2] = (float)(color4bArray[n5].z & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 3] = (float)(color4bArray[n5].w & 0xFF) * 0.003921569f * this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormal(int n, float[] fArray) {
        int n2 = this.stride * n + this.normalOffset;
        this.geomLock.getLock();
        this.vertexData[n2] = fArray[0];
        this.vertexData[n2 + 1] = fArray[1];
        this.vertexData[n2 + 2] = fArray[2];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormal(int n, Vector3f vector3f) {
        int n2 = this.stride * n + this.normalOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        this.vertexData[n2] = vector3f.x;
        this.vertexData[n2 + 1] = vector3f.y;
        this.vertexData[n2 + 2] = vector3f.z;
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n, float[] fArray) {
        int n2 = this.stride * n + this.normalOffset;
        int n3 = fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = fArray[n4];
            this.vertexData[n5 + 1] = fArray[n4 + 1];
            this.vertexData[n5 + 2] = fArray[n4 + 2];
            n4 += 3;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n, Vector3f[] vector3fArray) {
        int n2 = this.stride * n + this.normalOffset;
        int n3 = vector3fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = vector3fArray[n4].x;
            this.vertexData[n5 + 1] = vector3fArray[n4].y;
            this.vertexData[n5 + 2] = vector3fArray[n4].z;
            ++n4;
            n5 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n, float[] fArray, int n2, int n3) {
        int n4 = this.stride * n + this.normalOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        int n5 = n2 * 3;
        int n6 = n4;
        while (n5 < (n2 + n3) * 3) {
            this.vertexData[n6] = fArray[n5];
            this.vertexData[n6 + 1] = fArray[n5 + 1];
            this.vertexData[n6 + 2] = fArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n, Vector3f[] vector3fArray, int n2, int n3) {
        int n4 = this.stride * n + this.normalOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = vector3fArray[n5].x;
            this.vertexData[n6 + 1] = vector3fArray[n5].y;
            this.vertexData[n6 + 2] = vector3fArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n, int n2, float[] fArray, int n3, int n4) {
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x400) != 0) {
            int n6 = n3 * 4;
            int n7 = n5;
            int n8 = 0;
            while (n8 < n4) {
                this.vertexData[n7] = fArray[n6++];
                this.vertexData[n7 + 1] = fArray[n6++];
                this.vertexData[n7 + 2] = fArray[n6++];
                this.vertexData[n7 + 3] = fArray[n6++];
                n7 += this.stride;
                ++n8;
            }
        } else if ((this.vertexFormat & 0x40) != 0) {
            int n9 = n3 * 3;
            int n10 = n5;
            int n11 = 0;
            while (n11 < n4) {
                this.vertexData[n10] = fArray[n9++];
                this.vertexData[n10 + 1] = fArray[n9++];
                this.vertexData[n10 + 2] = fArray[n9++];
                n10 += this.stride;
                ++n11;
            }
        } else {
            int n12 = n3 * 2;
            int n13 = n5;
            int n14 = 0;
            while (n14 < n4) {
                this.vertexData[n13] = fArray[n12++];
                this.vertexData[n13 + 1] = fArray[n12++];
                n13 += this.stride;
                ++n14;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n, int n2, Point2f[] point2fArray, int n3, int n4) {
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = point2fArray[n6].x;
            this.vertexData[n7 + 1] = point2fArray[n6].y;
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n, int n2, Point3f[] point3fArray, int n3, int n4) {
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = point3fArray[n6].x;
            this.vertexData[n7 + 1] = point3fArray[n6].y;
            this.vertexData[n7 + 2] = point3fArray[n6].z;
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n, int n2, TexCoord2f[] texCoord2fArray, int n3, int n4) {
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = texCoord2fArray[n6].x;
            this.vertexData[n7 + 1] = texCoord2fArray[n6].y;
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n, int n2, TexCoord3f[] texCoord3fArray, int n3, int n4) {
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = texCoord3fArray[n6].x;
            this.vertexData[n7 + 1] = texCoord3fArray[n6].y;
            this.vertexData[n7 + 2] = texCoord3fArray[n6].z;
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n, int n2, TexCoord4f[] texCoord4fArray, int n3, int n4) {
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = texCoord4fArray[n6].x;
            this.vertexData[n7 + 1] = texCoord4fArray[n6].y;
            this.vertexData[n7 + 2] = texCoord4fArray[n6].z;
            this.vertexData[n7 + 3] = texCoord4fArray[n6].w;
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void getCoordinate(int n, float[] fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        fArray[0] = this.vertexData[n2];
        fArray[1] = this.vertexData[n2 + 1];
        fArray[2] = this.vertexData[n2 + 2];
    }

    void getCoordinate(int n, double[] dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        dArray[0] = this.vertexData[n2];
        dArray[1] = this.vertexData[n2 + 1];
        dArray[2] = this.vertexData[n2 + 2];
    }

    void getCoordinate(int n, Point3f point3f) {
        int n2 = this.stride * n + this.coordinateOffset;
        point3f.x = this.vertexData[n2];
        point3f.y = this.vertexData[n2 + 1];
        point3f.z = this.vertexData[n2 + 2];
    }

    void getCoordinate(int n, Point3d point3d) {
        int n2 = this.stride * n + this.coordinateOffset;
        point3d.x = this.vertexData[n2];
        point3d.y = this.vertexData[n2 + 1];
        point3d.z = this.vertexData[n2 + 2];
    }

    void getCoordinates(int n, float[] fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            fArray[n4] = this.vertexData[n5];
            fArray[n4 + 1] = this.vertexData[n5 + 1];
            fArray[n4 + 2] = this.vertexData[n5 + 2];
            n4 += 3;
            n5 += this.stride;
        }
    }

    void getCoordinates(int n, double[] dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = dArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            dArray[n4] = this.vertexData[n5];
            dArray[n4 + 1] = this.vertexData[n5 + 1];
            dArray[n4 + 2] = this.vertexData[n5 + 2];
            n4 += 3;
            n5 += this.stride;
        }
    }

    void getCoordinates(int n, Point3f[] point3fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            point3fArray[n4].x = this.vertexData[n5];
            point3fArray[n4].y = this.vertexData[n5 + 1];
            point3fArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getCoordinates(int n, Point3d[] point3dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3dArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            point3dArray[n4].x = this.vertexData[n5];
            point3dArray[n4].y = this.vertexData[n5 + 1];
            point3dArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getColor(int n, float[] fArray) {
        int n2 = this.stride * n + this.colorOffset;
        fArray[0] = this.vertexData[n2];
        fArray[1] = this.vertexData[n2 + 1];
        fArray[2] = this.vertexData[n2 + 2];
        if ((this.vertexFormat & 8) != 0) {
            fArray[3] = this.vertexData[n2 + 3] / this.lastAlpha[0];
        }
    }

    void getColor(int n, byte[] byArray) {
        int n2 = this.stride * n + this.colorOffset;
        byArray[0] = (byte)(this.vertexData[n2] * 255.0f);
        byArray[1] = (byte)(this.vertexData[n2 + 1] * 255.0f);
        byArray[2] = (byte)(this.vertexData[n2 + 2] * 255.0f);
        if ((this.vertexFormat & 8) != 0) {
            byArray[3] = (byte)(this.vertexData[n2 + 3] / this.lastAlpha[0] * 255.0f);
        }
    }

    void getColor(int n, Color3f color3f) {
        int n2 = this.stride * n + this.colorOffset;
        color3f.x = this.vertexData[n2];
        color3f.y = this.vertexData[n2 + 1];
        color3f.z = this.vertexData[n2 + 2];
    }

    void getColor(int n, Color4f color4f) {
        int n2 = this.stride * n + this.colorOffset;
        color4f.x = this.vertexData[n2];
        color4f.y = this.vertexData[n2 + 1];
        color4f.z = this.vertexData[n2 + 2];
        color4f.w = this.vertexData[n2 + 3] / this.lastAlpha[0];
    }

    void getColor(int n, Color3b color3b) {
        int n2 = this.stride * n + this.colorOffset;
        color3b.x = (byte)(this.vertexData[n2] * 255.0f);
        color3b.y = (byte)(this.vertexData[n2 + 1] * 255.0f);
        color3b.z = (byte)(this.vertexData[n2 + 2] * 255.0f);
    }

    void getColor(int n, Color4b color4b) {
        int n2 = this.stride * n + this.colorOffset;
        color4b.x = (byte)(this.vertexData[n2] * 255.0f);
        color4b.y = (byte)(this.vertexData[n2 + 1] * 255.0f);
        color4b.z = (byte)(this.vertexData[n2 + 2] * 255.0f);
        color4b.w = (byte)(this.vertexData[n2 + 3] / this.lastAlpha[0] * 255.0f);
    }

    void getColors(int n, float[] fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = fArray.length;
        float f = 1.0f / this.lastAlpha[0];
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                fArray[n4] = this.vertexData[n5];
                fArray[n4 + 1] = this.vertexData[n5 + 1];
                fArray[n4 + 2] = this.vertexData[n5 + 2];
                fArray[n4 + 3] = this.vertexData[n5 + 3] * f;
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                fArray[n6] = this.vertexData[n7];
                fArray[n6 + 1] = this.vertexData[n7 + 1];
                fArray[n6 + 2] = this.vertexData[n7 + 2];
                n6 += 3;
                n7 += this.stride;
            }
        }
    }

    void getColors(int n, byte[] byArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = byArray.length;
        float f = 1.0f / this.lastAlpha[0];
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                byArray[n4] = (byte)(this.vertexData[n5] * 255.0f);
                byArray[n4 + 1] = (byte)(this.vertexData[n5 + 1] * 255.0f);
                byArray[n4 + 2] = (byte)(this.vertexData[n5 + 2] * 255.0f);
                byArray[n4 + 3] = (byte)(this.vertexData[n5 + 3] * f * 255.0f);
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                byArray[n6] = (byte)(this.vertexData[n7] * 255.0f);
                byArray[n6 + 1] = (byte)(this.vertexData[n7 + 1] * 255.0f);
                byArray[n6 + 2] = (byte)(this.vertexData[n7 + 2] * 255.0f);
                n6 += 3;
                n7 += this.stride;
            }
        }
    }

    void getColors(int n, Color3f[] color3fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color3fArray[n4].x = this.vertexData[n5];
            color3fArray[n4].y = this.vertexData[n5 + 1];
            color3fArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getColors(int n, Color4f[] color4fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4fArray.length;
        float f = 1.0f / this.lastAlpha[0];
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color4fArray[n4].x = this.vertexData[n5];
            color4fArray[n4].y = this.vertexData[n5 + 1];
            color4fArray[n4].z = this.vertexData[n5 + 2];
            color4fArray[n4].w = this.vertexData[n5 + 3] * f;
            ++n4;
            n5 += this.stride;
        }
    }

    void getColors(int n, Color3b[] color3bArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3bArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color3bArray[n4].x = (byte)(this.vertexData[n5] * 255.0f);
            color3bArray[n4].y = (byte)(this.vertexData[n5 + 1] * 255.0f);
            color3bArray[n4].z = (byte)(this.vertexData[n5 + 2] * 255.0f);
            ++n4;
            n5 += this.stride;
        }
    }

    void getColors(int n, Color4b[] color4bArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4bArray.length;
        float f = 1.0f / this.lastAlpha[0];
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color4bArray[n4].x = (byte)(this.vertexData[n5] * 255.0f);
            color4bArray[n4].y = (byte)(this.vertexData[n5 + 1] * 255.0f);
            color4bArray[n4].z = (byte)(this.vertexData[n5 + 2] * 255.0f);
            color4bArray[n4].w = (byte)(this.vertexData[n5 + 3] * f * 255.0f);
            ++n4;
            n5 += this.stride;
        }
    }

    void getNormal(int n, float[] fArray) {
        int n2 = this.stride * n + this.normalOffset;
        fArray[0] = this.vertexData[n2];
        fArray[1] = this.vertexData[n2 + 1];
        fArray[2] = this.vertexData[n2 + 2];
    }

    void getNormal(int n, Vector3f vector3f) {
        int n2 = this.stride * n + this.normalOffset;
        vector3f.x = this.vertexData[n2];
        vector3f.y = this.vertexData[n2 + 1];
        vector3f.z = this.vertexData[n2 + 2];
    }

    void getNormals(int n, float[] fArray) {
        int n2 = this.stride * n + this.normalOffset;
        int n3 = fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            fArray[n4] = this.vertexData[n5];
            fArray[n4 + 1] = this.vertexData[n5 + 1];
            fArray[n4 + 2] = this.vertexData[n5 + 2];
            n4 += 3;
            n5 += this.stride;
        }
    }

    void getNormals(int n, Vector3f[] vector3fArray) {
        int n2 = this.stride * n + this.normalOffset;
        int n3 = vector3fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            vector3fArray[n4].x = this.vertexData[n5];
            vector3fArray[n4].y = this.vertexData[n5 + 1];
            vector3fArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getTextureCoordinate(int n, int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        fArray[0] = this.vertexData[n3];
        fArray[1] = this.vertexData[n3 + 1];
        if ((this.vertexFormat & 0x40) != 0) {
            fArray[2] = this.vertexData[n3 + 2];
        } else if ((this.vertexFormat & 0x400) != 0) {
            fArray[2] = this.vertexData[n3 + 2];
            fArray[3] = this.vertexData[n3 + 3];
        }
    }

    void getTextureCoordinate(int n, int n2, TexCoord2f texCoord2f) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        texCoord2f.x = this.vertexData[n3];
        texCoord2f.y = this.vertexData[n3 + 1];
    }

    void getTextureCoordinate(int n, int n2, TexCoord3f texCoord3f) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        texCoord3f.x = this.vertexData[n3];
        texCoord3f.y = this.vertexData[n3 + 1];
        texCoord3f.z = this.vertexData[n3 + 2];
    }

    void getTextureCoordinate(int n, int n2, TexCoord4f texCoord4f) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        texCoord4f.x = this.vertexData[n3];
        texCoord4f.y = this.vertexData[n3 + 1];
        texCoord4f.z = this.vertexData[n3 + 2];
        texCoord4f.w = this.vertexData[n3 + 3];
    }

    void getTextureCoordinates(int n, int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = fArray.length;
        if ((this.vertexFormat & 0x400) != 0) {
            int n5 = 0;
            int n6 = n3;
            while (n5 < n4) {
                fArray[n5] = this.vertexData[n6];
                fArray[n5 + 1] = this.vertexData[n6 + 1];
                fArray[n5 + 2] = this.vertexData[n6 + 2];
                fArray[n5 + 3] = this.vertexData[n6 + 3];
                n5 += 4;
                n6 += this.stride;
            }
        } else if ((this.vertexFormat & 0x40) != 0) {
            int n7 = 0;
            int n8 = n3;
            while (n7 < n4) {
                fArray[n7] = this.vertexData[n8];
                fArray[n7 + 1] = this.vertexData[n8 + 1];
                fArray[n7 + 2] = this.vertexData[n8 + 2];
                n7 += 3;
                n8 += this.stride;
            }
        } else {
            int n9 = 0;
            int n10 = n3;
            while (n9 < n4) {
                fArray[n9] = this.vertexData[n10];
                fArray[n9 + 1] = this.vertexData[n10 + 1];
                n9 += 2;
                n10 += this.stride;
            }
        }
    }

    void getTextureCoordinates(int n, int n2, TexCoord2f[] texCoord2fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = texCoord2fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            texCoord2fArray[n5].x = this.vertexData[n6];
            texCoord2fArray[n5].y = this.vertexData[n6 + 1];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinates(int n, int n2, TexCoord3f[] texCoord3fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = texCoord3fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            texCoord3fArray[n5].x = this.vertexData[n6];
            texCoord3fArray[n5].y = this.vertexData[n6 + 1];
            texCoord3fArray[n5].z = this.vertexData[n6 + 2];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinates(int n, int n2, TexCoord4f[] texCoord4fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = texCoord4fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            texCoord4fArray[n5].x = this.vertexData[n6];
            texCoord4fArray[n5].y = this.vertexData[n6 + 1];
            texCoord4fArray[n5].z = this.vertexData[n6 + 2];
            texCoord4fArray[n5].w = this.vertexData[n6 + 3];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinates(int n, int n2, Point2f[] point2fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = point2fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            point2fArray[n5].x = this.vertexData[n6];
            point2fArray[n5].y = this.vertexData[n6 + 1];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinates(int n, int n2, Point3f[] point3fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = point3fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            point3fArray[n5].x = this.vertexData[n6];
            point3fArray[n5].y = this.vertexData[n6 + 1];
            point3fArray[n5].z = this.vertexData[n6 + 2];
            ++n5;
            n6 += this.stride;
        }
    }

    void updateData(GeometryUpdater geometryUpdater) {
        boolean bl = false;
        this.geomLock.getLock();
        this.inUpdater = true;
        geometryUpdater.updateData((Geometry)this.source);
        this.inUpdater = false;
        if ((this.vertexFormat & 0x80) != 0) {
            if ((this.vertexFormat & 0x800) != 0) {
                if (!(this instanceof IndexedGeometryArrayRetained) || (this.vertexFormat & 0x200) != 0) {
                    if ((this.vertexFormat & 0x100) != 0) {
                        this.setupMirrorInterleavedColorPointer(false);
                        bl = this.interleavedFloatBufferImpl == null;
                    } else {
                        this.setupMirrorColorPointer(this.vertexType & 0x3F0, false);
                        bl = (this.vertexType & 0xF) == 0;
                    }
                }
            } else if (!(this instanceof IndexedGeometryArrayRetained) || (this.vertexFormat & 0x200) != 0) {
                if ((this.vertexFormat & 0x100) != 0) {
                    this.setupMirrorInterleavedColorPointer(false);
                    bl = this.interLeavedVertexData == null;
                } else {
                    this.setupMirrorVertexPointer(this.vertexType & 0xF);
                    this.setupMirrorColorPointer(this.vertexType & 0x3F0, false);
                    this.setupMirrorNormalPointer(this.vertexType & 0xC00);
                    this.setupMirrorTexCoordPointer(this.vertexType & 0x7000);
                    bl = (this.vertexType & 0xF) == 0;
                }
            }
        }
        this.dirtyFlag |= 0xF;
        this.colorChanged = 65535;
        this.geomLock.unLock();
        if (this.source != null && this.source.isLive()) {
            this.processCoordsChanged(bl);
            this.sendDataChangedMessage(true);
        }
    }

    boolean intersectBoundingBox(Point3d[] point3dArray, BoundingBox boundingBox, double[] dArray, Point3d point3d) {
        int[] nArray = new int[6];
        int n = 0;
        while (n < 6) {
            nArray[n] = 0;
            ++n;
        }
        n = 0;
        while (n < point3dArray.length) {
            if (point3dArray[n].x >= boundingBox.lower.x && point3dArray[n].x <= boundingBox.upper.x && point3dArray[n].y >= boundingBox.lower.y && point3dArray[n].y <= boundingBox.upper.y && point3dArray[n].z >= boundingBox.lower.z && point3dArray[n].z <= boundingBox.upper.z) {
                return true;
            }
            if (point3dArray[n].x < boundingBox.lower.x) {
                nArray[0] = nArray[0] + 1;
            }
            if (point3dArray[n].y < boundingBox.lower.y) {
                nArray[1] = nArray[1] + 1;
            }
            if (point3dArray[n].z < boundingBox.lower.z) {
                nArray[2] = nArray[2] + 1;
            }
            if (point3dArray[n].x > boundingBox.upper.x) {
                nArray[3] = nArray[3] + 1;
            }
            if (point3dArray[n].y > boundingBox.upper.y) {
                nArray[4] = nArray[4] + 1;
            }
            if (point3dArray[n].z > boundingBox.upper.z) {
                nArray[5] = nArray[5] + 1;
            }
            ++n;
        }
        if (nArray[0] == point3dArray.length || nArray[1] == point3dArray.length || nArray[2] == point3dArray.length || nArray[3] == point3dArray.length || nArray[4] == point3dArray.length || nArray[5] == point3dArray.length) {
            return false;
        }
        Point3d[] point3dArray2 = new Point3d[4];
        n = 0;
        while (n < 4) {
            point3dArray2[n] = this.getPoint3d();
            ++n;
        }
        point3dArray2[0].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            n = 0;
            while (n < 4) {
                this.freePoint3d(point3dArray2[n]);
                ++n;
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            n = 0;
            while (n < 4) {
                this.freePoint3d(point3dArray2[n]);
                ++n;
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            n = 0;
            while (n < 4) {
                this.freePoint3d(point3dArray2[n]);
                ++n;
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            n = 0;
            while (n < 4) {
                this.freePoint3d(point3dArray2[n]);
                ++n;
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            n = 0;
            while (n < 4) {
                this.freePoint3d(point3dArray2[n]);
                ++n;
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            n = 0;
            while (n < 4) {
                this.freePoint3d(point3dArray2[n]);
                ++n;
            }
            return true;
        }
        n = 0;
        while (n < 4) {
            this.freePoint3d(point3dArray2[n]);
            ++n;
        }
        return false;
    }

    boolean intersectBoundingSphere(Point3d[] point3dArray, BoundingSphere boundingSphere, double[] dArray, Point3d point3d) {
        Vector3d vector3d = this.getVector3d();
        int n = 0;
        while (n < point3dArray.length) {
            vector3d.x = point3dArray[n].x - boundingSphere.center.x;
            vector3d.y = point3dArray[n].y - boundingSphere.center.y;
            vector3d.z = point3dArray[n].z - boundingSphere.center.z;
            if (vector3d.length() <= boundingSphere.radius) {
                if (dArray != null) {
                    this.computeMinDistance(point3dArray, boundingSphere.getCenter(), null, dArray, point3d);
                }
                this.freeVector3d(vector3d);
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < point3dArray.length) {
            boolean bl = n < point3dArray.length - 1 ? this.edgeIntersectSphere(boundingSphere, point3dArray[n], point3dArray[n + 1]) : this.edgeIntersectSphere(boundingSphere, point3dArray[n], point3dArray[0]);
            if (bl) {
                if (dArray != null) {
                    this.computeMinDistance(point3dArray, boundingSphere.getCenter(), null, dArray, point3d);
                }
                this.freeVector3d(vector3d);
                return true;
            }
            ++n;
        }
        if (point3dArray.length < 3) {
            this.freeVector3d(vector3d);
            return false;
        }
        Vector3d vector3d2 = this.getVector3d();
        Vector3d vector3d3 = this.getVector3d();
        Vector3d vector3d4 = this.getVector3d();
        Vector3d vector3d5 = this.getVector3d();
        Point3d point3d2 = this.getPoint3d();
        n = 0;
        while (n < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d2.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d2.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d2.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d3.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d3.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d3.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d3.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            this.freePoint3d(point3d2);
            return false;
        }
        vector3d4.cross(vector3d2, vector3d3);
        double d = vector3d4.lengthSquared();
        if (d == 0.0) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            this.freePoint3d(point3d2);
            return false;
        }
        vector3d5.x = point3dArray[0].x - boundingSphere.center.x;
        vector3d5.y = point3dArray[0].y - boundingSphere.center.y;
        vector3d5.z = point3dArray[0].z - boundingSphere.center.z;
        double d2 = vector3d4.dot(vector3d5);
        double d3 = Math.sqrt(d2 * d2 / d);
        if (d3 > boundingSphere.radius) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            this.freePoint3d(point3d2);
            return false;
        }
        double d4 = d2 / d;
        point3d2.x = boundingSphere.center.x + d4 * vector3d4.x;
        point3d2.y = boundingSphere.center.y + d4 * vector3d4.y;
        point3d2.z = boundingSphere.center.z + d4 * vector3d4.z;
        if (this.pointIntersectPolygon2D(vector3d4, point3dArray, point3d2)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray, boundingSphere.getCenter(), vector3d4, dArray, point3d);
            }
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            this.freePoint3d(point3d2);
            return true;
        }
        this.freeVector3d(vector3d);
        this.freeVector3d(vector3d2);
        this.freeVector3d(vector3d3);
        this.freeVector3d(vector3d4);
        this.freeVector3d(vector3d5);
        this.freePoint3d(point3d2);
        return false;
    }

    boolean intersectBoundingPolytope(Point3d[] point3dArray, BoundingPolytope boundingPolytope, double[] dArray, Point3d point3d) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        Point4d point4d = new Point4d();
        double d = -1.0;
        if (point3dArray.length == 2) {
            if (boundingPolytope.intersect(point3dArray[0], point3dArray[1], point4d)) {
                if (dArray != null) {
                    point3d.x = point4d.x;
                    point3d.y = point4d.y;
                    point3d.z = point4d.z;
                    Point3d point3d2 = boundingPolytope.getCenter();
                    double d2 = point3d.x - point3d2.x;
                    double d3 = point3d.y - point3d2.y;
                    double d4 = point3d.z - point3d2.z;
                    dArray[0] = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
                }
                return true;
            }
            return false;
        }
        if (bl) {
            System.out.println("The value of the input vertices are: ");
            int n6 = 0;
            while (n6 < point3dArray.length) {
                System.out.println("The " + n6 + " th vertex is: " + point3dArray[n6]);
                ++n6;
            }
            System.out.println("The value of the input bounding Polytope's planes =");
            n5 = 0;
            while (n5 < boundingPolytope.planes.length) {
                System.out.println("The " + n5 + " th plane is: " + boundingPolytope.planes[n5]);
                ++n5;
            }
        }
        double[] dArray2 = new double[]{0.8, 0.9, 1.1, 1.2};
        n5 = 1;
        boolean bl2 = false;
        if (bl2) {
            n4 = 0;
            while (n4 < point3dArray.length) {
                n3 = 0;
                while (n3 < boundingPolytope.planes.length) {
                    if (!(boundingPolytope.planes[n3].x * point3dArray[n4].x + boundingPolytope.planes[n3].y * point3dArray[n4].y + boundingPolytope.planes[n3].z * point3dArray[n4].z <= d * boundingPolytope.planes[n3].w)) {
                        n5 = 0;
                        break;
                    }
                    n5 = 1;
                    ++n3;
                }
                if (n5 != 0) {
                    if (dArray != null) {
                        this.computeMinDistance(point3dArray, boundingPolytope.getCenter(), null, dArray, point3d);
                    }
                    return true;
                }
                ++n4;
            }
        }
        n4 = boundingPolytope.planes.length + 2 + point3dArray.length + 1;
        n3 = 1 + point3dArray.length;
        double[][] dArray3 = new double[n3][n4];
        int n7 = 0;
        while (n7 < boundingPolytope.planes.length) {
            n2 = 0;
            while (n2 < point3dArray.length) {
                dArray3[n2][n7] = -1.0 * (boundingPolytope.planes[n7].x * point3dArray[n2].x + boundingPolytope.planes[n7].y * point3dArray[n2].y + boundingPolytope.planes[n7].z * point3dArray[n2].z);
                ++n2;
            }
            ++n7;
        }
        n2 = 0;
        while (n2 < point3dArray.length) {
            dArray3[n2][boundingPolytope.planes.length] = -1.0;
            dArray3[n2][boundingPolytope.planes.length + 1] = 1.0;
            n = 0;
            while (n < point3dArray.length) {
                dArray3[n2][n + boundingPolytope.planes.length + 2] = n2 == n ? 1.0 : 0.0;
                dArray3[n2][n4 - 1] = dArray2[n2];
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < boundingPolytope.planes.length) {
            dArray3[n3 - 1][n] = d * boundingPolytope.planes[n].w;
            ++n;
        }
        dArray3[n3 - 1][boundingPolytope.planes.length] = 1.0;
        dArray3[n3 - 1][boundingPolytope.planes.length + 1] = -1.0;
        int n8 = 0;
        while (n8 < point3dArray.length) {
            dArray3[n3 - 1][boundingPolytope.planes.length + 2 + n8] = 0.0;
            ++n8;
        }
        if (bl) {
            System.out.println("The value of the problem tableau is: ");
            int n9 = 0;
            while (n9 < dArray3.length) {
                int n10 = 0;
                while (n10 < dArray3[0].length) {
                    System.out.print(dArray3[n9][n10] + "  ");
                    ++n10;
                }
                System.out.println();
                ++n9;
            }
        }
        double d5 = this.generalStandardSimplexSolver(dArray3, Double.NEGATIVE_INFINITY);
        if (bl) {
            System.out.println("The value returned by the general standard simplex = " + d5);
        }
        if (d5 == Double.POSITIVE_INFINITY) {
            return false;
        }
        if (dArray != null) {
            this.computeMinDistance(point3dArray, boundingPolytope.getCenter(), null, dArray, point3d);
        }
        return true;
    }

    double generalStandardSimplexSolver(double[][] dArray, double d) {
        boolean bl = false;
        int n = dArray.length;
        int n2 = dArray[0].length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            System.out.println("The number of rows is : " + n);
            System.out.println("The number of columns is : " + n2);
        }
        while (!bl2) {
            double d2;
            if (bl) {
                System.out.println("input problem tableau is:");
                int n3 = 0;
                while (n3 < n) {
                    int n4 = 0;
                    while (n4 < n2) {
                        System.out.println("kth, jth value is:" + n3 + " " + n4 + " : " + dArray[n3][n4]);
                        ++n4;
                    }
                    ++n3;
                }
            }
            int n5 = 0;
            double d3 = 0.0;
            int n6 = -1;
            while (n5 < n2 - 1) {
                d2 = dArray[n - 1][n5];
                if (d2 < d3) {
                    d3 = d2;
                    n6 = n5;
                }
                ++n5;
            }
            if (n6 == -1) {
                bl2 = true;
            }
            if (bl2) continue;
            double d4 = Double.POSITIVE_INFINITY;
            double d5 = 0.0;
            int n7 = -1;
            n5 = 0;
            while (n5 < n - 1) {
                d2 = dArray[n5][n6];
                double d6 = dArray[n5][n2 - 1];
                if (d2 == 0.0) {
                    if (bl) {
                        System.out.println("Division by zero has occurred");
                        System.out.println("Within the linear program solver");
                        System.out.println("Ignoring the zero as a potential pivot");
                    }
                } else if (d2 < 0.0 || d6 < 0.0) {
                    if (bl) {
                        System.out.println("Ignoring cases where element is negative");
                        System.out.println("The value of element is: " + d2);
                        System.out.println("The value of end Element is: " + d6);
                    }
                } else {
                    d5 = d6 / d2;
                    if (bl) {
                        System.out.println("The value of element is: " + d2);
                        System.out.println("The value of endElement is: " + d6);
                        System.out.println("The value of ratio is: " + d5);
                        System.out.println("The value of prevRatio is: " + d4);
                        System.out.println("Value of ratio <= prevRatio is :" + (d5 <= d4));
                    }
                    if (d5 <= d4) {
                        if (bl) {
                            System.out.println("updating prevRatio with ratio");
                        }
                        d4 = d5;
                        n7 = n5;
                    }
                }
                ++n5;
            }
            if (n7 == -1) {
                if (bl) {
                    System.out.println("UNABLE TO FIND SOLUTION");
                    System.out.println("The system is infeasable or unbounded");
                }
                return Double.POSITIVE_INFINITY;
            }
            double d7 = dArray[n7][n6];
            if (bl) {
                System.out.println("The value of row index is: " + n7);
                System.out.println("The value of col index is: " + n6);
                System.out.println("The value of pivotValue is: " + d7);
            }
            n5 = 0;
            while (n5 < n2) {
                dArray[n7][n5] = dArray[n7][n5] / d7;
                ++n5;
            }
            n5 = 0;
            while (n5 < n) {
                if (n5 != n7) {
                    double d8 = dArray[n5][n6];
                    int n8 = 0;
                    while (n8 < n2) {
                        dArray[n5][n8] = dArray[n5][n8] - d8 * dArray[n7][n8];
                        ++n8;
                    }
                }
                ++n5;
            }
        }
        return dArray[n - 1][n2 - 1];
    }

    boolean edgeIntersectSphere(BoundingSphere boundingSphere, Point3d point3d, Point3d point3d2) {
        Vector3d vector3d = this.getVector3d();
        Vector3d vector3d2 = this.getVector3d();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = boundingSphere.center.x - point3d.x;
        vector3d2.y = boundingSphere.center.y - point3d.y;
        vector3d2.z = boundingSphere.center.z - point3d.z;
        double d = vector3d.dot(vector3d2);
        if (d < 0.0) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            return false;
        }
        double d2 = vector3d.lengthSquared();
        double d3 = d * d / d2;
        if (d3 < d2) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            return false;
        }
        double d4 = boundingSphere.radius * boundingSphere.radius;
        double d5 = vector3d2.lengthSquared();
        if (d5 - d3 <= d4) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            return true;
        }
        this.freeVector3d(vector3d);
        this.freeVector3d(vector3d2);
        return false;
    }

    double det2D(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        return (point2d3.x - point2d.x) * (point2d.y - point2d2.y) + (point2d.y - point2d3.y) * (point2d.x - point2d2.x);
    }

    boolean pointIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d point3d) {
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d point2d = new Point2d();
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        int n = d > d2 ? 0 : 1;
        if (n == 0) {
            if (d < d3) {
                n = 2;
            }
        } else if (n == 1 && d2 < d3) {
            n = 2;
        }
        int n2 = 0;
        while (n2 < point3dArray.length) {
            point2dArray[n2] = new Point2d();
            switch (n) {
                case 0: {
                    point2dArray[n2].x = point3dArray[n2].y;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 1: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 2: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].y;
                }
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                point2d.x = point3d.y;
                point2d.y = point3d.z;
                break;
            }
            case 1: {
                point2d.x = point3d.x;
                point2d.y = point3d.z;
                break;
            }
            case 2: {
                point2d.x = point3d.x;
                point2d.y = point3d.y;
            }
        }
        int n3 = 0;
        while (n3 < point3dArray.length) {
            if (n3 < point3dArray.length - 1) {
                if (!(this.det2D(point2dArray[n3], point2dArray[n3 + 1], point2d) > 0.0)) {
                    return false;
                }
            } else if (!(this.det2D(point2dArray[n3], point2dArray[0], point2d) > 0.0)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    boolean edgeIntersectPlane(Vector3d vector3d, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        Vector3d vector3d2 = this.getVector3d();
        Vector3d vector3d3 = this.getVector3d();
        vector3d2.set((Tuple3d)point3d);
        double d = vector3d.dot(vector3d2);
        vector3d3.x = point3d3.x - point3d2.x;
        vector3d3.y = point3d3.y - point3d2.y;
        vector3d3.z = point3d3.z - point3d2.z;
        double d2 = vector3d.dot(vector3d3);
        if (d2 == 0.0) {
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            return false;
        }
        vector3d2.set((Tuple3d)point3d2);
        double d3 = (d - vector3d.dot(vector3d2)) / d2;
        if (d3 < 0.0 || d3 > 1.0) {
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            return false;
        }
        point3d4.x = point3d2.x + d3 * vector3d3.x;
        point3d4.y = point3d2.y + d3 * vector3d3.y;
        point3d4.z = point3d2.z + d3 * vector3d3.z;
        this.freeVector3d(vector3d2);
        this.freeVector3d(vector3d3);
        return true;
    }

    boolean edgeIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d[] point3dArray2) {
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d[] point2dArray2 = new Point2d[2];
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        int n = d > d2 ? 0 : 1;
        if (n == 0) {
            if (d < d3) {
                n = 2;
            }
        } else if (n == 1 && d2 < d3) {
            n = 2;
        }
        int n2 = 0;
        while (n2 < point3dArray.length) {
            point2dArray[n2] = new Point2d();
            switch (n) {
                case 0: {
                    point2dArray[n2].x = point3dArray[n2].y;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 1: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 2: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].y;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 2) {
            point2dArray2[n2] = new Point2d();
            switch (n) {
                case 0: {
                    point2dArray2[n2].x = point3dArray2[n2].y;
                    point2dArray2[n2].y = point3dArray2[n2].z;
                    break;
                }
                case 1: {
                    point2dArray2[n2].x = point3dArray2[n2].x;
                    point2dArray2[n2].y = point3dArray2[n2].z;
                    break;
                }
                case 2: {
                    point2dArray2[n2].x = point3dArray2[n2].x;
                    point2dArray2[n2].y = point3dArray2[n2].y;
                }
            }
            ++n2;
        }
        boolean[][] blArray = new boolean[2][point3dArray.length];
        int n3 = 0;
        while (n3 < point3dArray.length) {
            n2 = 0;
            while (n2 < 2) {
                blArray[n2][n3] = n3 < point3dArray.length - 1 ? this.det2D(point2dArray[n3], point2dArray[n3 + 1], point2dArray2[n2]) < 0.0 : this.det2D(point2dArray[n3], point2dArray[0], point2dArray2[n2]) < 0.0;
                ++n2;
            }
            if (!blArray[0][n3] && !blArray[1][n3]) {
                return false;
            }
            ++n3;
        }
        boolean bl = true;
        n2 = 0;
        while (n2 < point3dArray.length) {
            if (!blArray[0][n2]) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            return true;
        }
        bl = true;
        n2 = 0;
        while (n2 < point3dArray.length) {
            if (!blArray[1][n2]) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            return true;
        }
        int n4 = 0;
        n2 = 0;
        while (n2 < point3dArray.length) {
            if (this.det2D(point2dArray2[0], point2dArray2[1], point2dArray[n2]) < 0.0) {
                ++n4;
            }
            ++n2;
        }
        return n4 != 0 && n4 != point3dArray.length;
    }

    double getCompValue(Point3d point3d, int n) {
        switch (n) {
            case 0: {
                return point3d.x;
            }
            case 1: {
                return point3d.y;
            }
        }
        return point3d.z;
    }

    double getCompValue(Point3d point3d, Point3d point3d2, int n) {
        switch (n) {
            case 0: {
                return point3d.x - point3d2.x;
            }
            case 1: {
                return point3d.y - point3d2.y;
            }
        }
        return point3d.z - point3d2.z;
    }

    boolean pointInTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Vector3d vector3d) {
        int n;
        int n2;
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        if (d > d2) {
            if (d > d3) {
                n2 = 1;
                n = 2;
            } else {
                n2 = 0;
                n = 1;
            }
        } else if (d3 > d2) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 0;
            n = 2;
        }
        return this.pointInTri(point3d, point3d2, point3d3, point3d4, n2, n);
    }

    boolean pointInTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, int n, int n2) {
        double d = this.getCompValue(point3d3, point3d2, n2);
        double d2 = -this.getCompValue(point3d3, point3d2, n);
        double d3 = -d * this.getCompValue(point3d2, n) - d2 * this.getCompValue(point3d2, n2);
        double d4 = d * this.getCompValue(point3d, n) + d2 * this.getCompValue(point3d, n2) + d3;
        d = this.getCompValue(point3d4, point3d3, n2);
        d2 = -this.getCompValue(point3d4, point3d3, n);
        d3 = -d * this.getCompValue(point3d3, n) - d2 * this.getCompValue(point3d3, n2);
        double d5 = d * this.getCompValue(point3d, n) + d2 * this.getCompValue(point3d, n2) + d3;
        d = this.getCompValue(point3d2, point3d4, n2);
        d2 = -this.getCompValue(point3d2, point3d4, n);
        d3 = -d * this.getCompValue(point3d4, n) - d2 * this.getCompValue(point3d4, n2);
        double d6 = d * this.getCompValue(point3d, n) + d2 * this.getCompValue(point3d, n2) + d3;
        return d4 * d5 > 0.0 && d4 * d6 > 0.0;
    }

    boolean edgeAgainstEdge(Point3d point3d, Point3d point3d2, Point3d point3d3, double d, double d2, int n, int n2) {
        double d3 = this.getCompValue(point3d2, point3d3, n);
        double d4 = this.getCompValue(point3d2, point3d3, n2);
        double d5 = this.getCompValue(point3d, point3d2, n);
        double d6 = this.getCompValue(point3d, point3d2, n2);
        double d7 = d2 * d3 - d * d4;
        double d8 = d4 * d5 - d3 * d6;
        if (d7 > 0.0 && d8 >= 0.0 && d8 <= d7 || d7 < 0.0 && d8 <= 0.0 && d8 >= d7) {
            double d9 = d * d6 - d2 * d5;
            if (d7 > 0.0 ? d9 >= 0.0 && d9 <= d7 : d9 <= 0.0 && d9 >= d7) {
                return true;
            }
        }
        return false;
    }

    boolean edgeAgainstTriEdges(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, int n, int n2) {
        double d;
        double d2 = this.getCompValue(point3d2, point3d, n);
        if (this.edgeAgainstEdge(point3d, point3d3, point3d4, d2, d = this.getCompValue(point3d2, point3d, n2), n, n2)) {
            return true;
        }
        if (this.edgeAgainstEdge(point3d, point3d4, point3d5, d2, d, n, n2)) {
            return true;
        }
        return this.edgeAgainstEdge(point3d, point3d5, point3d3, d2, d, n, n2);
    }

    boolean coplanarTriTri(Vector3d vector3d, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, Point3d point3d6) {
        int n;
        int n2;
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        if (d > d2) {
            if (d > d3) {
                n2 = 1;
                n = 2;
            } else {
                n2 = 0;
                n = 1;
            }
        } else if (d3 > d2) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 0;
            n = 2;
        }
        if (this.edgeAgainstTriEdges(point3d, point3d2, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        if (this.edgeAgainstTriEdges(point3d2, point3d3, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        if (this.edgeAgainstTriEdges(point3d3, point3d, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        if (this.pointInTri(point3d, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        return this.pointInTri(point3d4, point3d, point3d2, point3d3, n2, n);
    }

    boolean intersectTriPnt(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        int n;
        int n2;
        Vector3d vector3d = this.getVector3d();
        Vector3d vector3d2 = this.getVector3d();
        Vector3d vector3d3 = this.getVector3d();
        Vector3d vector3d4 = this.getVector3d();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = point3d3.x - point3d.x;
        vector3d2.y = point3d3.y - point3d.y;
        vector3d2.z = point3d3.z - point3d.z;
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            return false;
        }
        vector3d4.set((Tuple3d)point3d);
        double d = -vector3d3.dot(vector3d4);
        vector3d4.set((Tuple3d)point3d4);
        double d2 = vector3d3.dot(vector3d4) + d;
        if (Math.abs(d2) < 1.0E-13) {
            d2 = 0.0;
        }
        if (d2 != 0.0) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            return false;
        }
        double d3 = Math.abs(vector3d3.x);
        double d4 = Math.abs(vector3d3.y);
        double d5 = Math.abs(vector3d3.z);
        if (d3 > d4) {
            if (d3 > d5) {
                n2 = 1;
                n = 2;
            } else {
                n2 = 0;
                n = 1;
            }
        } else if (d5 > d4) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 0;
            n = 2;
        }
        if (this.pointInTri(point3d4, point3d, point3d2, point3d3, n2, n)) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            return true;
        }
        this.freeVector3d(vector3d);
        this.freeVector3d(vector3d2);
        this.freeVector3d(vector3d3);
        this.freeVector3d(vector3d4);
        return false;
    }

    boolean intersectTriTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, Point3d point3d6) {
        Vector3d vector3d = this.getVector3d();
        Vector3d vector3d2 = this.getVector3d();
        Vector3d vector3d3 = this.getVector3d();
        Vector3d vector3d4 = this.getVector3d();
        Vector3d vector3d5 = this.getVector3d();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = point3d3.x - point3d.x;
        vector3d2.y = point3d3.y - point3d.y;
        vector3d2.z = point3d3.z - point3d.z;
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            return false;
        }
        vector3d5.set((Tuple3d)point3d);
        double d7 = -vector3d3.dot(vector3d5);
        vector3d5.set((Tuple3d)point3d4);
        double d8 = vector3d3.dot(vector3d5) + d7;
        vector3d5.set((Tuple3d)point3d5);
        double d9 = vector3d3.dot(vector3d5) + d7;
        vector3d5.set((Tuple3d)point3d6);
        double d10 = vector3d3.dot(vector3d5) + d7;
        if (Math.abs(d8) < 1.0E-13) {
            d8 = 0.0;
        }
        if (Math.abs(d9) < 1.0E-13) {
            d9 = 0.0;
        }
        if (Math.abs(d10) < 1.0E-13) {
            d10 = 0.0;
        }
        double d11 = d8 * d9;
        double d12 = d8 * d10;
        if (d11 > 0.0 && d12 > 0.0) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            return false;
        }
        vector3d.x = point3d5.x - point3d4.x;
        vector3d.y = point3d5.y - point3d4.y;
        vector3d.z = point3d5.z - point3d4.z;
        vector3d2.x = point3d6.x - point3d4.x;
        vector3d2.y = point3d6.y - point3d4.y;
        vector3d2.z = point3d6.z - point3d4.z;
        vector3d4.cross(vector3d, vector3d2);
        if (vector3d4.length() == 0.0) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            return false;
        }
        vector3d5.set((Tuple3d)point3d4);
        double d13 = -vector3d4.dot(vector3d5);
        vector3d5.set((Tuple3d)point3d);
        double d14 = vector3d4.dot(vector3d5) + d13;
        vector3d5.set((Tuple3d)point3d2);
        double d15 = vector3d4.dot(vector3d5) + d13;
        vector3d5.set((Tuple3d)point3d3);
        double d16 = vector3d4.dot(vector3d5) + d13;
        if (Math.abs(d14) < 1.0E-13) {
            d14 = 0.0;
        }
        if (Math.abs(d15) < 1.0E-13) {
            d15 = 0.0;
        }
        if (Math.abs(d16) < 1.0E-13) {
            d16 = 0.0;
        }
        double d17 = d14 * d15;
        double d18 = d14 * d16;
        if (d17 > 0.0 && d18 > 0.0) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            return false;
        }
        vector3d5.cross(vector3d3, vector3d4);
        double d19 = Math.abs(vector3d5.x);
        int n = 0;
        double d20 = Math.abs(vector3d5.y);
        double d21 = Math.abs(vector3d5.z);
        if (d20 > d19) {
            d19 = d20;
            n = 1;
        }
        if (d21 > d19) {
            d19 = d21;
            n = 2;
        }
        switch (n) {
            case 0: {
                d = point3d.x;
                d2 = point3d2.x;
                d3 = point3d3.x;
                d4 = point3d4.x;
                d5 = point3d5.x;
                d6 = point3d6.x;
                break;
            }
            case 1: {
                d = point3d.y;
                d2 = point3d2.y;
                d3 = point3d3.y;
                d4 = point3d4.y;
                d5 = point3d5.y;
                d6 = point3d6.y;
                break;
            }
            case 2: {
                d = point3d.z;
                d2 = point3d2.z;
                d3 = point3d3.z;
                d4 = point3d4.z;
                d5 = point3d5.z;
                d6 = point3d6.z;
            }
        }
        double d22 = 0.0;
        double d23 = 0.0;
        double d24 = 0.0;
        double d25 = 0.0;
        double d26 = 0.0;
        if (d17 > 0.0) {
            d22 = d3;
            d23 = (d - d3) * d16;
            d24 = (d2 - d3) * d16;
            d25 = d16 - d14;
            d26 = d16 - d15;
        } else if (d18 > 0.0) {
            d22 = d2;
            d23 = (d - d2) * d15;
            d24 = (d3 - d2) * d15;
            d25 = d15 - d14;
            d26 = d15 - d16;
        } else if (d15 * d16 > 0.0 || d14 != 0.0) {
            d22 = d;
            d23 = (d2 - d) * d14;
            d24 = (d3 - d) * d14;
            d25 = d14 - d15;
            d26 = d14 - d16;
        } else if (d15 != 0.0) {
            d22 = d2;
            d23 = (d - d2) * d15;
            d24 = (d3 - d2) * d15;
            d25 = d15 - d14;
            d26 = d15 - d16;
        } else if (d16 != 0.0) {
            d22 = d3;
            d23 = (d - d3) * d16;
            d24 = (d2 - d3) * d16;
            d25 = d16 - d14;
            d26 = d16 - d15;
        } else {
            boolean bl = this.coplanarTriTri(vector3d3, point3d, point3d2, point3d3, point3d4, point3d5, point3d6);
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            return bl;
        }
        double d27 = 0.0;
        double d28 = 0.0;
        double d29 = 0.0;
        double d30 = 0.0;
        double d31 = 0.0;
        if (d11 > 0.0) {
            d27 = d6;
            d28 = (d4 - d6) * d10;
            d29 = (d5 - d6) * d10;
            d30 = d10 - d8;
            d31 = d10 - d9;
        } else if (d12 > 0.0) {
            d27 = d5;
            d28 = (d4 - d5) * d9;
            d29 = (d6 - d5) * d9;
            d30 = d9 - d8;
            d31 = d9 - d10;
        } else if (d9 * d10 > 0.0 || d8 != 0.0) {
            d27 = d4;
            d28 = (d5 - d4) * d8;
            d29 = (d6 - d4) * d8;
            d30 = d8 - d9;
            d31 = d8 - d10;
        } else if (d9 != 0.0) {
            d27 = d5;
            d28 = (d4 - d5) * d9;
            d29 = (d6 - d5) * d9;
            d30 = d9 - d8;
            d31 = d9 - d10;
        } else if (d10 != 0.0) {
            d27 = d6;
            d28 = (d4 - d6) * d10;
            d29 = (d5 - d6) * d10;
            d30 = d10 - d8;
            d31 = d10 - d9;
        } else {
            boolean bl = this.coplanarTriTri(vector3d4, point3d, point3d2, point3d3, point3d4, point3d5, point3d6);
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            return bl;
        }
        double d32 = d25 * d26;
        double d33 = d30 * d31;
        double d34 = d32 * d33;
        double d35 = d22 * d34;
        double d36 = d35 + d23 * d26 * d33;
        double d37 = d35 + d24 * d25 * d33;
        d35 = d27 * d34;
        double d38 = d35 + d28 * d31 * d32;
        double d39 = d35 + d29 * d30 * d32;
        if (d36 > d37) {
            d35 = d36;
            d36 = d37;
            d37 = d35;
        }
        if (d38 > d39) {
            d35 = d38;
            d38 = d39;
            d39 = d35;
        }
        if (d37 < d38 || d39 < d36) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            return false;
        }
        this.freeVector3d(vector3d);
        this.freeVector3d(vector3d2);
        this.freeVector3d(vector3d3);
        this.freeVector3d(vector3d4);
        this.freeVector3d(vector3d5);
        return true;
    }

    boolean intersectPolygon(Point3d[] point3dArray, Point3d[] point3dArray2) {
        Vector3d vector3d = this.getVector3d();
        Vector3d vector3d2 = this.getVector3d();
        Vector3d vector3d3 = this.getVector3d();
        int n = 0;
        while (n < point3dArray.length - 1) {
            vector3d.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            return false;
        }
        n2 = 0;
        Point3d[] point3dArray3 = new Point3d[]{this.getPoint3d(), this.getPoint3d()};
        n = 0;
        while (n < point3dArray2.length) {
            boolean bl = n < point3dArray2.length - 1 ? this.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n], point3dArray2[n + 1], point3dArray3[n2]) : this.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n], point3dArray2[0], point3dArray3[n2]);
            if (bl && ++n2 > 1) break;
            ++n;
        }
        if (n2 == 0) {
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freePoint3d(point3dArray3[0]);
            this.freePoint3d(point3dArray3[1]);
            return false;
        }
        if (point3dArray2.length < 3) {
            boolean bl = this.pointIntersectPolygon2D(vector3d3, point3dArray, point3dArray3[0]);
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freePoint3d(point3dArray3[0]);
            this.freePoint3d(point3dArray3[1]);
            return bl;
        }
        boolean bl = this.edgeIntersectPolygon2D(vector3d3, point3dArray, point3dArray3);
        this.freeVector3d(vector3d);
        this.freeVector3d(vector3d2);
        this.freeVector3d(vector3d3);
        this.freePoint3d(point3dArray3[0]);
        this.freePoint3d(point3dArray3[1]);
        return bl;
    }

    boolean intersectRay(Point3d[] point3dArray, PickRay pickRay, double[] dArray, Point3d point3d) {
        return this.intersectRayOrSegment(point3dArray, pickRay.direction, pickRay.origin, dArray, point3d, false);
    }

    boolean intersectSegment(Point3d[] point3dArray, Point3d point3d, Point3d point3d2, double[] dArray, Point3d point3d3) {
        Vector3d vector3d = this.getVector3d();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        boolean bl = this.intersectRayOrSegment(point3dArray, vector3d, point3d, dArray, point3d3, true);
        this.freeVector3d(vector3d);
        return bl;
    }

    boolean intersectRayOrSegment(Point3d[] point3dArray, Vector3d vector3d, Point3d point3d, double[] dArray, Point3d point3d2, boolean bl) {
        Vector3d vector3d2 = this.getVector3d();
        Vector3d vector3d3 = this.getVector3d();
        Vector3d vector3d4 = this.getVector3d();
        double d = 0.0;
        double d2 = 0.0;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < point3dArray.length) {
            n2 = n3 != point3dArray.length - 1 ? n3 + 1 : 0;
            vector3d2.x = point3dArray[n2].x - point3dArray[n3].x;
            vector3d2.y = point3dArray[n2].y - point3dArray[n3].y;
            vector3d2.z = point3dArray[n2].z - point3dArray[n3].z;
            if (vector3d2.length() > 0.0) break;
            ++n3;
        }
        int n4 = n2;
        while (n4 < point3dArray.length) {
            n = n4 != point3dArray.length - 1 ? n4 + 1 : 0;
            vector3d3.x = point3dArray[n].x - point3dArray[n4].x;
            vector3d3.y = point3dArray[n].y - point3dArray[n4].y;
            vector3d3.z = point3dArray[n].z - point3dArray[n4].z;
            if (vector3d3.length() > 0.0) break;
            ++n4;
        }
        vector3d4.cross(vector3d2, vector3d3);
        if (vector3d3.length() == 0.0 || vector3d4.length() == 0.0) {
            n = n2 == 0 ? point3dArray.length - 1 : n2 - 1;
            bl2 = this.intersectLineAndRay(point3dArray[n2], point3dArray[n], point3d, vector3d, dArray, point3d2);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            return bl2;
        }
        d2 = vector3d4.dot(vector3d);
        if (d2 == 0.0) {
            n3 = 0;
            while (n3 < point3dArray.length) {
                n = n3 != point3dArray.length - 1 ? n3 + 1 : 0;
                if (this.intersectLineAndRay(point3dArray[n3], point3dArray[n], point3d, vector3d, dArray, point3d2)) {
                    bl2 = true;
                    break;
                }
                ++n3;
            }
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            return bl2;
        }
        Vector3d vector3d5 = this.getVector3d();
        vector3d5.set((Tuple3d)point3dArray[0]);
        d = vector3d4.dot(vector3d5);
        vector3d5.set((Tuple3d)point3d);
        dArray[0] = (d - vector3d4.dot(vector3d5)) / d2;
        if (dArray[0] < -1.0E-13 || bl && dArray[0] > 1.0000000000001) {
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d3);
            this.freeVector3d(vector3d4);
            this.freeVector3d(vector3d5);
            return false;
        }
        if (point3d2 == null) {
            point3d2 = new Point3d();
        }
        point3d2.x = point3d.x + vector3d.x * dArray[0];
        point3d2.y = point3d.y + vector3d.y * dArray[0];
        point3d2.z = point3d.z + vector3d.z * dArray[0];
        double d3 = Math.abs(vector3d4.x);
        double d4 = Math.abs(vector3d4.y);
        double d5 = Math.abs(vector3d4.z);
        double d6 = 0.0;
        Point3d point3d3 = point3dArray[point3dArray.length - 1];
        Point3d point3d4 = point3dArray[0];
        bl2 = true;
        if (d3 > d4) {
            if (d3 < d5) {
                n3 = 0;
                while (n3 < point3dArray.length) {
                    point3d3 = point3dArray[n3];
                    point3d4 = n3 != point3dArray.length - 1 ? point3dArray[n3 + 1] : point3dArray[0];
                    double d7 = (point3d2.y - point3d3.y) * (point3d4.x - point3d3.x) - (point3d2.x - point3d3.x) * (point3d4.y - point3d3.y);
                    if (GeometryArrayRetained.isNonZero(d7)) {
                        if (d7 * d6 < 0.0) {
                            bl2 = false;
                            break;
                        }
                        d6 = d7;
                    } else {
                        double d8 = point3d4.y - point3d3.y;
                        if (GeometryArrayRetained.isNonZero(d8)) {
                            bl2 = (d8 = (point3d2.y - point3d3.y) / d8) > -1.0E-13 && d8 < 1.0000000000001;
                            break;
                        }
                        d8 = point3d4.x - point3d3.x;
                        if (GeometryArrayRetained.isNonZero(d8)) {
                            bl2 = (d8 = (point3d2.x - point3d3.x) / d8) > -1.0E-13 && d8 < 1.0000000000001;
                            break;
                        }
                        d6 = 0.0;
                    }
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < point3dArray.length) {
                    point3d3 = point3dArray[n3];
                    point3d4 = n3 != point3dArray.length - 1 ? point3dArray[n3 + 1] : point3dArray[0];
                    double d9 = (point3d2.y - point3d3.y) * (point3d4.z - point3d3.z) - (point3d2.z - point3d3.z) * (point3d4.y - point3d3.y);
                    if (GeometryArrayRetained.isNonZero(d9)) {
                        if (d9 * d6 < 0.0) {
                            bl2 = false;
                            break;
                        }
                        d6 = d9;
                    } else {
                        double d10 = point3d4.y - point3d3.y;
                        if (GeometryArrayRetained.isNonZero(d10)) {
                            bl2 = (d10 = (point3d2.y - point3d3.y) / d10) > -1.0E-13 && d10 < 1.0000000000001;
                            break;
                        }
                        d10 = point3d4.z - point3d3.z;
                        if (GeometryArrayRetained.isNonZero(d10)) {
                            bl2 = (d10 = (point3d2.z - point3d3.z) / d10) > -1.0E-13 && d10 < 1.0000000000001;
                            break;
                        }
                        d6 = 0.0;
                    }
                    ++n3;
                }
            }
        } else if (d4 < d5) {
            n3 = 0;
            while (n3 < point3dArray.length) {
                point3d3 = point3dArray[n3];
                point3d4 = n3 != point3dArray.length - 1 ? point3dArray[n3 + 1] : point3dArray[0];
                double d11 = (point3d2.y - point3d3.y) * (point3d4.x - point3d3.x) - (point3d2.x - point3d3.x) * (point3d4.y - point3d3.y);
                if (GeometryArrayRetained.isNonZero(d11)) {
                    if (d11 * d6 < 0.0) {
                        bl2 = false;
                        break;
                    }
                    d6 = d11;
                } else {
                    double d12 = point3d4.y - point3d3.y;
                    if (GeometryArrayRetained.isNonZero(d12)) {
                        bl2 = (d12 = (point3d2.y - point3d3.y) / d12) > -1.0E-13 && d12 < 1.0000000000001;
                        break;
                    }
                    d12 = point3d4.x - point3d3.x;
                    if (GeometryArrayRetained.isNonZero(d12)) {
                        bl2 = (d12 = (point3d2.x - point3d3.x) / d12) > -1.0E-13 && d12 < 1.0000000000001;
                        break;
                    }
                    d6 = 0.0;
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < point3dArray.length) {
                point3d3 = point3dArray[n3];
                point3d4 = n3 != point3dArray.length - 1 ? point3dArray[n3 + 1] : point3dArray[0];
                double d13 = (point3d2.x - point3d3.x) * (point3d4.z - point3d3.z) - (point3d2.z - point3d3.z) * (point3d4.x - point3d3.x);
                if (GeometryArrayRetained.isNonZero(d13)) {
                    if (d13 * d6 < 0.0) {
                        bl2 = false;
                        break;
                    }
                    d6 = d13;
                } else {
                    double d14 = point3d4.x - point3d3.x;
                    if (GeometryArrayRetained.isNonZero(d14)) {
                        bl2 = (d14 = (point3d2.x - point3d3.x) / d14) > -1.0E-13 && d14 < 1.0000000000001;
                        break;
                    }
                    d14 = point3d4.z - point3d3.z;
                    if (GeometryArrayRetained.isNonZero(d14)) {
                        bl2 = (d14 = (point3d2.z - point3d3.z) / d14) > -1.0E-13 && d14 < 1.0000000000001;
                        break;
                    }
                    d6 = 0.0;
                }
                ++n3;
            }
        }
        if (bl2) {
            dArray[0] = dArray[0] * vector3d.length();
        }
        this.freeVector3d(vector3d2);
        this.freeVector3d(vector3d3);
        this.freeVector3d(vector3d4);
        this.freeVector3d(vector3d5);
        return bl2;
    }

    static final boolean isNonZero(double d) {
        return d > 1.0E-13 || d < -1.0E-13;
    }

    boolean inside(Point3d[] point3dArray, PickPoint pickPoint, int n) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d.z = point3dArray[n2 + 1].z - point3dArray[n2++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n3 = n2;
        while (n3 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
            vector3d2.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
            vector3d2.z = point3dArray[n3 + 1].z - point3dArray[n3].z;
            if (vector3d2.length() > 0.0) break;
            ++n3;
        }
        if (n3 == point3dArray.length - 1) {
            return false;
        }
        if (n == 1) {
            vector3d3.cross(vector3d, vector3d2);
        } else {
            vector3d3.cross(vector3d2, vector3d);
        }
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        vector3d4.set((Tuple3d)pickPoint.location);
        return d - vector3d3.dot(vector3d4) <= 0.0;
    }

    boolean intersectPntAndPnt(Point3d point3d, Point3d point3d2) {
        return point3d.x == point3d2.x && point3d.y == point3d2.y && point3d.z == point3d2.z;
    }

    boolean intersectPntAndRay(Point3d point3d, Point3d point3d2, Vector3d vector3d, double[] dArray) {
        double d;
        int n = 0;
        if (vector3d.x != 0.0) {
            n = 0;
            dArray[0] = (point3d.x - point3d2.x) / vector3d.x;
        } else if (vector3d.y != 0.0) {
            if (point3d.x != point3d2.x) {
                return false;
            }
            n = 1;
            dArray[0] = (point3d.y - point3d2.y) / vector3d.y;
        } else if (vector3d.z != 0.0) {
            if (point3d.x != point3d2.x || point3d.y != point3d2.y) {
                return false;
            }
            n = 2;
            dArray[0] = (point3d.z - point3d2.z) / vector3d.z;
        } else {
            return false;
        }
        if (dArray[0] < 0.0) {
            return false;
        }
        if (n == 0 && (point3d.y < (d = point3d2.y + dArray[0] * vector3d.y) - 1.0E-13 || point3d.y > d + 1.0E-13)) {
            return false;
        }
        return n >= 2 || !(point3d.z < (d = point3d2.z + dArray[0] * vector3d.z) - 1.0E-13) && !(point3d.z > d + 1.0E-13);
    }

    boolean intersectLineAndRay(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, double[] dArray, Point3d point3d4) {
        Vector3d vector3d2 = this.getVector3d();
        vector3d2.x = point3d2.x - point3d.x;
        vector3d2.y = point3d2.y - point3d.y;
        vector3d2.z = point3d2.z - point3d.z;
        double d = vector3d2.x;
        double d2 = -vector3d.y;
        double d3 = vector3d2.y;
        double d4 = -vector3d.x;
        double d5 = d * d2 - d3 * d4;
        if (d5 == 0.0) {
            boolean bl = false;
            if (vector3d2.x == 0.0 && vector3d2.y == 0.0 && vector3d2.z == 0.0 && (bl = this.intersectPntAndRay(point3d, point3d3, vector3d, dArray)) && point3d4 != null) {
                point3d4.set((Tuple3d)point3d);
            }
            this.freeVector3d(vector3d2);
            return bl;
        }
        double d6 = 1.0 / d5;
        double d7 = d6 * d2;
        double d8 = d6 * -d4;
        double d9 = d6 * -d3;
        double d10 = d6 * d;
        d6 = point3d3.x - point3d.x;
        double d11 = point3d3.y - point3d.y;
        double d12 = d7 * d6 + d8 * d11;
        double d13 = d9 * d6 + d10 * d11;
        if (d13 < 0.0) {
            this.freeVector3d(vector3d2);
            return false;
        }
        if (d12 < 0.0 || d12 > 1.0) {
            this.freeVector3d(vector3d2);
            return false;
        }
        d6 = point3d3.z + d13 * vector3d.z;
        d11 = point3d.z + d12 * vector3d2.z;
        if (d6 < d11 - 1.0E-13 || d6 > d11 + 1.0E-13) {
            this.freeVector3d(vector3d2);
            return false;
        }
        dArray[0] = d13;
        if (point3d4 != null) {
            point3d4.x = point3d3.x + vector3d.x * dArray[0];
            point3d4.y = point3d3.y + vector3d.y * dArray[0];
            point3d4.z = point3d3.z + vector3d.z * dArray[0];
        }
        this.freeVector3d(vector3d2);
        return true;
    }

    boolean intersectCylinder(Point3d[] point3dArray, PickCylinder pickCylinder, double[] dArray, Point3d point3d) {
        Point3d point3d2 = this.getPoint3d();
        Point3d point3d3 = this.getPoint3d();
        Vector3d vector3d = this.getVector3d();
        Point3d point3d4 = this.getPoint3d();
        Vector3d vector3d2 = this.getVector3d();
        if (point3d == null) {
            point3d = new Point3d();
        }
        pickCylinder.getOrigin(point3d2);
        pickCylinder.getDirection(vector3d);
        double d = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d3);
        }
        if (point3dArray.length > 2) {
            if (pickCylinder instanceof PickCylinderRay) {
                if (this.intersectRay(point3dArray, new PickRay(point3d2, vector3d), dArray, point3d)) {
                    this.freePoint3d(point3d2);
                    this.freePoint3d(point3d3);
                    this.freeVector3d(vector3d);
                    this.freeVector3d(vector3d2);
                    this.freePoint3d(point3d4);
                    return true;
                }
            } else if (this.intersectSegment(point3dArray, point3d2, point3d3, dArray, point3d)) {
                this.freePoint3d(point3d2);
                this.freePoint3d(point3d3);
                this.freeVector3d(vector3d);
                this.freeVector3d(vector3d2);
                this.freePoint3d(point3d4);
                return true;
            }
        }
        int n = 0;
        while (n < point3dArray.length) {
            int n2 = n < point3dArray.length - 1 ? n + 1 : 0;
            double d2 = pickCylinder instanceof PickCylinderSegment ? Distance.segmentToSegment((Point3d)point3d2, (Point3d)point3d3, (Point3d)point3dArray[n], (Point3d)point3dArray[n2], (Point3d)point3d4, (Point3d)point3d, null) : Distance.rayToSegment((Point3d)point3d2, (Vector3d)vector3d, (Point3d)point3dArray[n], (Point3d)point3dArray[n2], (Point3d)point3d4, (Point3d)point3d, null);
            if (d2 <= d * d) {
                vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
                dArray[0] = vector3d2.length();
                this.freePoint3d(point3d2);
                this.freePoint3d(point3d3);
                this.freeVector3d(vector3d);
                this.freeVector3d(vector3d2);
                this.freePoint3d(point3d4);
                return true;
            }
            ++n;
        }
        this.freePoint3d(point3d2);
        this.freePoint3d(point3d3);
        this.freeVector3d(vector3d);
        this.freeVector3d(vector3d2);
        this.freePoint3d(point3d4);
        return false;
    }

    boolean intersectCone(Point3d[] point3dArray, PickCone pickCone, double[] dArray, Point3d point3d) {
        Point3d point3d2 = this.getPoint3d();
        Point3d point3d3 = this.getPoint3d();
        Vector3d vector3d = this.getVector3d();
        Vector3d vector3d2 = this.getVector3d();
        Point3d point3d4 = this.getPoint3d();
        Vector3d vector3d3 = this.getVector3d();
        if (point3d == null) {
            point3d = new Point3d();
        }
        pickCone.getOrigin(point3d2);
        pickCone.getDirection(vector3d);
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d3);
        }
        if (point3dArray.length > 2) {
            if (pickCone instanceof PickConeRay) {
                if (this.intersectRay(point3dArray, new PickRay(point3d2, vector3d), dArray, point3d)) {
                    this.freePoint3d(point3d2);
                    this.freePoint3d(point3d3);
                    this.freePoint3d(point3d4);
                    this.freeVector3d(vector3d);
                    this.freeVector3d(vector3d2);
                    this.freeVector3d(vector3d3);
                    return true;
                }
            } else if (this.intersectSegment(point3dArray, point3d2, point3d3, dArray, point3d)) {
                this.freePoint3d(point3d2);
                this.freePoint3d(point3d3);
                this.freePoint3d(point3d4);
                this.freeVector3d(vector3d);
                this.freeVector3d(vector3d2);
                this.freeVector3d(vector3d3);
                return true;
            }
        }
        int n = 0;
        int n2 = 0;
        while (n2 < point3dArray.length) {
            n = n2 < point3dArray.length - 1 ? n2 + 1 : 0;
            double d = pickCone instanceof PickConeSegment ? Distance.segmentToSegment((Point3d)point3d2, (Point3d)point3d3, (Point3d)point3dArray[n2], (Point3d)point3dArray[n], (Point3d)point3d4, (Point3d)point3d, null) : Distance.rayToSegment((Point3d)point3d2, (Vector3d)vector3d, (Point3d)point3dArray[n2], (Point3d)point3dArray[n], (Point3d)point3d4, (Point3d)point3d, null);
            vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
            double d2 = vector3d2.length();
            double d3 = Math.tan(pickCone.getSpreadAngle()) * d2;
            if (d <= d3 * d3) {
                dArray[0] = d2;
                this.freePoint3d(point3d2);
                this.freePoint3d(point3d3);
                this.freePoint3d(point3d4);
                this.freeVector3d(vector3d);
                this.freeVector3d(vector3d2);
                this.freeVector3d(vector3d3);
                return true;
            }
            ++n2;
        }
        this.freePoint3d(point3d2);
        this.freePoint3d(point3d3);
        this.freePoint3d(point3d4);
        this.freeVector3d(vector3d);
        this.freeVector3d(vector3d2);
        this.freeVector3d(vector3d3);
        return false;
    }

    boolean intersectCylinder(Point3d point3d, PickCylinder pickCylinder, double[] dArray) {
        double d;
        Point3d point3d2 = this.getPoint3d();
        Point3d point3d3 = this.getPoint3d();
        Vector3d vector3d = this.getVector3d();
        Point3d point3d4 = this.getPoint3d();
        Vector3d vector3d2 = this.getVector3d();
        pickCylinder.getOrigin(point3d2);
        pickCylinder.getDirection(vector3d);
        double d2 = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d3);
            d = Distance.pointToSegment((Point3d)point3d, (Point3d)point3d2, (Point3d)point3d3, (Point3d)point3d4, null);
        } else {
            d = Distance.pointToRay((Point3d)point3d, (Point3d)point3d2, (Vector3d)vector3d, (Point3d)point3d4, null);
        }
        if (d <= d2 * d2) {
            vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
            dArray[0] = vector3d2.length();
            this.freePoint3d(point3d2);
            this.freePoint3d(point3d3);
            this.freePoint3d(point3d4);
            this.freeVector3d(vector3d2);
            this.freeVector3d(vector3d);
            return true;
        }
        this.freePoint3d(point3d2);
        this.freePoint3d(point3d3);
        this.freePoint3d(point3d4);
        this.freeVector3d(vector3d2);
        this.freeVector3d(vector3d);
        return false;
    }

    boolean intersectCone(Point3d point3d, PickCone pickCone, double[] dArray) {
        double d;
        Point3d point3d2 = this.getPoint3d();
        Point3d point3d3 = this.getPoint3d();
        Vector3d vector3d = this.getVector3d();
        Point3d point3d4 = this.getPoint3d();
        Vector3d vector3d2 = this.getVector3d();
        pickCone.getOrigin(point3d2);
        pickCone.getDirection(vector3d);
        if (point3d4 == null) {
            point3d4 = new Point3d();
        }
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d3);
            d = Distance.pointToSegment((Point3d)point3d, (Point3d)point3d2, (Point3d)point3d3, (Point3d)point3d4, null);
        } else {
            d = Distance.pointToRay((Point3d)point3d, (Point3d)point3d2, (Vector3d)vector3d, (Point3d)point3d4, null);
        }
        vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
        double d2 = vector3d2.length();
        double d3 = Math.tan(pickCone.getSpreadAngle()) * d2;
        if (d <= d3 * d3) {
            dArray[0] = d2;
            this.freePoint3d(point3d2);
            this.freePoint3d(point3d3);
            this.freePoint3d(point3d4);
            this.freeVector3d(vector3d);
            this.freeVector3d(vector3d2);
            return true;
        }
        return false;
    }

    void setCoordRefBuffer(J3DBuffer j3DBuffer) {
        if (j3DBuffer != null) {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    if (((FloatBufferWrapper)j3DBuffer.getBufferImpl()).isDirect()) break;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray120"));
                }
                case 8: {
                    if (((DoubleBufferWrapper)j3DBuffer.getBufferImpl()).isDirect()) break;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray120"));
                }
                case 0: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray115"));
                }
                default: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
                }
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (3 * indexedGeometryArrayRetained.maxCoordIndex >= j3DBuffer.getBufferImpl().limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (j3DBuffer.getBufferImpl().limit() < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.coordRefBuffer = j3DBuffer;
        if (j3DBuffer == null) {
            this.floatBufferRefCoords = null;
            this.doubleBufferRefCoords = null;
            this.vertexType &= 0xFFFFFFFD;
            this.vertexType &= 0xFFFFFFFE;
        } else {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    this.floatBufferRefCoords = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
                    this.doubleBufferRefCoords = null;
                    this.vertexType |= 1;
                    this.vertexType &= 0xFFFFFFFD;
                    break;
                }
                case 8: {
                    this.floatBufferRefCoords = null;
                    this.doubleBufferRefCoords = (DoubleBufferWrapper)j3DBuffer.getBufferImpl();
                    this.vertexType |= 2;
                    this.vertexType &= 0xFFFFFFFE;
                    break;
                }
            }
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null) {
            if (this.source.isLive()) {
                this.processCoordsChanged(j3DBuffer == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    J3DBuffer getCoordRefBuffer() {
        return this.coordRefBuffer;
    }

    void setCoordRefFloat(float[] fArray) {
        if (fArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 1) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (3 * indexedGeometryArrayRetained.maxCoordIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (fArray.length < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.floatRefCoords = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFFFE) : (this.vertexType |= 1);
        } else {
            this.setupMirrorVertexPointer(1);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null) {
            if (this.source.isLive()) {
                this.processCoordsChanged(fArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    float[] getCoordRefFloat() {
        return this.floatRefCoords;
    }

    void setCoordRefDouble(double[] dArray) {
        if (dArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 2) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (3 * indexedGeometryArrayRetained.maxCoordIndex >= dArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (dArray.length < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.doubleRefCoords = dArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = dArray == null ? (this.vertexType &= 0xFFFFFFFD) : (this.vertexType |= 2);
        } else {
            this.setupMirrorVertexPointer(2);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null) {
            if (this.source.isLive()) {
                this.processCoordsChanged(dArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    double[] getCoordRefDouble() {
        return this.doubleRefCoords;
    }

    void setCoordRef3f(Point3f[] point3fArray) {
        if (point3fArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 4) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxCoordIndex >= point3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (point3fArray.length < this.initialCoordIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.p3fRefCoords = point3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = point3fArray == null ? (this.vertexType &= 0xFFFFFFFB) : (this.vertexType |= 4);
        } else {
            this.setupMirrorVertexPointer(4);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null) {
            if (this.source.isLive()) {
                this.processCoordsChanged(point3fArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    Point3f[] getCoordRef3f() {
        return this.p3fRefCoords;
    }

    void setCoordRef3d(Point3d[] point3dArray) {
        if (point3dArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 8) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxCoordIndex >= point3dArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (point3dArray.length < this.initialCoordIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.p3dRefCoords = point3dArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = point3dArray == null ? (this.vertexType &= 0xFFFFFFF7) : (this.vertexType |= 8);
        } else {
            this.setupMirrorVertexPointer(8);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null) {
            if (this.source.isLive()) {
                this.processCoordsChanged(point3dArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    Point3d[] getCoordRef3d() {
        return this.p3dRefCoords;
    }

    void setColorRefFloat(float[] fArray) {
        if (fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 16) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * indexedGeometryArrayRetained.maxColorIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (fArray.length < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.floatRefColors = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFFEF) : (this.vertexType |= 0x10);
        } else {
            this.setupMirrorColorPointer(16, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getColorRefFloat() {
        return this.floatRefColors;
    }

    void setColorRefBuffer(J3DBuffer j3DBuffer) {
        if (j3DBuffer != null) {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    if (((FloatBufferWrapper)j3DBuffer.getBufferImpl()).isDirect()) break;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray120"));
                }
                case 2: {
                    if (((ByteBufferWrapper)j3DBuffer.getBufferImpl()).isDirect()) break;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray120"));
                }
                case 0: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray115"));
                }
                default: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
                }
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * indexedGeometryArrayRetained.maxColorIndex >= j3DBuffer.getBufferImpl().limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (j3DBuffer.getBufferImpl().limit() < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.colorRefBuffer = j3DBuffer;
        if (j3DBuffer == null) {
            this.floatBufferRefColors = null;
            this.byteBufferRefColors = null;
        } else {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    this.floatBufferRefColors = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
                    this.byteBufferRefColors = null;
                    break;
                }
                case 2: {
                    this.byteBufferRefColors = (ByteBufferWrapper)j3DBuffer.getBufferImpl();
                    this.floatBufferRefColors = null;
                    break;
                }
            }
        }
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            if (j3DBuffer == null) {
                this.vertexType &= 0xFFFFFFEF;
                this.vertexType &= 0xFFFFFFDF;
            } else {
                switch (j3DBuffer.getBufferType()) {
                    case 7: {
                        this.vertexType |= 0x10;
                        this.vertexType &= 0xFFFFFFDF;
                        break;
                    }
                    case 2: {
                        this.vertexType |= 0x20;
                        this.vertexType &= 0xFFFFFFEF;
                        break;
                    }
                }
            }
        } else {
            this.setupMirrorColorPointer(48, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getColorRefBuffer() {
        return this.colorRefBuffer;
    }

    void setColorRefByte(byte[] byArray) {
        if (byArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 32) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * indexedGeometryArrayRetained.maxColorIndex >= byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (byArray.length < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.byteRefColors = byArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = byArray == null ? (this.vertexType &= 0xFFFFFFDF) : (this.vertexType |= 0x20);
        } else {
            this.setupMirrorColorPointer(32, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    byte[] getColorRefByte() {
        return this.byteRefColors;
    }

    void setColorRef3f(Color3f[] color3fArray) {
        if (color3fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 64) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color3fArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c3fRefColors = color3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color3fArray == null ? (this.vertexType &= 0xFFFFFFBF) : (this.vertexType |= 0x40);
        } else {
            this.setupMirrorColorPointer(64, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color3f[] getColorRef3f() {
        return this.c3fRefColors;
    }

    void setColorRef4f(Color4f[] color4fArray) {
        if (color4fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 128) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color4fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color4fArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c4fRefColors = color4fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color4fArray == null ? (this.vertexType &= 0xFFFFFF7F) : (this.vertexType |= 0x80);
        } else {
            this.setupMirrorColorPointer(128, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color4f[] getColorRef4f() {
        return this.c4fRefColors;
    }

    void setColorRef3b(Color3b[] color3bArray) {
        if (color3bArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 256) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color3bArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color3bArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c3bRefColors = color3bArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color3bArray == null ? (this.vertexType &= 0xFFFFFEFF) : (this.vertexType |= 0x100);
        } else {
            this.setupMirrorColorPointer(256, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color3b[] getColorRef3b() {
        return this.c3bRefColors;
    }

    void setColorRef4b(Color4b[] color4bArray) {
        if (color4bArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 512) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color4bArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color4bArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c4bRefColors = color4bArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color4bArray == null ? (this.vertexType &= 0xFFFFFDFF) : (this.vertexType |= 0x200);
        } else {
            this.setupMirrorColorPointer(512, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color4b[] getColorRef4b() {
        return this.c4bRefColors;
    }

    void setNormalRefFloat(float[] fArray) {
        if (fArray != null) {
            if ((this.vertexType & 0xC00) != 0 && (this.vertexType & 0xC00) != 1024) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxNormalIndex * 3 >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (fArray.length < 3 * (this.initialNormalIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        this.floatRefNormals = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFBFF) : (this.vertexType |= 0x400);
        } else {
            this.setupMirrorNormalPointer(1024);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getNormalRefFloat() {
        return this.floatRefNormals;
    }

    void setNormalRefBuffer(J3DBuffer j3DBuffer) {
        FloatBufferWrapper floatBufferWrapper = null;
        if (j3DBuffer != null) {
            if (j3DBuffer.getBufferType() != 7) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            floatBufferWrapper = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
            if (!floatBufferWrapper.isDirect()) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray120"));
            }
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxNormalIndex * 3 >= ((FloatBufferWrapper)j3DBuffer.getBufferImpl()).limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (floatBufferWrapper.limit() < 3 * (this.initialNormalIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        this.normalRefBuffer = j3DBuffer;
        if (j3DBuffer == null) {
            this.vertexType &= 0xFFFFFBFF;
            this.floatBufferRefNormals = null;
        } else {
            this.vertexType |= 0x400;
            this.floatBufferRefNormals = floatBufferWrapper;
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getNormalRefBuffer() {
        return this.normalRefBuffer;
    }

    void setNormalRef3f(Vector3f[] vector3fArray) {
        if (vector3fArray != null) {
            if ((this.vertexType & 0xC00) != 0 && (this.vertexType & 0xC00) != 2048) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxNormalIndex >= vector3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (vector3fArray.length < this.initialNormalIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        this.v3fRefNormals = vector3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = vector3fArray == null ? (this.vertexType &= 0xFFFFF7FF) : (this.vertexType |= 0x800);
        } else {
            this.setupMirrorNormalPointer(2048);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Vector3f[] getNormalRef3f() {
        return this.v3fRefNormals;
    }

    final int getColorStride() {
        return (this.vertexFormat & 8) != 0 ? 4 : 3;
    }

    final int getTexStride() {
        if ((this.vertexFormat & 0x20) != 0) {
            return 2;
        }
        if ((this.vertexFormat & 0x40) != 0) {
            return 3;
        }
        if ((this.vertexFormat & 0x400) != 0) {
            return 4;
        }
        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray121"));
    }

    void setTexCoordRefFloat(int n, float[] fArray) {
        if (fArray != null) {
            if ((this.vertexType & 0x7000) != 0 && (this.vertexType & 0x7000) != 4096) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            int n2 = this.getTexStride();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n] * n2 >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (fArray.length < n2 * (this.initialTexCoordIndex[n] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        this.refTexCoords[n] = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFEFFF) : (this.vertexType |= 0x1000);
        } else {
            this.setupMirrorTexCoordPointer(n, 4096);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getTexCoordRefFloat(int n) {
        return (float[])this.refTexCoords[n];
    }

    void setTexCoordRefBuffer(int n, J3DBuffer j3DBuffer) {
        FloatBufferWrapper floatBufferWrapper = null;
        if (j3DBuffer != null) {
            if (j3DBuffer.getBufferType() != 7) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            floatBufferWrapper = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
            int n2 = floatBufferWrapper.limit();
            if (!floatBufferWrapper.isDirect()) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray120"));
            }
            int n3 = this.getTexStride();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n] * n3 >= n2) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (n2 < n3 * (this.initialTexCoordIndex[n] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        this.refTexCoordsBuffer[n] = j3DBuffer;
        if (j3DBuffer == null) {
            this.vertexType &= 0xFFFFEFFF;
            this.refTexCoords[n] = null;
        } else {
            this.vertexType |= 0x1000;
            this.refTexCoords[n] = floatBufferWrapper.getBufferAsObject();
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getTexCoordRefBuffer(int n) {
        return (J3DBuffer)this.refTexCoordsBuffer[n];
    }

    void setTexCoordRef2f(int n, TexCoord2f[] texCoord2fArray) {
        if (texCoord2fArray != null) {
            if ((this.vertexType & 0x7000) != 0 && (this.vertexType & 0x7000) != 8192) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0x20) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n] >= texCoord2fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (texCoord2fArray.length < this.initialTexCoordIndex[n] + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        this.refTexCoords[n] = texCoord2fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = texCoord2fArray == null ? (this.vertexType &= 0xFFFFDFFF) : (this.vertexType |= 0x2000);
        } else {
            this.setupMirrorTexCoordPointer(8192);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    TexCoord2f[] getTexCoordRef2f(int n) {
        if (this.refTexCoords != null && this.refTexCoords[n] != null && this.refTexCoords[n] instanceof TexCoord2f[]) {
            return (TexCoord2f[])this.refTexCoords[n];
        }
        return null;
    }

    void setTexCoordRef3f(int n, TexCoord3f[] texCoord3fArray) {
        if (texCoord3fArray != null) {
            if ((this.vertexType & 0x7000) != 0 && (this.vertexType & 0x7000) != 16384) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0x40) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n] >= texCoord3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (texCoord3fArray.length < this.initialTexCoordIndex[n] + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        this.refTexCoords[n] = texCoord3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = texCoord3fArray == null ? (this.vertexType &= 0xFFFFBFFF) : (this.vertexType |= 0x4000);
        } else {
            this.setupMirrorTexCoordPointer(16384);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    TexCoord3f[] getTexCoordRef3f(int n) {
        if (this.refTexCoords != null && this.refTexCoords[n] != null && this.refTexCoords[n] instanceof TexCoord3f[]) {
            return (TexCoord3f[])this.refTexCoords[n];
        }
        return null;
    }

    void setInterleavedVertices(float[] fArray) {
        if (fArray != null) {
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.stride * indexedGeometryArrayRetained.maxCoordIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    int n = 0;
                    while (n < this.texCoordSetCount) {
                        if (this.stride * indexedGeometryArrayRetained.maxTexCoordIndices[n] >= fArray.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        ++n;
                    }
                }
                if ((this.vertexFormat & 4) != 0 && this.stride * indexedGeometryArrayRetained.maxColorIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
                if ((this.vertexFormat & 2) != 0 && this.stride * indexedGeometryArrayRetained.maxNormalIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (fArray.length < this.stride * (this.initialVertexIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0xF;
        this.colorChanged = 65535;
        this.interLeavedVertexData = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.setupMirrorInterleavedColorPointer(false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged(fArray == null);
            this.sendDataChangedMessage(true);
        }
    }

    void setInterleavedVertexBuffer(J3DBuffer j3DBuffer) {
        FloatBufferWrapper floatBufferWrapper = null;
        if (j3DBuffer != null) {
            if (j3DBuffer.getBufferType() != 7) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            floatBufferWrapper = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
            if (!floatBufferWrapper.isDirect()) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray120"));
            }
            int n = floatBufferWrapper.limit();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.stride * indexedGeometryArrayRetained.maxCoordIndex >= n) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    int n2 = 0;
                    while (n2 < this.texCoordSetCount) {
                        if (this.stride * indexedGeometryArrayRetained.maxTexCoordIndices[n2] >= n) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        ++n2;
                    }
                }
                if ((this.vertexFormat & 4) != 0 && this.stride * indexedGeometryArrayRetained.maxColorIndex >= n) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
                if ((this.vertexFormat & 2) != 0 && this.stride * indexedGeometryArrayRetained.maxNormalIndex >= n) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (n < this.stride * (this.initialVertexIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0xF;
        this.colorChanged = 65535;
        this.interleavedVertexBuffer = j3DBuffer;
        this.interleavedFloatBufferImpl = j3DBuffer == null ? null : floatBufferWrapper;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.setupMirrorInterleavedColorPointer(false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged(j3DBuffer == null);
            this.sendDataChangedMessage(true);
        }
    }

    float[] getInterleavedVertices() {
        return this.interLeavedVertexData;
    }

    J3DBuffer getInterleavedVertexBuffer() {
        return this.interleavedVertexBuffer;
    }

    void setValidVertexCount(int n) {
        int n2;
        boolean bl = false;
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray110"));
        }
        if (this.initialVertexIndex + n > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray100"));
        }
        if (this.initialCoordIndex + n > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray104"));
        }
        if (this.initialColorIndex + n > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray101"));
        }
        if (this.initialNormalIndex + n > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray102"));
        }
        if ((this.vertexFormat & (0x80 | this.vertexFormat & 0x100)) == 128 && (this.vertexFormat & 0x460) != 0) {
            n2 = 0;
            while (n2 < this.texCoordSetCount) {
                if (this.initialTexCoordIndex[n2] + n > this.vertexCount) {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray103"));
                }
                ++n2;
            }
        }
        if ((this.vertexFormat & 0x100) != 0) {
            if ((this.vertexFormat & 0x800) != 0 && this.interleavedFloatBufferImpl != null) {
                if (this.interleavedFloatBufferImpl.limit() < this.stride * (this.initialVertexIndex + n)) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
                }
            } else if (this.interLeavedVertexData != null) {
                if (this.interLeavedVertexData.length < this.stride * (this.initialVertexIndex + n)) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
                }
            } else {
                bl = true;
            }
        } else if ((this.vertexFormat & 0x80) != 0) {
            if ((this.vertexType & 0xF) == 0) {
                bl = true;
            }
            if ((this.vertexFormat & 0x800) != 0) {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatBufferRefCoords.limit() >= 3 * (this.initialCoordIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 2: {
                        if (this.doubleBufferRefCoords.limit() >= 3 * (this.initialCoordIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                }
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.floatBufferRefColors.limit() < 3 * (this.initialColorIndex + n) : (this.vertexFormat & 0xC) == 12 && this.floatBufferRefColors.limit() < 4 * (this.initialColorIndex + n))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 32: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.byteBufferRefColors.limit() < 3 * (this.initialColorIndex + n) : (this.vertexFormat & 0xC) == 12 && this.byteBufferRefColors.limit() < 4 * (this.initialColorIndex + n))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                }
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        int n3 = 0;
                        while (n3 < this.texCoordSetCount) {
                            FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)this.refTexCoordsBuffer[n3]).getBufferImpl();
                            if ((this.vertexFormat & 0x20) != 0 ? floatBufferWrapper.limit() < 2 * (this.initialTexCoordIndex[n3] + n) : ((this.vertexFormat & 0x40) != 0 ? floatBufferWrapper.limit() < 3 * (this.initialTexCoordIndex[n3] + n) : (this.vertexFormat & 0x400) != 0 && floatBufferWrapper.limit() < 4 * (this.initialTexCoordIndex[n3] + n))) {
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                            }
                            ++n3;
                        }
                        break;
                    }
                }
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatBufferRefNormals.limit() >= 3 * (this.initialNormalIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                }
            } else {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatRefCoords.length >= 3 * (this.initialCoordIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 2: {
                        if (this.doubleRefCoords.length >= 3 * (this.initialCoordIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 4: {
                        if (this.p3fRefCoords.length >= this.initialCoordIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 8: {
                        if (this.p3dRefCoords.length >= this.initialCoordIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                }
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.floatRefColors.length < 3 * (this.initialColorIndex + n) : (this.vertexFormat & 0xC) == 12 && this.floatRefColors.length < 4 * (this.initialColorIndex + n))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 32: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.byteRefColors.length < 3 * (this.initialColorIndex + n) : (this.vertexFormat & 0xC) == 12 && this.byteRefColors.length < 4 * (this.initialColorIndex + n))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 64: {
                        if (this.c3fRefColors.length >= this.initialColorIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 128: {
                        if (this.c4fRefColors.length >= this.initialColorIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 256: {
                        if (this.c3bRefColors.length >= this.initialColorIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 512: {
                        if (this.c4bRefColors.length >= this.initialColorIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                }
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        n2 = 0;
                        while (n2 < this.texCoordSetCount) {
                            if ((this.vertexFormat & 0x20) != 0) {
                                if (((float[])this.refTexCoords[n2]).length < 2 * (this.initialTexCoordIndex[n2] + n)) {
                                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                                }
                            } else if ((this.vertexFormat & 0x40) != 0) {
                                if (((float[])this.refTexCoords[n2]).length < 3 * (this.initialTexCoordIndex[n2] + n)) {
                                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                                }
                                if ((this.vertexFormat & 0x400) != 0 && ((float[])this.refTexCoords[n2]).length < 4 * (this.initialTexCoordIndex[n2] + n)) {
                                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                                }
                            }
                            ++n2;
                        }
                        break;
                    }
                    case 8192: {
                        int n4 = 0;
                        while (n4 < this.texCoordSetCount) {
                            if (((TexCoord2f[])this.refTexCoords[n4]).length < this.initialTexCoordIndex[n4] + n) {
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                            }
                            ++n4;
                        }
                        break;
                    }
                    case 16384: {
                        int n5 = 0;
                        while (n5 < this.texCoordSetCount) {
                            if (((TexCoord3f[])this.refTexCoords[n5]).length < this.initialTexCoordIndex[n5] + n) {
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                            }
                            ++n5;
                        }
                        break;
                    }
                }
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatRefNormals.length >= 3 * (this.initialNormalIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                    case 2048: {
                        if (this.v3fRefNormals.length >= this.initialNormalIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                }
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0xF;
        this.validVertexCount = n;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged(bl);
            this.sendDataChangedMessage(true);
        }
    }

    int getValidVertexCount() {
        return this.validVertexCount;
    }

    void setInitialVertexIndex(int n) {
        boolean bl = false;
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray100"));
        }
        if ((this.vertexFormat & 0x800) != 0 && this.interleavedFloatBufferImpl != null) {
            if (this.interleavedFloatBufferImpl.limit() < this.stride * (n + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        } else if (this.interLeavedVertexData != null) {
            if (this.interLeavedVertexData.length < this.stride * (n + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        } else {
            bl = (this.vertexFormat & 0x100) != 0;
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0xF;
        this.initialVertexIndex = n;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged(bl);
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialVertexIndex() {
        return this.initialVertexIndex;
    }

    void setInitialCoordIndex(int n) {
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray104"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            switch (this.vertexType & 0xF) {
                case 1: {
                    if (this.floatBufferRefCoords.limit() >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 2: {
                    if (this.doubleBufferRefCoords.limit() >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
            }
        } else {
            switch (this.vertexType & 0xF) {
                case 1: {
                    if (this.floatRefCoords.length >= 3 * (n + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 2: {
                    if (this.doubleRefCoords.length >= 3 * (n + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 4: {
                    if (this.p3fRefCoords.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 8: {
                    if (this.p3dRefCoords.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.initialCoordIndex = n;
        this.dirtyFlag |= 1;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged((this.vertexType & 0xF) == 0);
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialCoordIndex() {
        return this.initialCoordIndex;
    }

    void setInitialColorIndex(int n) {
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray101"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            switch (this.vertexType & 0x3F0) {
                case 16: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.floatBufferRefColors.limit() < 3 * (n + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.floatBufferRefColors.limit() < 4 * (n + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 32: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.byteBufferRefColors.limit() < 3 * (n + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.byteBufferRefColors.limit() < 4 * (n + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
            }
        } else {
            switch (this.vertexType & 0x3F0) {
                case 16: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.floatRefColors.length < 3 * (n + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.floatRefColors.length < 4 * (n + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 32: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.byteRefColors.length < 3 * (n + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.byteRefColors.length < 4 * (n + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 64: {
                    if (this.c3fRefColors.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 128: {
                    if (this.c4fRefColors.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 256: {
                    if (this.c3bRefColors.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 512: {
                    if (this.c4bRefColors.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.initialColorIndex = n;
        this.geomLock.unLock();
    }

    int getInitialColorIndex() {
        return this.initialColorIndex;
    }

    void setInitialNormalIndex(int n) {
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray102"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexType & 0xC00) == 1024 && this.floatBufferRefNormals.limit() < 3 * (n + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        } else {
            switch (this.vertexType & 0xC00) {
                case 1024: {
                    if (this.floatRefNormals.length >= 3 * (n + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                }
                case 2048: {
                    if (this.v3fRefNormals.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                }
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        this.initialNormalIndex = n;
        this.geomLock.unLock();
    }

    int getInitialNormalIndex() {
        return this.initialNormalIndex;
    }

    void setInitialTexCoordIndex(int n, int n2) {
        if (n2 + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray103"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexType & 0x7000) == 4096) {
                FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)this.refTexCoordsBuffer[n]).getBufferImpl();
                if ((this.vertexFormat & 0x20) != 0 ? floatBufferWrapper.limit() < 2 * (n2 + this.validVertexCount) : ((this.vertexFormat & 0x40) != 0 ? floatBufferWrapper.limit() < 3 * (n2 + this.validVertexCount) : (this.vertexFormat & 0x400) != 0 && floatBufferWrapper.limit() < 4 * (n2 + this.validVertexCount))) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
            }
        } else {
            switch (this.vertexType & 0x7000) {
                case 4096: {
                    if (!((this.vertexFormat & 0x20) != 0 ? ((float[])this.refTexCoords[n]).length < 2 * (n2 + this.validVertexCount) : ((this.vertexFormat & 0x40) != 0 ? ((float[])this.refTexCoords[n]).length < 3 * (n2 + this.validVertexCount) : (this.vertexFormat & 0x400) != 0 && ((float[])this.refTexCoords[n]).length < 4 * (n2 + this.validVertexCount)))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
                case 8192: {
                    if (((TexCoord2f[])this.refTexCoords[n]).length >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
                case 16384: {
                    if (((TexCoord3f[])this.refTexCoords[n]).length >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        this.initialTexCoordIndex[n] = n2;
        this.geomLock.unLock();
    }

    int getInitialTexCoordIndex(int n) {
        return this.initialTexCoordIndex[n];
    }

    int getTexCoordSetCount() {
        return this.texCoordSetCount;
    }

    int getTexCoordSetMapLength() {
        if (this.texCoordSetMap != null) {
            return this.texCoordSetMap.length;
        }
        return 0;
    }

    void getTexCoordSetMap(int[] nArray) {
        if (this.texCoordSetMap != null) {
            int n = 0;
            while (n < this.texCoordSetMap.length) {
                nArray[n] = this.texCoordSetMap[n];
                ++n;
            }
        }
    }

    protected void finalize() {
        if (this.pVertexBuffers != 0L) {
            this.freeD3DArray(true);
        }
    }

    void freeDlistId() {
        if (this.dlistId != -1) {
            VirtualUniverse.mc.freeDisplayListId(this.dlistObj);
            this.dlistId = -1;
        }
    }

    void assignDlistId() {
        if (this.dlistId == -1) {
            this.dlistObj = VirtualUniverse.mc.getDisplayListId();
            this.dlistId = this.dlistObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrDlistRefCount(int n) {
        int n2 = this.getIndex(n);
        int[] nArray = null;
        int[] nArray2 = this.renderMolPerDlist;
        synchronized (nArray2) {
            if (n2 >= this.renderMolPerDlist.length) {
                nArray = new int[n2 * 2];
                int n3 = 0;
                while (n3 < this.renderMolPerDlist.length) {
                    nArray[n3] = this.renderMolPerDlist[n3];
                    ++n3;
                }
                nArray[n2] = 1;
                this.renderMolPerDlist = nArray;
            } else {
                int n4 = n2;
                this.renderMolPerDlist[n4] = this.renderMolPerDlist[n4] + 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int decrDlistRefCount(int n) {
        int n2 = this.getIndex(n);
        int[] nArray = this.renderMolPerDlist;
        synchronized (nArray) {
            block4: {
                if (n2 < this.renderMolPerDlist.length) break block4;
                int n3 = -1;
                return n3;
            }
            int n4 = n2;
            this.renderMolPerDlist[n4] = this.renderMolPerDlist[n4] - 1;
            int n5 = this.renderMolPerDlist[n2];
            return n5;
        }
    }

    void setDlistTimeStamp(int n, long l) {
        int n2 = this.getIndex(n);
        if (n2 >= this.timeStampPerDlist.length) {
            long[] lArray = new long[n2 * 2];
            int n3 = 0;
            while (n3 < this.timeStampPerDlist.length) {
                lArray[n3] = this.timeStampPerDlist[n3];
                ++n3;
            }
            this.timeStampPerDlist = lArray;
        }
        this.timeStampPerDlist[n2] = l;
    }

    long getDlistTimeStamp(int n) {
        int n2 = this.getIndex(n);
        if (n2 >= this.timeStampPerDlist.length) {
            this.setDlistTimeStamp(n, 0L);
        }
        return this.timeStampPerDlist[n2];
    }

    int getIndex(int n) {
        int n2 = 0;
        while (n > 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }

    boolean isWriteStatic() {
        return !this.source.getCapability(1) && !this.source.getCapability(3) && !this.source.getCapability(5) && !this.source.getCapability(7) && !this.source.getCapability(20) && !this.source.getCapability(19);
    }

    void setCompiled(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        this.geoOffset = new int[n];
        this.compileVcount = new int[n];
        int n3 = 0;
        int n4 = 0;
        n3 = 0;
        this.isCompiled = true;
        if (n > 0) {
            this.source = ((SceneGraphObjectRetained)arrayList.get((int)0)).source;
        }
        int n5 = 0;
        while (n5 < n) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)arrayList.get(n5);
            ((GeometryArray)geometryArrayRetained.source).retained = this;
            this.compileVcount[n5] = geometryArrayRetained.getValidVertexCount();
            n3 += geometryArrayRetained.getValidVertexCount();
            this.geoOffset[n5] = n2;
            n2 += geometryArrayRetained.stride() * this.compileVcount[n5];
            n4 = geometryArrayRetained.getVertexFormat();
            ++n5;
        }
        this.createGeometryArrayData(n3, n4);
        this.validVertexCount = n3;
        this.initialVertexIndex = 0;
        this.mergeGeometryArrays(arrayList);
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n = 0;
        if ((this.vertexFormat & 0x460) != 0) {
            this.texCoordSetCount = 1;
            this.texCoordSetMap = new int[1];
            this.texCoordSetMap[0] = 1;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)arrayList.get(n2);
            float[] fArray = geometryArrayRetained.vertexData;
            int n3 = geometryArrayRetained.validVertexCount * this.stride;
            int n4 = geometryArrayRetained.initialVertexIndex * this.stride;
            System.arraycopy(fArray, n4, this.vertexData, n, n3);
            n += n3;
            this.geoBounds.combine(geometryArrayRetained.geoBounds);
            ++n2;
        }
        this.centroid.set((Tuple3d)this.geoBounds.getCenter());
    }

    boolean isMergeable() {
        if ((this.vertexFormat & 0x80) != 0) {
            return false;
        }
        if (!this.isStatic()) {
            return false;
        }
        if ((this.vertexFormat & 0x460) != 0 && (this.texCoordSetCount > 1 || this.texCoordSetMap != null && this.texCoordSetMap.length > 1)) {
            return false;
        }
        return !this.source.getCapability(18);
    }

    boolean isTextureGeometryMergeable(GeometryArrayRetained geometryArrayRetained) {
        if ((this.vertexFormat & 0x460) != 0) {
            if (this.texCoordSetCount != geometryArrayRetained.texCoordSetCount) {
                return false;
            }
            if (this.texCoordSetMap != null && geometryArrayRetained.texCoordSetMap != null) {
                if (this.texCoordSetMap.length != geometryArrayRetained.texCoordSetMap.length) {
                    return false;
                }
                int n = 0;
                while (n < this.texCoordSetMap.length) {
                    if (this.texCoordSetMap[n] != geometryArrayRetained.texCoordSetMap[n]) {
                        return false;
                    }
                    ++n;
                }
            } else if (this.texCoordSetMap != geometryArrayRetained.texCoordSetMap) {
                return false;
            }
        }
        return true;
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        if ((this.vertexFormat & 2) != 0) {
            compileState.needNormalsTransform = true;
        }
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        if (this.geoBounds != null) {
            this.geoBounds.transform(transformGroupRetained.transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMorphUser(MorphRetained morphRetained) {
        if (this.morphUniverseList == null) {
            this.morphUniverseList = new ArrayList(1);
            this.morphUserLists = new ArrayList(1);
        }
        ArrayList arrayList = this.morphUniverseList;
        synchronized (arrayList) {
            if (this.morphUniverseList.contains(morphRetained.universe)) {
                int n = this.morphUniverseList.indexOf(morphRetained.universe);
                ArrayList arrayList2 = (ArrayList)this.morphUserLists.get(n);
                arrayList2.add(morphRetained);
            } else {
                this.morphUniverseList.add(morphRetained.universe);
                ArrayList<MorphRetained> arrayList3 = new ArrayList<MorphRetained>(5);
                arrayList3.add(morphRetained);
                this.morphUserLists.add(arrayList3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMorphUser(MorphRetained morphRetained) {
        if (this.morphUniverseList == null) {
            return;
        }
        ArrayList arrayList = this.morphUniverseList;
        synchronized (arrayList) {
            int n = this.morphUniverseList.indexOf(morphRetained.universe);
            ArrayList arrayList2 = (ArrayList)this.morphUserLists.get(n);
            arrayList2.remove(arrayList2.indexOf(morphRetained));
            if (arrayList2.size() == 0) {
                this.morphUserLists.remove(n);
                this.morphUniverseList.remove(n);
            }
        }
    }

    void initMirrorGeometry() {
        this.geomLock.getLock();
        if (this instanceof IndexedGeometryArrayRetained) {
            this.mirrorGeometry = (this.vertexFormat & 0x200) == 0 ? (GeometryRetained)((IndexedGeometryArrayRetained)this).cloneNonIndexedGeometry() : null;
        }
        this.geomLock.unLock();
    }

    void updateMirrorGeometry() {
        this.geomLock.getLock();
        if (this instanceof IndexedGeometryArrayRetained && this.mirrorGeometry != null) {
            this.mirrorGeometry = (GeometryRetained)((IndexedGeometryArrayRetained)this).cloneNonIndexedGeometry();
        }
        this.geomLock.unLock();
    }

    void getVertexData(int n, Point3d point3d) {
        if ((this.vertexFormat & 0x80) == 0) {
            int n2 = this.stride * n + this.coordinateOffset;
            point3d.x = this.vertexData[n2];
            point3d.y = this.vertexData[n2 + 1];
            point3d.z = this.vertexData[n2 + 2];
            return;
        }
        if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                int n3 = this.stride * n + this.coordinateOffset;
                point3d.x = this.interLeavedVertexData[n3];
                point3d.y = this.interLeavedVertexData[n3 + 1];
                point3d.z = this.interLeavedVertexData[n3 + 2];
            } else {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        int n4 = n * 3;
                        point3d.x = this.floatRefCoords[n4];
                        point3d.y = this.floatRefCoords[n4 + 1];
                        point3d.z = this.floatRefCoords[n4 + 2];
                        break;
                    }
                    case 2: {
                        int n5 = n * 3;
                        point3d.x = this.doubleRefCoords[n5];
                        point3d.y = this.doubleRefCoords[n5 + 1];
                        point3d.z = this.doubleRefCoords[n5 + 2];
                        break;
                    }
                    case 4: {
                        point3d.x = this.p3fRefCoords[n].x;
                        point3d.y = this.p3fRefCoords[n].y;
                        point3d.z = this.p3fRefCoords[n].z;
                        break;
                    }
                    case 8: {
                        point3d.x = this.p3dRefCoords[n].x;
                        point3d.y = this.p3dRefCoords[n].y;
                        point3d.z = this.p3dRefCoords[n].z;
                    }
                }
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int n6 = this.stride * n + this.coordinateOffset;
            point3d.x = this.interleavedFloatBufferImpl.get(n6);
            point3d.y = this.interleavedFloatBufferImpl.get(n6 + 1);
            point3d.z = this.interleavedFloatBufferImpl.get(n6 + 2);
        } else {
            switch (this.vertexType & 0xF) {
                case 1: {
                    int n7 = n * 3;
                    point3d.x = this.floatBufferRefCoords.get(n7);
                    point3d.y = this.floatBufferRefCoords.get(n7 + 1);
                    point3d.z = this.floatBufferRefCoords.get(n7 + 2);
                    break;
                }
                case 2: {
                    int n8 = n * 3;
                    point3d.x = this.doubleBufferRefCoords.get(n8);
                    point3d.y = this.doubleBufferRefCoords.get(n8 + 1);
                    point3d.z = this.doubleBufferRefCoords.get(n8 + 2);
                }
            }
        }
    }

    void getCrossValue(Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        vector3d.x += point3d.y * point3d2.z - point3d.z * point3d2.y;
        vector3d.y += point3d2.x * point3d.z - point3d2.z * point3d.x;
        vector3d.z += point3d.x * point3d2.y - point3d.y * point3d2.x;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        Transform3D transform3D3 = VirtualUniverse.mc.getTransform3D(null);
        boolean bl = false;
        if (geometryRetained instanceof GeometryArrayRetained) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryRetained;
            if (geometryArrayRetained.validVertexCount >= this.validVertexCount) {
                transform3D3.invert(transform3D2);
                transform3D3.mul(transform3D);
                bl = this.intersect(transform3D3, geometryRetained);
            } else {
                transform3D3.invert(transform3D);
                transform3D3.mul(transform3D2);
                bl = geometryArrayRetained.intersect(transform3D3, this);
            }
        } else {
            transform3D3.invert(transform3D);
            transform3D3.mul(transform3D2);
            bl = geometryRetained.intersect(transform3D3, this);
        }
        FreeListManager.freeObject(2, transform3D3);
        return bl;
    }

    int getNumCoordCount() {
        int n = 0;
        if ((this.vertexFormat & 1) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n = this.vertexCount;
                return n;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0xF) {
                        case 1: {
                            n = this.floatRefCoords.length / 3;
                            break;
                        }
                        case 2: {
                            n = this.doubleRefCoords.length / 3;
                            break;
                        }
                        case 4: {
                            n = this.p3fRefCoords.length;
                            break;
                        }
                        case 8: {
                            n = this.p3dRefCoords.length;
                        }
                    }
                } else {
                    n = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        n = this.floatBufferRefCoords.limit() / 3;
                        break;
                    }
                    case 2: {
                        n = this.doubleBufferRefCoords.limit() / 3;
                    }
                }
            } else {
                n = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n;
    }

    int getNumColorCount() {
        int n = 0;
        if ((this.vertexFormat & 4) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n = this.vertexCount;
                return n;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0x3F0) {
                        case 16: {
                            if ((this.vertexFormat & 0xC) == 4) {
                                n = this.floatRefColors.length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0xC) != 12) break;
                            n = this.floatRefColors.length / 4;
                            break;
                        }
                        case 32: {
                            if ((this.vertexFormat & 0xC) == 4) {
                                n = this.byteRefColors.length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0xC) != 12) break;
                            n = this.byteRefColors.length / 4;
                            break;
                        }
                        case 64: {
                            n = this.c3fRefColors.length;
                            break;
                        }
                        case 128: {
                            n = this.c4fRefColors.length;
                            break;
                        }
                        case 256: {
                            n = this.c3bRefColors.length;
                            break;
                        }
                        case 512: {
                            n = this.c4bRefColors.length;
                        }
                    }
                } else {
                    n = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if ((this.vertexFormat & 0xC) == 4) {
                            n = this.floatBufferRefColors.limit() / 3;
                            break;
                        }
                        if ((this.vertexFormat & 0xC) != 12) break;
                        n = this.floatBufferRefColors.limit() / 4;
                        break;
                    }
                    case 32: {
                        if ((this.vertexFormat & 0xC) == 4) {
                            n = this.byteBufferRefColors.limit() / 3;
                            break;
                        }
                        if ((this.vertexFormat & 0xC) != 12) break;
                        n = this.byteBufferRefColors.limit() / 4;
                    }
                }
            } else {
                n = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n;
    }

    int getNumNormalCount() {
        int n = 0;
        if ((this.vertexFormat & 2) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n = this.vertexCount;
                return n;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0xC00) {
                        case 1024: {
                            n = this.floatRefNormals.length / 3;
                            break;
                        }
                        case 2048: {
                            n = this.v3fRefNormals.length;
                        }
                    }
                } else {
                    n = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                if ((this.vertexType & 0xC00) == 1024) {
                    n = this.floatBufferRefNormals.limit() / 3;
                }
            } else {
                n = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n;
    }

    int getNumTexCoordCount(int n) {
        int n2 = 0;
        if ((this.vertexFormat & 0x460) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n2 = this.vertexCount;
                return n2;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0x7000) {
                        case 4096: {
                            if ((this.vertexFormat & 0x20) != 0) {
                                n2 = ((float[])this.refTexCoords[n]).length / 2;
                                break;
                            }
                            if ((this.vertexFormat & 0x40) != 0) {
                                n2 = ((float[])this.refTexCoords[n]).length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0x400) == 0) break;
                            n2 = ((float[])this.refTexCoords[n]).length / 4;
                            break;
                        }
                        case 8192: {
                            n2 = ((TexCoord2f[])this.refTexCoords[n]).length;
                            break;
                        }
                        case 16384: {
                            n2 = ((TexCoord3f[])this.refTexCoords[n]).length;
                        }
                    }
                } else {
                    n2 = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                if ((this.vertexType & 0x7000) == 4096) {
                    FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)this.refTexCoordsBuffer[n]).getBufferImpl();
                    if ((this.vertexFormat & 0x20) != 0) {
                        n2 = floatBufferWrapper.limit() / 2;
                    } else if ((this.vertexFormat & 0x40) != 0) {
                        n2 = floatBufferWrapper.limit() / 3;
                    } else if ((this.vertexFormat & 0x400) != 0) {
                        n2 = floatBufferWrapper.limit() / 4;
                    }
                }
            } else {
                n2 = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n2;
    }

    void computeMinDistance(Point3d[] point3dArray, Point3d point3d, Vector3d vector3d, double[] dArray, Point3d point3d2) {
        if (point3dArray.length == 1) {
            point3d2.x = point3dArray[0].x;
            point3d2.y = point3dArray[0].y;
            point3d2.z = point3dArray[0].z;
            double d = point3d2.x - point3d.x;
            double d2 = point3d2.y - point3d.y;
            double d3 = point3d2.z - point3d.z;
            dArray[0] = Math.sqrt(d * d + d2 * d2 + d3 * d3);
            return;
        }
        if (point3dArray.length == 2) {
            dArray[0] = Math.sqrt(Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[0], (Point3d)point3dArray[1], (Point3d)point3d2, null));
            return;
        }
        double d = 0.0;
        if (vector3d == null) {
            Vector3d vector3d2 = new Vector3d();
            Vector3d vector3d3 = new Vector3d();
            vector3d = new Vector3d();
            int n = 0;
            while (n < point3dArray.length - 1) {
                vector3d2.x = point3dArray[n + 1].x - point3dArray[n].x;
                vector3d2.y = point3dArray[n + 1].y - point3dArray[n].y;
                vector3d2.z = point3dArray[n + 1].z - point3dArray[n++].z;
                if (vector3d2.length() > 0.0) break;
            }
            int n2 = n;
            while (n2 < point3dArray.length - 1) {
                vector3d3.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
                vector3d3.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
                vector3d3.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
                if (vector3d3.length() > 0.0) break;
                ++n2;
            }
            if (n2 == point3dArray.length - 1) {
                vector3d = null;
            } else {
                vector3d.cross(vector3d2, vector3d3);
            }
        }
        if (vector3d != null && (d = vector3d.length()) == 0.0) {
            vector3d = null;
        }
        if (point3dArray.length == 3) {
            if (vector3d != null) {
                double d4 = -(vector3d.x * point3dArray[0].x + vector3d.y * point3dArray[0].y + vector3d.z * point3dArray[0].z);
                dArray[0] = (vector3d.x * point3d.x + vector3d.y * point3d.y + vector3d.z * point3d.z + d4) / d;
                point3d2.x = point3d.x - dArray[0] * vector3d.x / d;
                point3d2.y = point3d.y - dArray[0] * vector3d.y / d;
                point3d2.z = point3d.z - dArray[0] * vector3d.z / d;
                if (this.pointInTri(point3d2, point3dArray[0], point3dArray[1], point3dArray[2], vector3d)) {
                    return;
                }
            }
            Point3d point3d3 = new Point3d();
            dArray[0] = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[0], (Point3d)point3dArray[1], (Point3d)point3d2, null);
            double d5 = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[1], (Point3d)point3dArray[2], (Point3d)point3d3, null);
            if (d5 < dArray[0]) {
                dArray[0] = d5;
                point3d2.x = point3d3.x;
                point3d2.y = point3d3.y;
                point3d2.z = point3d3.z;
            }
            if ((d5 = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[2], (Point3d)point3dArray[0], (Point3d)point3d3, null)) < dArray[0]) {
                dArray[0] = d5;
                point3d2.x = point3d3.x;
                point3d2.y = point3d3.y;
                point3d2.z = point3d3.z;
            }
            dArray[0] = Math.sqrt(dArray[0]);
            return;
        }
        if (vector3d != null) {
            double d6 = -(vector3d.x * point3dArray[0].x + vector3d.y * point3dArray[0].y + vector3d.z * point3dArray[0].z);
            dArray[0] = (vector3d.x * point3d.x + vector3d.y * point3d.y + vector3d.z * point3d.z + d6) / d;
            point3d2.x = point3d.x - dArray[0] * vector3d.x / d;
            point3d2.y = point3d.y - dArray[0] * vector3d.y / d;
            point3d2.z = point3d.z - dArray[0] * vector3d.z / d;
            if (this.pointInTri(point3d2, point3dArray[0], point3dArray[1], point3dArray[2], vector3d) || this.pointInTri(point3d2, point3dArray[1], point3dArray[2], point3dArray[3], vector3d)) {
                return;
            }
        }
        Point3d point3d4 = new Point3d();
        dArray[0] = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[0], (Point3d)point3dArray[1], (Point3d)point3d2, null);
        double d7 = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[1], (Point3d)point3dArray[2], (Point3d)point3d4, null);
        if (d7 < dArray[0]) {
            dArray[0] = d7;
            point3d2.x = point3d4.x;
            point3d2.y = point3d4.y;
            point3d2.z = point3d4.z;
        }
        if ((d7 = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[2], (Point3d)point3dArray[3], (Point3d)point3d4, null)) < dArray[0]) {
            dArray[0] = d7;
            point3d2.x = point3d4.x;
            point3d2.y = point3d4.y;
            point3d2.z = point3d4.z;
        }
        if ((d7 = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[3], (Point3d)point3dArray[0], (Point3d)point3d4, null)) < dArray[0]) {
            dArray[0] = d7;
            point3d2.x = point3d4.x;
            point3d2.y = point3d4.y;
            point3d2.z = point3d4.z;
        }
        dArray[0] = Math.sqrt(dArray[0]);
    }

    Vector3d getVector3d() {
        return (Vector3d)FreeListManager.getObject(8);
    }

    void freeVector3d(Vector3d vector3d) {
        FreeListManager.freeObject(8, vector3d);
    }

    Point3d getPoint3d() {
        return (Point3d)FreeListManager.getObject(9);
    }

    void freePoint3d(Point3d point3d) {
        FreeListManager.freeObject(9, point3d);
    }

    void handleFrequencyChange(int n) {
        int n2 = 0;
        if ((this.vertexFormat & 0x80) == 0) {
            if (n == 1 || (this.vertexFormat & 4) != 0 && n == 3 || (this.vertexFormat & 2) != 0 && n == 5 || (this.vertexFormat & 0x460) != 0 && n == 7 || n == 20) {
                n2 = 1;
            }
        } else if (n == 19) {
            n2 = 1;
        }
        if (n2 != 0) {
            this.setFrequencyChangeMask(n, n2);
        }
    }
}

