//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns.visitors.contains;

import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.MOUSE_CLICK;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter.TEXT_INPUT;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.SELECTION;
import static de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTypeFilter.SEQUENCE;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.rules.patterns.InteractionPattern;
import de.ugoe.cs.autoquest.usability.rules.patterns.InteractionPatternBuilder;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskModelUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class ContainsAndEndsWithEventTest {

	 @Test
    public void contains_and_ends_with_event_positive() {
        // Given
        String spec = "UserSession {" +
                      "  Sequence seq1 {" + 
                      "    TextInput t1 {}" +
                      "  }" + 
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        InteractionPattern pattern = new InteractionPatternBuilder().concernedNode(SEQUENCE).contains(TEXT_INPUT).endsWith(TEXT_INPUT).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    
    @Test
    public void contains_and_ends_with_event_negative() {
        // Given
        String spec = "UserSession {" +
                      "  Iteration it1 {" +
                      "    Sequence seq1 {" +
                      "      EventTask t1 {}" +
                      "      EventTask t2 {}" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        InteractionPattern pattern = new InteractionPatternBuilder().concernedNode(SELECTION).contains(TEXT_INPUT).endsWith(MOUSE_CLICK).build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }

}
