//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.guitar.eventcore;

import de.ugoe.cs.autoquest.eventcore.IEventType;

/**
 * <p>
 * Event type of GUITAR events. The types are defined by eventIds.
 * </p>
 * 
 * @version 1.0
 * @author Steffen Herbold
 */
public class GUITAREventType implements IEventType {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * GUITAR eventId of the event type.
     * </p>
     */
    String guitarEventId;

    /**
     * <p>
     * Constructor. Creates a new {@link GUITAREventType}.
     * </p>
     * 
     * @param eventId
     *            eventId of the event type
     */
    public GUITAREventType(String eventId) {
        this.guitarEventId = eventId;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IEventType#getName()
     */
    @Override
    public String getName() {
        return "GUITAREventType";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return guitarEventId;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GUITAREventType) {
            if (guitarEventId != null) {
                return guitarEventId.equals(((GUITAREventType) obj).guitarEventId);
            }
            else {
                return ((GUITAREventType) obj).guitarEventId == null;
            }
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        int hash = 37;
        if (guitarEventId != null) {
            hash = guitarEventId.hashCode();
        }
        return hash;
    }

}
