//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.testutil;

import java.util.List;
import java.util.logging.Level;

import com.google.common.collect.Lists;

import de.ugoe.cs.autoquest.commands.sequences.CMDcondenseGuiModel;
import de.ugoe.cs.autoquest.commands.sequences.CMDcondenseMouseClicks;
import de.ugoe.cs.autoquest.commands.sequences.CMDcorrectKeyInteractionTargets;
import de.ugoe.cs.autoquest.commands.sequences.CMDdetectTextInputEvents;
import de.ugoe.cs.autoquest.commands.sequences.CMDsortKeyInteractions;
import de.ugoe.cs.autoquest.commands.usability.CMDgenerateTaskTree;
import de.ugoe.cs.autoquest.plugin.jfc.commands.CMDparseJFC;
import de.ugoe.cs.autoquest.tasktrees.TaskTreeDecoder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskFactory;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceList;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskFactory;
import de.ugoe.cs.autoquest.test.CommandRunner;
import de.ugoe.cs.util.console.GlobalDataContainer;
import de.ugoe.cs.util.console.TextConsole;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class GenerateTaskModelUtil {

    private static final String seqName = "sequences";

    private static final String taskTreeName = "taskTree";
    
    public static ITaskModel getTaskModelFromSpec(String spec) {
        ITaskFactory factory = new TaskFactory();
        ITaskInstanceList taskInstances = new TaskTreeDecoder(factory, new TaskBuilder()).decode(spec);
        List<IUserSession> userSessions = Lists.newArrayList();
        userSessions.add((IUserSession) taskInstances);
        return factory.createTaskModel(userSessions);
    }
    
    public static ITaskModel getTaskTreeFromFile(String filename) {
        new TextConsole(Level.OFF);
        parseTraceFile(filename);
        condenseGuiModel();
        sortKeyInteractions();
        correctKeyInteractionTargets();
        detectTextInputEvents();
        condenseMouseClicks();
        return generateTaskModel();
    }

    static private void parseTraceFile(String filetoparse) {
        CommandRunner.runCommand(CMDparseJFC.class, ClassLoader.getSystemResource(filetoparse)
            .getFile(), seqName);
    }

    private static void condenseGuiModel() {
        CommandRunner.runCommand(CMDcondenseGuiModel.class, seqName);
    }

    private static void sortKeyInteractions() {
        CommandRunner.runCommand(CMDsortKeyInteractions.class, seqName);
    }

    private static void correctKeyInteractionTargets() {
        CommandRunner.runCommand(CMDcorrectKeyInteractionTargets.class, seqName);
    }

    private static void detectTextInputEvents() {
        CommandRunner.runCommand(CMDdetectTextInputEvents.class, seqName);
    }

    private static void condenseMouseClicks() {
        CommandRunner.runCommand(CMDcondenseMouseClicks.class, seqName);
    }

    private static ITaskModel generateTaskModel() {
        CommandRunner.runCommand(CMDgenerateTaskTree.class, seqName, taskTreeName);
        GlobalDataContainer dataContainer = GlobalDataContainer.getInstance();
        return (ITaskModel) dataContainer.getData(taskTreeName);
    }

}
