//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import java.util.List;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceList;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskFactory;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;

/**
 * <p>
 * this is the default implementation of the interface {@link ITaskFactory}. It
 * does not do anything fancy except implementing the interface. It instantiates the other
 * implementations of the tree ifc in this package.
 * </p>
 * 
 * @author Patrick Harms
 */
public class TaskFactory implements ITaskFactory {

    /* (non-Javadoc)
     * @see ITaskFactory#createNewEventTask(IEventType, IEventTarget)
     */
    @Override
    public IEventTask createNewEventTask(IEventType eventType, IEventTarget eventTarget) {
        return new EventTask(eventType, eventTarget);
    }

    /* (non-Javadoc)
     * @see ITaskFactory#createNewSequence()
     */
    @Override
    public ISequence createNewSequence() {
        return new Sequence();
    }

    /* (non-Javadoc)
     * @see ITaskFactory#createNewIteration()
     */
    @Override
    public IIteration createNewIteration() {
        return new Iteration();
    }

    /* (non-Javadoc)
     * @see ITaskFactory#createNewOptional()
     */
    @Override
    public IOptional createNewOptional() {
        return new Optional();
    }

    /* (non-Javadoc)
     * @see ITaskFactory#createNewSelection()
     */
    @Override
    public ISelection createNewSelection() {
        return new Selection();
    }

    /* (non-Javadoc)
     * @see ITaskFactory#createNewTaskInstance(ITask)
     */
    @Override
    public ITaskInstance createNewTaskInstance(ITask task) {
        return new TaskInstance(task);
    }

    /* (non-Javadoc)
     * @see ITaskFactory#createNewTaskInstanceList()
     */
    @Override
    public ITaskInstanceList createNewTaskInstanceList() {
        return new TaskInstance(new Sequence());
    }

    /* (non-Javadoc)
     * @see ITaskFactory#createUserSession()
     */
    @Override
    public IUserSession createUserSession() {
        return new UserSession();
    }

    /* (non-Javadoc)
     * @see ITaskFactory#createTaskModel(List<IUserSession>)
     */
    @Override
    public ITaskModel createTaskModel(List<IUserSession> userSessions) {
        return new TaskModel(userSessions);
    }

}
