//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.taskmodel.filter.types;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * <p>
 * Task type filter for {@link ITask}s.
 * </p>
 * 
 * @author Alexander Deicke
 */
public enum TaskTypeFilter implements TaskFilter<ITask> {

    EVENT_TASK_NODE(IEventTask.class),

    ITERATION(IIteration.class),

    SEQUENCE(ISequence.class),

    SELECTION(ISelection.class);

    private Class<? extends ITask> taskTypeClazz;

    private TaskTypeFilter(Class<? extends ITask> taskTypeClazz) {
        this.taskTypeClazz = taskTypeClazz;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.usability.tasktree.filters.TaskFilter#getId()
     */
    @SuppressWarnings("unchecked")
    @Override
    public Class<ITask> clazz() {
        return (Class<ITask>) this.taskTypeClazz;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.usability.tasktree.filters.TaskFilter#getId()
     */
    @SuppressWarnings("rawtypes")
    @Override
    public Predicate filterPredicate() {
        return Predicates.instanceOf(taskTypeClazz);
    }

}
