//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.taskmodel.filter;

import java.util.LinkedList;
import java.util.Queue;

import com.google.common.base.Predicate;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IMarkingTemporalRelationship;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IStructuringTemporalRelationship;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTargetFilter;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTypeFilter;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.types.TaskTypeFilter;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class IterativeDFSFilterStrategy implements TaskModelFilterStrategy {

    private FilterResult filterStatistic;

    @SuppressWarnings("unchecked")
    @Override
    public FilterResult filter(ITaskModel taskModel, EventTargetFilter eventTarget) {
        Predicate<IEventTarget> filterPredicate = eventTarget.filterPredicate();
        this.filterStatistic = new FilterResult(filterPredicate);
        traverse(taskModel);
        return this.filterStatistic;
    }

    @SuppressWarnings("unchecked")
    @Override
    public FilterResult filter(ITaskModel taskModel, EventTypeFilter eventType) {
        Predicate<IEventType> filterPredicate = eventType.filterPredicate();
        this.filterStatistic = new FilterResult(filterPredicate);
        traverse(taskModel);
        return this.filterStatistic;
    }

    @SuppressWarnings("unchecked")
    @Override
    public FilterResult filter(ITaskModel taskModel, TaskTypeFilter nodeType) {
        Predicate<ITask> filterPredicate = nodeType.filterPredicate();
        this.filterStatistic = new FilterResult(filterPredicate);
        traverse(taskModel);
        return this.filterStatistic;
    }

    private void traverse(ITaskModel taskModel) {
        Queue<ITask> unvisitedTasks = new LinkedList<ITask>();
        unvisitedTasks.addAll(taskModel.getTasks());
        while (stillUnvisitedTasks(unvisitedTasks)) {
            ITask task = unvisitedTasks.poll();
            processCurrentTask(task);
            processChildrenOfCurrentTask(unvisitedTasks, task);
        }
    }

    private boolean stillUnvisitedTasks(Queue<ITask> unvisitedTasks) {
        return !unvisitedTasks.isEmpty();
    }

    private void processCurrentTask(ITask task) {
        this.filterStatistic.addTask(task);
    }

    private void processChildrenOfCurrentTask(Queue<ITask> unvisitedTasks, ITask task) {
        if (task instanceof IStructuringTemporalRelationship) {
            for (ITask child : ((IStructuringTemporalRelationship) task).getChildren()) {
                unvisitedTasks.add(child);
            }
        }
        else if (task instanceof IMarkingTemporalRelationship) {
            unvisitedTasks.add(((IMarkingTemporalRelationship) task).getMarkedTask());
        }
    }

}
