//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.testutil;

import org.fest.assertions.core.Condition;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.usability.result.UsabilityProblemDescription;
import de.ugoe.cs.autoquest.usability.result.UsabilityProblemSeverityLevel;
import de.ugoe.cs.autoquest.usability.rules.UsabilityResult;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class FestConditionUtil {

    private FestConditionUtil() {
        // no good idea
    }

    public static Condition<UsabilityResult> noUsabilityGuidlineRecommendations() {
        return new Condition<UsabilityResult>() {

            @Override
            public boolean matches(UsabilityResult usabilityResult) {
                return !usabilityResult.hasDetectedProblems();
            }
        };
    }

    public static Condition<UsabilityResult> usabilityGuidlineRecommendations() {
        return new Condition<UsabilityResult>() {

            @Override
            public boolean matches(UsabilityResult usabilityResult) {
                return usabilityResult.hasDetectedProblems();
            }
        };
    }

    public static Condition<Optional<UsabilityProblemDescription>> present() {
        return new Condition<Optional<UsabilityProblemDescription>>() {

            @Override
            public boolean matches(Optional<UsabilityProblemDescription> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.isPresent();
            }

        };
    }

    public static Condition<Optional<UsabilityProblemDescription>> absent() {
        return new Condition<Optional<UsabilityProblemDescription>>() {

            @Override
            public boolean matches(Optional<UsabilityProblemDescription> usabilityGuidlineRecommendation) {
                return !usabilityGuidlineRecommendation.isPresent();
            }

        };
    }

    public static Condition<Optional<UsabilityProblemDescription>> infoRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityProblemDescription>>() {

            @Override
            public boolean matches(Optional<UsabilityProblemDescription> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel()
                    .equals(UsabilityProblemSeverityLevel.INFO);
            }

        };
    }

    public static Condition<Optional<UsabilityProblemDescription>> lowRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityProblemDescription>>() {

            @Override
            public boolean matches(Optional<UsabilityProblemDescription> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel()
                    .equals(UsabilityProblemSeverityLevel.LOW);
            }

        };
    }

    public static Condition<Optional<UsabilityProblemDescription>> mediumRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityProblemDescription>>() {

            @Override
            public boolean matches(Optional<UsabilityProblemDescription> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel()
                    .equals(UsabilityProblemSeverityLevel.MEDIUM);
            }

        };
    }

    public static Condition<Optional<UsabilityProblemDescription>> highRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityProblemDescription>>() {

            @Override
            public boolean matches(Optional<UsabilityProblemDescription> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel()
                    .equals(UsabilityProblemSeverityLevel.HIGH);
            }

        };
    }

}
