//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns.visitors;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.usability.rules.patterns.InteractionPatternVisitor;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTypeFilter;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.types.TaskTypeFilter;
import de.ugoe.cs.autoquest.usability.util.PatternsVisitorUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class StartsWithEventVisitor extends InteractionPatternVisitor {

    /**
     * <p>
     * TODO: comment
     * </p>
     * 
     * @param eventType
     */
    public StartsWithEventVisitor(EventTypeFilter eventType, TaskTypeFilter taskType) {
        this.eventType = eventType;
        this.taskType = taskType;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.autoquest.tasktrees.treeifc.NodeVisitor#visit(de.ugoe.cs.autoquest.tasktrees.treeifc
     * .IIteration)
     */
    public void visit(IIteration iteration) {
        iteration.getMarkedTask().accept(this);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.autoquest.tasktrees.treeifc.TaskVisitor#visit(de.ugoe.cs.autoquest.tasktrees.treeifc
     * .IOptional)
     */
    public void visit(IOptional optional) {
        optional.getMarkedTask().accept(this);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.autoquest.tasktrees.treeifc.NodeVisitor#visit(de.ugoe.cs.autoquest.tasktrees.treeifc
     * .ISequence)
     */
    public void visit(ISequence sequence) {
        PatternsVisitorUtil.firstSubtaskOf(sequence.getChildren()).accept(this);
    }

}
