//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.assertions;

import org.junit.*;

import de.ugoe.cs.autoquest.assertions.FileEqualsReplay;
import static org.junit.Assert.*;

/**
 * The class <code>FileEqualsReplayTest</code> contains tests for the class
 * <code>{@link FileEqualsReplay}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class FileEqualsReplayTest {

	private final static String ENDLINE = System.getProperty("line.separator");

	@Test
	public void testFileEqualsReplay_1() throws Exception {
		String expectedFile = "expectedFileString";
		String actualFile = "actualFileString";

		FileEqualsReplay result = new FileEqualsReplay(expectedFile, actualFile);

		assertNotNull(result);
		assertEquals(expectedFile, result.expectedFile);
		assertEquals(actualFile, result.actualFile);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testFileEqualsReplay_2() throws Exception {
		String actualFile = "actualFileString";

		new FileEqualsReplay(null, actualFile);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testFileEqualsReplay_3() throws Exception {
		String expectedFile = "expectedFileString";

		new FileEqualsReplay(expectedFile, null);
	}

	@Test
	public void testGetReplay_1() throws Exception {
		FileEqualsReplay fixture = new FileEqualsReplay("", "");

		String result = fixture.getReplay();

		assertEquals("  <fileEquals actualFile=\"\" expectedFile=\"\"/>"
				+ ENDLINE, result);
	}

	@Test
	public void testGetReplay_2() throws Exception {

		FileEqualsReplay fixture = new FileEqualsReplay("expectedFileString",
				"actualFileString");

		String result = fixture.getReplay();

		assertEquals(
				"  <fileEquals actualFile=\"actualFileString\" expectedFile=\"expectedFileString\"/>"
						+ ENDLINE, result);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(FileEqualsReplayTest.class);
	}
}