//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.htmlmonitor;

import java.net.URL;

/**
 * <p>
 * represents infos of a client together with a shown URL and its title
 * </p>
 * 
 * @author Patrick Harms
 */
class HtmlClientInfos {

    /**
     * id of a client
     */
    private String clientId;

    /**
     * browser used by the client
     */
    private String userAgent;

    /**
     * URL of the web site shown by the browser of the client
     */
    private URL url;

    /**
     * title of the web site shown by the browser of the client
     */
    private String title;

    /**
     * <p>
     * instantiates an infos object with client id, browser at client side, the URL of the
     * shown website and its title.
     * </p>
     *
     * @param clientId  id of a client
     * @param userAgent browser used by the client
     * @param url       URL of the web site shown by the browser of the client
     * @param title     title of the web site shown by the browser of the client
     */
    HtmlClientInfos(String clientId, String userAgent, URL url, String title) {
        this.clientId = clientId;
        this.userAgent = userAgent;
        this.url = url;
        this.title = title;
    }

    /**
     * @return the clientId
     */
    String getClientId() {
        return clientId;
    }

    /**
     * @return the userAgent
     */
    String getUserAgent() {
        return userAgent;
    }

    /**
     * @return the url
     */
    URL getUrl() {
        return url;
    }

    /**
     * @return the title
     */
    String getTitle() {
        return title;
    }

}
