//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

import java.util.List;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;

/**
 * <p>
 * factory for the different task types
 * </p>
 * 
 * @author Patrick Harms
 */
public interface ITaskFactory {

    /**
     * <p>
     * creates a new event task with the given type and target
     * </p>
     * 
     * @param eventType   the type of the event represented by the task
     * @param eventTarget the target of the event represented by the task
     * 
     * @return the event task
     */
    IEventTask createNewEventTask(IEventType eventType, IEventTarget eventTarget);

    /**
     * <p>
     * creates a new empty sequence
     * </p>
     * 
     * @return the sequence
     */
    ISequence createNewSequence();

    /**
     * <p>
     * creates a new empty iteration
     * </p>
     * 
     * @return the iteration
     */
    IIteration createNewIteration();

    /**
     * <p>
     * creates a new empty optional
     * </p>
     * 
     * @return the optional
     */
    IOptional createNewOptional();

    /**
     * <p>
     * creates a new empty selection
     * </p>
     * 
     * @return the selection
     */
    ISelection createNewSelection();

    /**
     * <p>
     * creates a new task instance with the given task as its model
     * </p>
     * 
     * @param task the model of the task instance to be created
     * 
     * @return the task instance
     */
    ITaskInstance createNewTaskInstance(ITask task);

    /**
     * <p>
     * creates a new empty task instance list
     * </p>
     * 
     * @return the task instance list
     */
    ITaskInstanceList createNewTaskInstanceList();

    /**
     * <p>
     * creates a new empty user session
     * </p>
     * 
     * @return the user session
     */
    IUserSession createUserSession();

    /**
     * <p>
     * creates a task model based on the provided user sessions
     * </p>
     * 
     * @param userSessions the session based on which the task model shall be created
     * 
     * @return the task model
     */
    ITaskModel createTaskModel(List<IUserSession> userSessions);

}
