//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.util;

import static org.junit.Assert.*;

import org.junit.Test;

/**
 *
 */
public class StopWatchTest {

    /**
     * 
     */
    @Test
    public void test_01() throws Exception {
        StopWatch stopWatch = new StopWatch();
        
        String id = "id1";
        stopWatch.start(id);
        Thread.sleep(100);
        stopWatch.stop(id);
        
        assertTrue((98 < stopWatch.getDuration(id)) && (stopWatch.getDuration(id) < 102));
    }

    /**
     * 
     */
    @Test
    public void test_02() throws Exception {
        StopWatch stopWatch = new StopWatch();
        
        String id;
        for (int i = 0; i < 10; i++) {
            id = "id" + i;
            stopWatch.start(id);
        }
        
        for (int i = 0; i < 10; i++) {
            id = "id" + i;
            stopWatch.stop(id);
        }
        
        for (int i = 0; i < 10; i++) {
            id = "id" + i;
            assertTrue(stopWatch.getDuration(id) >= 0);
        }
    }

    /**
     * 
     */
    @Test(expected=IllegalArgumentException.class)
    public void test_03() throws Exception {
        StopWatch stopWatch = new StopWatch();
        
        stopWatch.stop("id1");
    }

    /**
     * 
     */
    @Test(expected=IllegalArgumentException.class)
    public void test_04() throws Exception {
        StopWatch stopWatch = new StopWatch();
        
        stopWatch.getDuration("id1");
    }

    /**
     * 
     */
    @Test(expected=IllegalStateException.class)
    public void test_05() throws Exception {
        StopWatch stopWatch = new StopWatch();
        
        String id = "id1";
        stopWatch.start(id);
        stopWatch.stop(id);
        
        stopWatch.stop(id);
    }

    /**
     * 
     */
    @Test(expected=IllegalStateException.class)
    public void test_06() throws Exception {
        StopWatch stopWatch = new StopWatch();
        
        String id = "id1";
        stopWatch.start(id);
        stopWatch.getDuration(id);
        
        stopWatch.stop(id);
    }

    /**
     * 
     */
    @Test(expected=IllegalStateException.class)
    public void test_07() throws Exception {
        StopWatch stopWatch = new StopWatch();
        
        String id = "id1";
        stopWatch.start(id);
        
        stopWatch.start(id);
    }


    /**
     * 
     */
    @Test
    public void test_08() throws Exception {
        StopWatch stopWatch = new StopWatch();
        
        String id;
        // start 0 - 4
        for (int i = 0; i < 5; i++) {
            id = "id" + i;
            stopWatch.start(id);
        }
        
        Thread.sleep(10);
        
        // stop 0 - 2
        for (int i = 0; i < 3; i++) {
            id = "id" + i;
            stopWatch.stop(id);
        }
        
        // start 5 - 7
        for (int i = 5; i < 8; i++) {
            id = "id" + i;
            stopWatch.start(id);
        }
        
        Thread.sleep(10);
        
        // stop 3 - 6
        for (int i = 3; i < 7; i++) {
            id = "id" + i;
            stopWatch.stop(id);
        }
        
        // start 8 - 9
        for (int i = 8; i < 10; i++) {
            id = "id" + i;
            stopWatch.start(id);
        }
        
        Thread.sleep(10);
        
        // start 0 - 6
        for (int i = 0; i < 7; i++) {
            id = "id" + i;
            stopWatch.start(id);
        }

        Thread.sleep(10);
        
        // stop all
        for (int i = 2; i < 7; i++) {
            id = "id" + i;
            stopWatch.stop(id);
        }

        // start all
        for (int i = 2; i < 7; i++) {
            id = "id" + i;
            stopWatch.start(id);
        }
        
        Thread.sleep(10);
        
        // stop all and ensure, that durations are returned
        for (int i = 2; i < 7; i++) {
            id = "id" + i;
            assertTrue(stopWatch.getDuration(id) >= 10);
        }
    }
}
