package de.ugoe.cs.eventbench.web.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.web.WeblogParser;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDloadSessionsFromClickstream implements Command {

	@Override
	public void run(List<Object> parameters) {
		if( parameters.size() < 1 ) {
			throw new InvalidParameterException();
		}
		String source = (String) parameters.get(0);
		int timeout = -1;
		int minLength = -1;
		if( parameters.size() ==3 ) {
			timeout = Integer.parseInt((String) parameters.get(1));
			minLength = Integer.parseInt((String) parameters.get(2));
		}
		
		WeblogParser parser = new WeblogParser();;
		if( timeout!=-1 ) {
			parser.setTimeout(timeout);
			parser.setMinLength(minLength);
		}
		try {
			parser.parseFile(source);
		} catch (FileNotFoundException e) {
			Console.println(e.getMessage());
		} catch (IOException e) {
			Console.println(e.getMessage());
		} catch (ParseException e) {
			Console.println("Invalid format of date stamps.");
			Console.println(e.getMessage());
		} catch (URISyntaxException e) {
			Console.println("Invalid URI!");
			Console.println(e.getMessage());
		}
		
		if( GlobalDataContainer.getInstance().addData("sequences", parser.getSequences()) ) {
			Console.traceln("Old data \"" + "sequences" + "\" overwritten");
		}
	}
	
	@Override
	public void help() {
		Console.println("Usage: loadSessionsFromClickstream <filename> {<timeout> <minSessionLength>}");
	}

}
