//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.util;

/**
 * <p>
 * Helper class that provides methods to simplify working with {@link String}s.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
final public class StringTools {

    /**
     * <p>
     * Private constructor to prevent initializing of the class.
     * </p>
     */
    private StringTools() {

    }

    /**
     * <p>
     * Simplifies use of operation system specific line separators.
     * </p>
     */
    public final static String ENDLINE = System.getProperty("line.separator");

    /**
     * <p>
     * Replaces all occurrences of {@literal &, <, >, ', and "} with their respective XML entities
     * {@literal &amp;, &lt;, &gt;, &apos;, and &quot;} without destroying already existing
     * entities.
     * </p>
     * 
     * @param str
     *            String where the XML entities are to be replaced
     * @return new String, where the XML entities are used instead of the literals
     */
    public static String xmlEntityReplacement(String str) {
        String result = str;
        if (result != null && !"".equals(result)) {
            result = result.replaceAll("&(?!(?:lt|gt|apos|quot|amp);)", "&amp;");
            result = result.replaceAll("<", "&lt;");
            result = result.replaceAll(">", "&gt;");
            result = result.replaceAll("'", "&apos;");
            result = result.replaceAll("\"", "&quot;");
        }
        return result;
    }
}
