/*
 * Decompiled with CFR 0.152.
 */
package jdepend.swingui;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageComparator;

public abstract class PackageNode {
    private PackageNode parent;
    private JavaPackage jPackage;
    private ArrayList children;
    private static NumberFormat formatter = NumberFormat.getInstance();

    public PackageNode(PackageNode parent, JavaPackage jPackage) {
        this.parent = parent;
        this.jPackage = jPackage;
        this.children = null;
    }

    public JavaPackage getPackage() {
        return this.jPackage;
    }

    public PackageNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.getCoupledPackages().size() <= 0;
    }

    protected abstract PackageNode makeNode(PackageNode var1, JavaPackage var2);

    protected abstract Collection getCoupledPackages();

    public boolean isChild(JavaPackage jPackage) {
        return true;
    }

    public ArrayList getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
            ArrayList packages = new ArrayList(this.getCoupledPackages());
            Collections.sort(packages, new PackageComparator(PackageComparator.byName()));
            Iterator i = packages.iterator();
            while (i.hasNext()) {
                JavaPackage jPackage = (JavaPackage)i.next();
                if (!this.isChild(jPackage)) continue;
                PackageNode childNode = this.makeNode(this, jPackage);
                this.children.add(childNode);
            }
        }
        return this.children;
    }

    public String toMetricsString() {
        StringBuffer label = new StringBuffer();
        label.append(this.getPackage().getName());
        label.append("  (");
        label.append("CC: " + this.getPackage().getConcreteClassCount() + "  ");
        label.append("AC: " + this.getPackage().getAbstractClassCount() + "  ");
        label.append("Ca: " + this.getPackage().afferentCoupling() + "  ");
        label.append("Ce: " + this.getPackage().efferentCoupling() + "  ");
        label.append("A: " + PackageNode.format(this.getPackage().abstractness()) + "  ");
        label.append("I: " + PackageNode.format(this.getPackage().instability()) + "  ");
        label.append("D: " + PackageNode.format(this.getPackage().distance()) + "  ");
        label.append("V: " + this.getPackage().getVolatility());
        if (this.getPackage().containsCycle()) {
            label.append(" Cyclic");
        }
        label.append(")");
        return label.toString();
    }

    public String toString() {
        if (this.getParent().getParent() == null) {
            return this.toMetricsString();
        }
        return this.getPackage().getName();
    }

    private static String format(float f) {
        return formatter.format(f);
    }

    static {
        formatter.setMaximumFractionDigits(2);
    }
}

