//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.taskmodel.filter.types;

import com.google.common.base.Preconditions;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.FilterResult;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.TaskModelFilterStrategy;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class TaskModelFilter {

    private final TaskModelFilterStrategy taskModelFilterStrategy;

    public TaskModelFilter(TaskModelFilterStrategy treeTraversalStrategy) {
        Preconditions.checkNotNull(treeTraversalStrategy);
        this.taskModelFilterStrategy = treeTraversalStrategy;
    }

    public FilterEventTargetStep filterByEventTarget(EventTargetFilter eventTarget) {
        return new FilterEventTargetStep(eventTarget);
    }

    public FilterEventTypeStep filterByEventType(EventTypeFilter eventType) {
        return new FilterEventTypeStep(eventType);
    }

    public FilterNodeTypeStep filterByNodeType(TaskTypeFilter nodeType) {
        return new FilterNodeTypeStep(nodeType);
    }

    public class FilterEventTargetStep {

        private final EventTargetFilter eventTarget;

        public FilterEventTargetStep(EventTargetFilter eventTarget) {
            this.eventTarget = eventTarget;
        }

        public FilterResult from(ITaskModel taskModel) {
            return taskModelFilterStrategy.filter(taskModel, eventTarget);
        }

    }

    public class FilterEventTypeStep {

        private final EventTypeFilter eventType;

        public FilterEventTypeStep(EventTypeFilter eventType) {
            this.eventType = eventType;
        }

        public FilterResult from(ITaskModel taskModel) {
            return taskModelFilterStrategy.filter(taskModel, eventType);
        }

    }

    public class FilterNodeTypeStep {

        private final TaskTypeFilter nodeType;

        public FilterNodeTypeStep(TaskTypeFilter nodeType) {
            this.nodeType = nodeType;
        }

        public FilterResult from(ITaskModel taskModel) {
            return taskModelFilterStrategy.filter(taskModel, nodeType);
        }

    }
}
