//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.usability.result.UsabilityProblemDescription;
import de.ugoe.cs.autoquest.usability.rules.UsabilityMetric;
import de.ugoe.cs.autoquest.usability.rules.UsabilityUsageProblem;

/**
 * <p>
 * Helper class, which calls the evaluation method depending on the type of the usability rule.
 * </p>
 * 
 * @author Alexander Deicke
 */
public class EvaluationMethodCaller {

    /**
     * 
     * <p>
     * Calls evaluation method of a usability metric.
     * </p>
     * 
     * @param metric
     *            on which evaluation method should be called
     * @return description of metric/defect, iff metric exceeds predefined threshold
     */
    public Optional<UsabilityProblemDescription> check(UsabilityMetric metric) {
        return metric.calculate();
    }

    /**
     * 
     * <p>
     * Calls evaluation method of a usability usage defect.
     * </p>
     * 
     * @param usageDefect
     *            on which evaluation method should be called
     * @return description of usage defect, iff it was detected during the usability evaluation
     */
    public Optional<UsabilityProblemDescription> check(UsabilityUsageProblem usageDefect) {
        return usageDefect.check();
    }
}
