//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usageprofiles;

/**
 * <p>
 * Default implementation for the {@link SymbolComparator} using the equals method of the provided
 * symbols for comparison. The {@link #equals(Object, Object)} method will also return true if
 * both symbols are <code>null</code> 
 * </p>
 * 
 * @author Patrick Harms
 */
public class DefaultSymbolComparator<T> implements SymbolComparator<T> {

    /**  */
    private static final long serialVersionUID = 1L;

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.temporalrelation.SymbolComparator#equals(Object, Object)
     */
    @Override
    public boolean equals(T symbol1, T symbol2) {
        if (symbol1 == null) {
            return (symbol2 == null);
        }
        else {
            return symbol1.equals(symbol2);
        }
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.usageprofiles.SymbolComparator#getBucketSearchOrder(Object)
     */
    @Override
    public int[] getBucketSearchOrder(T symbol) {
        if (symbol != null) {
            return new int[] { symbol.hashCode() };
        }
        else {
            return null;
        }
    }

}
