//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns.visitors;

import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.usability.rules.patterns.InteractionPatternVisitor;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTypeFilter;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.types.TaskTypeFilter;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class ContainsEventVisitor extends InteractionPatternVisitor {

    /**
     * <p>
     * TODO: comment
     * </p>
     * 
     * @param containsType
     */
    public ContainsEventVisitor(EventTypeFilter containsType, TaskTypeFilter taskType) {
        this.eventType = containsType;
        this.taskType = taskType;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.autoquest.tasktrees.treeifc.NodeVisitor#visit(de.ugoe.cs.autoquest.tasktrees.treeifc
     * .IIteration)
     */
    public void visit(IIteration iteration) {
        checkTaskAndReturnIfPatternIsPresent(iteration.getMarkedTask());
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.autoquest.tasktrees.treeifc.TaskVisitor#visit(de.ugoe.cs.autoquest.tasktrees.treeifc
     * .IOptional)
     */
    public void visit(IOptional optional) {
        checkTaskAndReturnIfPatternIsPresent(optional.getMarkedTask());
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.autoquest.tasktrees.treeifc.NodeVisitor#visit(de.ugoe.cs.autoquest.tasktrees.treeifc
     * .ISequence)
     */
    public void visit(ISequence sequence) {
        checkAllChildrenAndReturnIfPatternIsPresent(sequence.getChildren());
    }

    private void checkAllChildrenAndReturnIfPatternIsPresent(List<ITask> children) {
        for (ITask task : children) {
            if (checkTaskAndReturnIfPatternIsPresent(task)) {
                break;
            }
        }
    }

    /**
     *
     */
    private boolean checkTaskAndReturnIfPatternIsPresent(ITask task) {
        task.accept(this);
        return this.present;
    }
}
